/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicFluidStill
extends BlockLogicFluid {
    @NotNull
    public final Block<?> blockFlowing;

    public BlockLogicFluidStill(@NotNull Block<?> block, @NotNull Material material, @NotNull Fluid fluid, @NotNull Block<?> blockFlowing) {
        super(block, material, fluid);
        block.setTicking(this.fluid.shouldTick());
        this.blockFlowing = blockFlowing;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        if (id == Side.TOP.getId()) {
            return;
        }
        if (world.getBlockId(tilePos) == this.block.id()) {
            this.setFlowing(world, tilePos);
        }
    }

    private void setFlowing(@NotNull World world, @NotNull TilePos tilePos) {
        int meta = world.getBlockData(tilePos);
        world.noNeighborUpdate = true;
        world.setBlockIdData(tilePos, this.blockFlowing.id(), meta);
        world.markBlocksDirty(tilePos, tilePos);
        world.scheduleBlockUpdate(tilePos, this.blockFlowing.id(), this.tickDelay());
        world.noNeighborUpdate = false;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.fluid.updateTickStill(this, world, tilePos, rand);
    }
}

