/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlockLayerLeaves;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLayerLeaves
extends BlockLogicLayerBase {
    public static final int MASK_PERMANENT = 128;

    public BlockLogicLayerLeaves(Block<? extends BlockLogicLayerLeaves> block, Block<?> fullBlock, Material material) {
        super(block, fullBlock, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setTicking(true);
        block.setBlockItem(() -> new ItemBlockLayerLeaves(block));
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    public void accumulate(@NotNull World world, @NotNull TilePos tilePos) {
        int myMetadata = world.getBlockData(tilePos);
        if (myMetadata == 7) {
            return;
        }
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            TilePos p = (TilePos)tilePos.add(Direction.horizontalDirections[i]);
            if (world.isBlockOpaqueCube(p) || world.getBlockId(p) == this.block.id() && world.getBlockData(p) >= myMetadata) continue;
            return;
        }
        world.setBlockData(tilePos, myMetadata + 1);
        world.markBlockNeedsUpdate(tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos down = (TilePos)tilePos.down();
        Block<?> b = world.getBlock(down);
        if (b == null || !b.isSolidRender() && !(b.getLogic() instanceof BlockLogicLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(down);
        return material.blocksMotion();
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this, (data & 0xFFFFFF7F) + 1);
                break;
            }
            case PICK_BLOCK: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        int metadata;
        if (world.getSeasonManager().getCurrentSeason() != null && !world.getSeasonManager().getCurrentSeason().hasFallingLeaves && !BlockLogicLayerLeaves.isPermanent(metadata = world.getBlockData(tilePos)) && rand.nextInt(2) == 0) {
            if (metadata > 0) {
                world.setBlockData(tilePos, metadata - 1);
            } else {
                world.setBlockIdNotify(tilePos, 0);
            }
        }
    }

    public static boolean isPermanent(int meta) {
        return (meta & 0x80) != 0;
    }

    public static int setPermanent(int meta, boolean flag) {
        if (flag) {
            return meta | 0x80;
        }
        return meta & 0xFFFFFF7F;
    }
}

