/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPumpkinRedstone
extends BlockLogicVeryRotatable {
    public BlockLogicPumpkinRedstone(@NotNull Block<?> block) {
        super(block, Material.vegetable);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.add(dir), this.id());
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.add(dir), this.id());
        }
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        Side mySide = Side.getSideById(source.getBlockData(tilePos));
        return mySide == side.getOpposite();
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePos tilePos) {
        return 0;
    }
}

