/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicTorch;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicTorchRedstone
extends BlockLogicTorch {
    private final boolean torchActive;

    public BlockLogicTorchRedstone(@NotNull Block<?> block, boolean isActive) {
        super(block);
        this.torchActive = isActive;
        block.setTicking(true);
    }

    @Override
    public int tickDelay() {
        return 2;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.getBlockData(tilePos) == 0) {
            super.onPlacedByWorld(world, tilePos);
        }
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.id());
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if (this.torchActive) {
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.id());
        }
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        if (!this.torchActive) {
            return false;
        }
        int direction = source.getBlockData(tilePos) & 7;
        return switch (direction) {
            case 5 -> {
                if (side != Side.TOP) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (side != Side.NORTH) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (side != Side.SOUTH) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (side != Side.WEST) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (side != Side.EAST) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean hasNeighborSignal(World world, @NotNull TilePos tilePos) {
        int direction = world.getBlockData(tilePos) & 7;
        return switch (direction) {
            case 5 -> world.hasSignal((TilePos)tilePos.down(), Side.BOTTOM);
            case 4 -> world.hasSignal((TilePos)tilePos.south(), Side.SOUTH);
            case 3 -> world.hasSignal((TilePos)tilePos.north(), Side.NORTH);
            case 2 -> world.hasSignal((TilePos)tilePos.east(), Side.EAST);
            case 1 -> world.hasSignal((TilePos)tilePos.west(), Side.WEST);
            default -> false;
        };
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        boolean isPowered = this.hasNeighborSignal(world, tilePos);
        if (this.torchActive) {
            if (isPowered) {
                world.setBlockIdDataNotify(tilePos, Blocks.TORCH_REDSTONE_IDLE.id(), world.getBlockData(tilePos));
            }
        } else if (!isPowered) {
            world.setBlockIdDataNotify(tilePos, Blocks.TORCH_REDSTONE_ACTIVE.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        if (side == Side.BOTTOM) {
            return this.isEmittingSignal(world, tilePos, side);
        }
        return false;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.TORCH_REDSTONE_ACTIVE)};
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        if (!this.torchActive) {
            return;
        }
        int direction = world.getBlockData(tilePos) & 7;
        double px = (double)tilePos.x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)tilePos.y + 0.7 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double pz = (double)tilePos.z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double verticalOffset = 0.22;
        double horizontalOffset = 0.27;
        int redstoneBrightness = 10;
        switch (direction) {
            case 1: {
                world.spawnParticle("reddust", px - horizontalOffset, py + verticalOffset, pz, 0.0, 0.0, 0.0, 10);
                break;
            }
            case 2: {
                world.spawnParticle("reddust", px + horizontalOffset, py + verticalOffset, pz, 0.0, 0.0, 0.0, 10);
                break;
            }
            case 3: {
                world.spawnParticle("reddust", px, py + verticalOffset, pz - horizontalOffset, 0.0, 0.0, 0.0, 10);
                break;
            }
            case 4: {
                world.spawnParticle("reddust", px, py + verticalOffset, pz + horizontalOffset, 0.0, 0.0, 0.0, 10);
                break;
            }
            case 5: {
                world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
            }
        }
    }
}

