/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicWireRedstone
extends BlockLogic
implements ISupportable {
    public static final int SIGNAL_MIN = 0;
    public static final int SIGNAL_MAX = 15;
    public static final int SIGNAL_STEP = 1;
    public static final int MASK_DIRECTION = 240;
    public static final int MASK_POWER = 15;
    private boolean shouldSignal = true;
    private final Set<TilePos> toUpdate = new HashSet<TilePos>();

    public BlockLogicWireRedstone(@NotNull Block<?> block) {
        super(block, Material.decoration);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    private void updatePowerStrength(@NotNull World world, @NotNull TilePos tilePos) {
        this.updatePowerStrength(world, tilePos, tilePos);
        ArrayList<TilePos> toUpdate = new ArrayList<TilePos>(this.toUpdate);
        this.toUpdate.clear();
        for (TilePos pos : toUpdate) {
            world.notifyBlocksOfNeighborChange(pos, this.id());
        }
    }

    private void updatePowerStrength(@NotNull World world, @NotNull TilePos curPos, @NotNull TilePos lastPos) {
        int strength = world.getBlockData(curPos);
        int newStrength = 0;
        this.shouldSignal = false;
        boolean hasNeighborSignal = world.hasNeighborSignal(curPos);
        this.shouldSignal = true;
        if (hasNeighborSignal) {
            newStrength = 15;
        } else {
            for (int i = 0; i < 4; ++i) {
                TilePos iPos = new TilePos(curPos);
                switch (i) {
                    case 0: {
                        --iPos.x;
                        break;
                    }
                    case 1: {
                        ++iPos.x;
                        break;
                    }
                    case 2: {
                        --iPos.z;
                        break;
                    }
                    case 3: {
                        ++iPos.z;
                    }
                }
                if (!iPos.equals(lastPos)) {
                    newStrength = this.checkTarget(world, iPos, newStrength);
                }
                if (world.isBlockNormalCube(iPos) && !world.isBlockNormalCube((TilePos)curPos.up())) {
                    TilePos iUp = (TilePos)iPos.up();
                    if (iUp.equals(lastPos)) continue;
                    newStrength = this.checkTarget(world, iUp, newStrength);
                    continue;
                }
                TilePos iDown = (TilePos)iPos.down();
                if (world.isBlockNormalCube(iPos) || iDown.equals(lastPos)) continue;
                newStrength = this.checkTarget(world, iDown, newStrength);
            }
            newStrength = newStrength > 0 ? --newStrength : 0;
        }
        if (strength != newStrength) {
            int blockId = world.getBlockId(curPos);
            if (blockId == this.id() || blockId == Blocks.FLUID_LAVA_STILL.id() || blockId == Blocks.FLUID_LAVA_FLOWING.id()) {
                world.noNeighborUpdate = true;
                world.setBlockDataNotify(curPos, newStrength | world.getBlockData(curPos) & 0xF0);
                world.markBlocksDirty(curPos, curPos);
                world.noNeighborUpdate = false;
            }
            for (int i = 0; i < 4; ++i) {
                TilePos iPos = (TilePos)curPos.down();
                switch (i) {
                    case 0: {
                        --iPos.x;
                        break;
                    }
                    case 1: {
                        ++iPos.x;
                        break;
                    }
                    case 2: {
                        --iPos.z;
                        break;
                    }
                    case 3: {
                        ++iPos.z;
                    }
                }
                if (world.isBlockNormalCube(new TilePos(iPos.x, curPos.y, iPos.z))) {
                    iPos.y += 2;
                }
                int targetStrength = this.checkTarget(world, new TilePos(iPos.x, curPos.y, iPos.z), -1);
                newStrength = world.getBlockData(curPos) & 0xF;
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength >= 0 && targetStrength != newStrength) {
                    this.updatePowerStrength(world, new TilePos(iPos.x, curPos.y, iPos.z), curPos);
                }
                targetStrength = this.checkTarget(world, iPos, -1);
                newStrength = world.getBlockData(curPos) & 0xF;
                if (newStrength > 0) {
                    --newStrength;
                }
                if (targetStrength < 0 || targetStrength == newStrength) continue;
                this.updatePowerStrength(world, iPos, curPos);
            }
            if (strength == 0 || newStrength == 0) {
                this.toUpdate.add(new TilePos(curPos));
                this.toUpdate.add((TilePos)curPos.west());
                this.toUpdate.add((TilePos)curPos.east());
                this.toUpdate.add((TilePos)curPos.down());
                this.toUpdate.add((TilePos)curPos.up());
                this.toUpdate.add((TilePos)curPos.north());
                this.toUpdate.add((TilePos)curPos.south());
            }
        }
    }

    private void checkCornerChangeAt(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.getBlockId(tilePos) == this.id()) {
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.west(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.east(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.north(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.south(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
        }
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        super.onPlacedByWorld(world, tilePos);
        if (world.isClientSide) {
            return;
        }
        TilePos up = (TilePos)tilePos.up();
        TilePos down = (TilePos)tilePos.down();
        TilePos north = (TilePos)tilePos.north();
        TilePos south = (TilePos)tilePos.south();
        TilePos west = (TilePos)tilePos.west();
        TilePos east = (TilePos)tilePos.east();
        world.getWireHandler().onWireAdded(tilePos);
        world.notifyBlocksOfNeighborChange(up, this.id());
        world.notifyBlocksOfNeighborChange(down, this.id());
        this.checkCornerChangeAt(world, west);
        this.checkCornerChangeAt(world, east);
        this.checkCornerChangeAt(world, north);
        this.checkCornerChangeAt(world, south);
        if (world.isBlockNormalCube(west)) {
            this.checkCornerChangeAt(world, (TilePos)west.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)west.down());
        }
        if (world.isBlockNormalCube(east)) {
            this.checkCornerChangeAt(world, (TilePos)east.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)east.down());
        }
        if (world.isBlockNormalCube(north)) {
            this.checkCornerChangeAt(world, (TilePos)north.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)north.down());
        }
        if (world.isBlockNormalCube(south)) {
            this.checkCornerChangeAt(world, (TilePos)south.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)south.down());
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        super.onRemoved(world, tilePos, data);
        if (world.isClientSide) {
            return;
        }
        TilePos up = (TilePos)tilePos.up();
        TilePos down = (TilePos)tilePos.down();
        TilePos north = (TilePos)tilePos.north();
        TilePos south = (TilePos)tilePos.south();
        TilePos west = (TilePos)tilePos.west();
        TilePos east = (TilePos)tilePos.east();
        world.notifyBlocksOfNeighborChange(up, this.id());
        world.notifyBlocksOfNeighborChange(down, this.id());
        world.getWireHandler().onWireRemoved(tilePos, new BlockState(this.id(), world.getBlockData(tilePos)));
        this.checkCornerChangeAt(world, west);
        this.checkCornerChangeAt(world, east);
        this.checkCornerChangeAt(world, north);
        this.checkCornerChangeAt(world, south);
        if (world.isBlockNormalCube(west)) {
            this.checkCornerChangeAt(world, (TilePos)west.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)west.down());
        }
        if (world.isBlockNormalCube(east)) {
            this.checkCornerChangeAt(world, (TilePos)east.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)east.down());
        }
        if (world.isBlockNormalCube(north)) {
            this.checkCornerChangeAt(world, (TilePos)north.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)north.down());
        }
        if (world.isBlockNormalCube(south)) {
            this.checkCornerChangeAt(world, (TilePos)south.up());
        } else {
            this.checkCornerChangeAt(world, (TilePos)south.down());
        }
    }

    private int checkTarget(@NotNull World world, @NotNull TilePos tilePos, int sourceStrength) {
        if (world.getBlockId(tilePos) != this.id()) {
            return sourceStrength;
        }
        int targetStrength = world.getBlockData(tilePos) & 0xF;
        return Math.max(targetStrength, sourceStrength);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (world.isClientSide || world.getWireHandler().onWireUpdated(tilePos)) {
            return;
        }
        int strength = world.getBlockData(tilePos);
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, strength, null, null);
            world.setBlockIdNotify(tilePos, 0);
        } else {
            this.updatePowerStrength(world, tilePos);
        }
        super.onNeighborChanged(world, tilePos, id);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE)};
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return this.shouldSignal && this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        boolean posZShouldConnectTo;
        if (!this.shouldSignal) {
            return false;
        }
        int data = source.getBlockData(tilePos);
        if ((data & 0xF) == 0) {
            return false;
        }
        if (side == Side.TOP) {
            return true;
        }
        boolean negXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(-1, 0, 0), Side.WEST) || !source.isBlockNormalCube(tilePos.add(-1, 0, 0)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, -1, 0), Side.NONE, Side.BOTTOM);
        boolean posXShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(1, 0, 0), Side.EAST) || !source.isBlockNormalCube(tilePos.add(1, 0, 0)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(1, -1, 0), Side.NONE, Side.BOTTOM);
        boolean negZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(0, 0, -1), Side.NORTH) || !source.isBlockNormalCube(tilePos.add(0, 0, -1)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(0, -1, -1), Side.NONE, Side.BOTTOM);
        boolean bl = posZShouldConnectTo = BlockLogicWireRedstone.shouldConnectTo(source, tilePos.add(0, 0, 1), Side.SOUTH) || !source.isBlockNormalCube(tilePos.add(0, 0, 1)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(0, -1, 1), Side.NONE, Side.BOTTOM);
        if (!source.isBlockNormalCube((TilePos)tilePos.up())) {
            if (source.isBlockNormalCube(tilePos.add(-1, 0, 0)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0), Side.NONE, Side.TOP)) {
                negXShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(1, 0, 0)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0), Side.NONE, Side.TOP)) {
                posXShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(0, 0, -1)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0), Side.NONE, Side.TOP)) {
                negZShouldConnectTo = true;
            }
            if (source.isBlockNormalCube(tilePos.add(0, 0, 1)) && BlockLogicWireRedstone.shouldConnectToDiagonal(source, tilePos.add(-1, 1, 0), Side.NONE, Side.TOP)) {
                posZShouldConnectTo = true;
            }
        }
        if (source instanceof World) {
            int newDirectionEast;
            int newDirectionWest;
            int newDirectionSouth;
            World world = (World)source;
            int direction = (data & 0xF0) >> 4;
            int newDirectionNorth = negZShouldConnectTo ? 1 : 0;
            int newDirection = newDirectionNorth | (newDirectionSouth = (posZShouldConnectTo ? 1 : 0) << 1) | (newDirectionWest = (negXShouldConnectTo ? 1 : 0) << 2) | (newDirectionEast = (posXShouldConnectTo ? 1 : 0) << 3);
            if (direction != newDirection) {
                data &= 0xFFFFFF0F;
                world.setBlockData(tilePos, data |= newDirection << 4);
            }
        }
        boolean isXConnected = posXShouldConnectTo || negXShouldConnectTo;
        boolean isZConnected = posZShouldConnectTo || negZShouldConnectTo;
        return !isZConnected && !isXConnected && side.getAxis() != Axis.Y || side == Side.SOUTH && negZShouldConnectTo || side == Side.NORTH && posZShouldConnectTo || side == Side.EAST && negXShouldConnectTo || side == Side.WEST && posXShouldConnectTo || side == Side.NORTH && negZShouldConnectTo && !isXConnected || side == Side.SOUTH && posZShouldConnectTo && !isXConnected || side == Side.WEST && negXShouldConnectTo && !isZConnected || side == Side.EAST && posXShouldConnectTo && !isZConnected;
    }

    @Override
    public boolean isSignalSource() {
        return this.shouldSignal;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        int meta = world.getBlockData(tilePos) & 0xF;
        if (meta == 0) {
            return;
        }
        double px = (double)tilePos.x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        double py = (double)tilePos.y + 0.0625;
        double pz = (double)tilePos.z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
        int redstoneBrightness = meta & 0xF;
        world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, redstoneBrightness);
    }

    @Deprecated
    public static boolean shouldConnectTo(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side) {
        return BlockLogicWireRedstone.shouldConnectTo(worldSource, new TilePos(x, y, z), side);
    }

    public static boolean shouldConnectTo(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        Block<?> block = source.getBlock(tilePos);
        if (block == null) {
            return false;
        }
        if (block == Blocks.WIRE_REDSTONE) {
            return true;
        }
        if (block == Blocks.PUMPKIN_REDSTONE) {
            if (side == Side.NONE || side.isVertical()) {
                return false;
            }
            return Side.getSideById(source.getBlockData(tilePos)).getOpposite() == side;
        }
        if (block == Blocks.MATCHER || block == Blocks.MATCHER_ACTIVE) {
            return BlockLogicAxisAligned.metaToAxis(source.getBlockData(tilePos)) != side.getAxis();
        }
        if (block == Blocks.REPEATER_IDLE || block == Blocks.REPEATER_ACTIVE) {
            Side direction = BlockLogicRepeater.getSideFromMeta(source.getBlockData(tilePos));
            return side == direction || side == direction.getOpposite();
        }
        return block.isSignalSource();
    }

    @Deprecated
    public static boolean shouldConnectToDiagonal(@NotNull WorldSource worldSource, int x, int y, int z, @NotNull Side side1, @NotNull Side side2) {
        return BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, new TilePos(x, y, z), side1, side2);
    }

    public static boolean shouldConnectToDiagonal(@NotNull WorldSource worldSource, @NotNull TilePos tilePos, @NotNull Side side1, @NotNull Side side2) {
        if (side2 != Side.TOP && side2 != Side.BOTTOM) {
            return false;
        }
        int blockId = worldSource.getBlockId(tilePos);
        return blockId == Blocks.WIRE_REDSTONE.id();
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return side == Side.BOTTOM ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }
}

