/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.IPaintable;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public interface IPainted
extends IPaintable {
    @NotNull
    public DyeColor fromMetadata(int var1);

    public int toMetadata(@NotNull DyeColor var1);

    public int stripColorFromMetadata(int var1);

    public void removeDye(@NotNull World var1, @NotNull TilePos var2);

    @Deprecated
    default public void removeDye(@NotNull World world, int x, int y, int z) {
        this.removeDye(world, new TilePos(x, y, z));
    }

    @NotNull
    default public DyeColor getColor(@NotNull World world, @NotNull TilePos tilePos) {
        return this.fromMetadata(world.getBlockData(tilePos));
    }

    @Deprecated
    default public DyeColor getColor(@NotNull World world, int x, int y, int z) {
        return this.getColor(world, new TilePos(x, y, z));
    }

    @Override
    default public void setColor(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        int data = world.getBlockData(tilePos);
        world.setBlockDataNotify(tilePos, this.stripColorFromMetadata(data) | this.toMetadata(color));
    }
}

