/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import com.mojang.nbt.tags.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityMovingPistonBlock
extends TileEntity {
    public static final int TICKS_TO_EXTEND = 2;
    private static final List<Entity> entityBuffer = new ArrayList<Entity>();
    private int movedId;
    private int movedData;
    @Nullable
    private TileEntity movedEntity;
    private Direction direction;
    private boolean extending;
    private boolean isSourcePiston;
    private float progress;
    private float progressO;

    public TileEntityMovingPistonBlock() {
    }

    public TileEntityMovingPistonBlock(int movedId, int movedData, @Nullable TileEntity movedEntity, Direction direction, boolean extending, boolean isSourcePiston) {
        this.movedId = movedId;
        this.movedData = movedData;
        this.movedEntity = movedEntity;
        this.direction = direction;
        this.extending = extending;
        this.isSourcePiston = isSourcePiston;
        this.progressO = 0.0f;
        this.progress = 0.0f;
    }

    public int getMovedId() {
        return this.movedId;
    }

    public int getMovedData() {
        return this.movedData;
    }

    @Nullable
    public TileEntity getMovedEntity() {
        return this.movedEntity;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isSourcePiston() {
        return this.isSourcePiston;
    }

    public float getProgress(float partialTick) {
        if (partialTick > 1.0f) {
            partialTick = 1.0f;
        }
        return this.progressO + (this.progress - this.progressO) * partialTick;
    }

    public float getXOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetX();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetX();
    }

    public float getYOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetY();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetY();
    }

    public float getZOff(float partialTick) {
        if (this.extending) {
            return (this.getProgress(partialTick) - 1.0f) * (float)this.direction.getOffsetZ();
        }
        return (1.0f - this.getProgress(partialTick)) * (float)this.direction.getOffsetZ();
    }

    private void moveCollidedEntities(float stretch, float force) {
        assert (this.worldObj != null);
        stretch = !this.extending ? (stretch -= 1.0f) : 1.0f - stretch;
        AABB aabb = Blocks.PISTON_MOVING.getLogic().getCollisionShapeFromTileEntity(this.worldObj, new TilePos(this.x, this.y, this.z), this.movedId, stretch, this.direction);
        if (aabb == null) {
            return;
        }
        List<Entity> list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, aabb);
        if (!list.isEmpty()) {
            entityBuffer.addAll(list);
            for (Entity entity : entityBuffer) {
                if (entity == null || entity.noPhysics) continue;
                entity.move(force * (float)this.direction.getOffsetX(), force * (float)this.direction.getOffsetY(), force * (float)this.direction.getOffsetZ());
            }
            entityBuffer.clear();
        }
    }

    public void finalTick() {
        TilePos selfPos = new TilePos(this.x, this.y, this.z);
        assert (this.worldObj != null);
        this.progress = 1.0f;
        this.progressO = 1.0f;
        this.worldObj.removeTileEntity(selfPos);
        this.invalidate();
        if (this.worldObj.getBlockId(selfPos) == Blocks.PISTON_MOVING.id()) {
            this.worldObj.setBlockIdDataRaw(selfPos, this.movedId, this.movedData);
            if (this.movedEntity != null) {
                TileEntity oldEnt = this.worldObj.getTileEntity(selfPos);
                if (oldEnt != null) {
                    oldEnt.invalidate();
                }
                this.movedEntity.validate();
                this.movedEntity.x = this.x;
                this.movedEntity.y = this.y;
                this.movedEntity.z = this.z;
                this.worldObj.replaceTileEntity(selfPos, this.movedEntity);
            }
            if (this.movedId != 0) {
                Block.disableNormalEntityLogic = true;
                Blocks.blocksList[this.movedId].onPlacedByWorld(this.worldObj, selfPos);
                Block.disableNormalEntityLogic = false;
            }
            assert (this.movedEntity == null || this.worldObj.getTileEntity(selfPos) == this.movedEntity) : "Piston failed to actually move entity!";
            this.worldObj.notifyBlockChange(selfPos, this.movedId);
        }
    }

    @Override
    public void tick() {
        this.progressO = this.progress;
        if (this.progressO >= 1.0f) {
            this.moveCollidedEntities(1.0f, 0.25f);
            this.finalTick();
            return;
        }
        this.progress += 0.5f;
        if (this.progress >= 0.999f) {
            this.progress = 1.0f;
        }
        if (this.extending) {
            this.moveCollidedEntities(this.progress, this.progress - this.progressO + 0.0625f);
        }
    }

    @Override
    public void readAdditionalData(@NotNull CompoundTag compoundTag) {
        this.movedId = compoundTag.getInteger("blockId");
        this.movedData = compoundTag.getInteger("blockData");
        if (compoundTag.containsKey("tileEntity")) {
            CompoundTag entityTag = compoundTag.getCompound("tileEntity");
            this.movedEntity = TileEntityDispatcher.createAndLoadEntity(entityTag);
        }
        this.direction = Direction.getDirectionById(compoundTag.getInteger("facing"));
        this.progressO = this.progress = compoundTag.getFloat("progress");
        this.extending = compoundTag.getBoolean("extending");
    }

    @Override
    public void writeAdditionalData(@NotNull CompoundTag compoundTag) {
        compoundTag.putInt("blockId", this.movedId);
        compoundTag.putInt("blockData", this.movedData);
        if (this.movedEntity != null) {
            CompoundTag entityTag = new CompoundTag();
            this.movedEntity.writeToNBT(entityTag);
            compoundTag.put("tileEntity", entityTag);
        }
        compoundTag.putInt("facing", this.direction.getId());
        compoundTag.putFloat("progress", this.progressO);
        compoundTag.putBoolean("extending", this.extending);
    }

    @Override
    public boolean canBeCarried(World world, Entity potentialHolder) {
        return false;
    }
}

