/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Item
implements ITaggable<Item>,
IItemConvertible {
    protected static final Random itemRand = new Random();
    public static final Object2IntMap<String> nameToIdMap = new Object2IntOpenHashMap<String>();
    public static final @Nullable Item @NotNull [] itemsList = new Item[32768];
    @NotNull
    public static final @NotNull Map<@NotNull NamespaceID, @NotNull Item> itemsMap = new LinkedHashMap<NamespaceID, Item>();
    public static int highestItemId = 0;
    public final int id;
    @NotNull
    public final NamespaceID namespaceID;
    protected int maxStackSize = 64;
    private int maxDamage = 0;
    protected boolean hasSubtypes = false;
    @Nullable
    private Item containerItem = null;
    private @Nullable Supplier<@NotNull IItemConvertible> statParent = null;
    @NotNull
    private final String key;
    protected static final Map<String, List<Stat>> statsInCategory = new HashMap<String, List<Stat>>();
    @NotNull
    protected final @NotNull Map<@NotNull String, @NotNull Stat> stats = new HashMap<String, Stat>();

    public Item(@NotNull NamespaceID namespaceId, @NotNull String translationKey, int id) {
        this.id = id;
        this.namespaceID = namespaceId.makePermanent();
        if (itemsList[id] != null) {
            throw new IllegalArgumentException("Item slot '" + id + "' is already occupied by '" + String.valueOf(itemsList[id]) + "' when adding " + String.valueOf(this));
        }
        if (itemsMap.containsKey(this.namespaceID)) {
            throw new IllegalArgumentException("Item id '" + String.valueOf(this.namespaceID) + "' is already used by '" + String.valueOf(itemsMap.get(this.namespaceID)) + "' when adding " + String.valueOf(this));
        }
        Item.itemsList[this.id] = this;
        itemsMap.put(this.namespaceID, this);
        if (this.id > highestItemId) {
            highestItemId = this.id;
        }
        this.key = "item." + translationKey;
        nameToIdMap.put(this.key, this.id);
    }

    public Item(@NotNull String translationKey, @NotNull String namespaceId, int id) {
        this(Item.makeNamespaceID(namespaceId), translationKey, id);
    }

    @NotNull
    public Item setStatParent(@NotNull @NotNull Supplier<@NotNull IItemConvertible> icon) {
        this.statParent = icon;
        return this;
    }

    @NotNull
    public Item setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        return this;
    }

    @NotNull
    protected Item setMaxDamage(int i) {
        this.maxDamage = i;
        return this;
    }

    @NotNull
    public Item withTags(Tag<Item> ... tags) {
        for (Tag<Item> tag : tags) {
            tag.tag(this);
        }
        return this;
    }

    @NotNull
    public Item setContainerItem(@Nullable Item item) {
        if (this.maxStackSize > 1) {
            throw new IllegalArgumentException("Max stack size must be 1 for items with crafting results");
        }
        this.containerItem = item;
        return this;
    }

    @NotNull
    protected Item setHasSubtypes(boolean hasSubtypes) {
        this.hasSubtypes = hasSubtypes;
        return this;
    }

    public boolean hasContainerItem() {
        return this.containerItem != null;
    }

    public boolean isSilkTouch() {
        return this.hasTag(ItemTags.IS_SILK_TOUCH);
    }

    public boolean hasInventoryInteraction() {
        return false;
    }

    public boolean showFullDurability() {
        return false;
    }

    public boolean getHasSubtypes() {
        return this.hasSubtypes;
    }

    public boolean isDamagable() {
        return this.maxDamage > 0 && !this.hasSubtypes;
    }

    public boolean hasTag(@NotNull Tag<Item> tag) {
        return tag.appliesTo(this);
    }

    @Override
    public boolean isIn(@NotNull Tag<Item> tag) {
        return tag.appliesTo(this);
    }

    @Nullable
    public Item getContainerItem() {
        return this.containerItem;
    }

    @NotNull
    public Stat createStat(@NotNull String statID, @NotNull String nameKey) {
        Stat stat;
        Stat cached = this.getStat(statID);
        if (cached != null) {
            return cached;
        }
        if (StatList.replacementMap.containsKey(this.id)) {
            Item replaceItem = Item.getItem(StatList.replacementMap.get(this.id));
            stat = replaceItem.getStat(statID);
            if (stat == null) {
                stat = replaceItem.createStat(statID, nameKey);
            }
        } else {
            stat = new StatItem(NamespaceID.fromPool(this.namespaceID.namespace(), this.namespaceID.value() + "_" + statID), nameKey, this.id).registerStat();
        }
        this.putStat(statID, stat);
        return stat;
    }

    public void putStat(@NotNull String statID, @NotNull Stat stat) {
        this.stats.put(statID, stat);
        statsInCategory.putIfAbsent(statID, new ArrayList());
        if (!statsInCategory.get(statID).contains(stat)) {
            statsInCategory.get(statID).add(stat);
        }
    }

    @Nullable
    public Stat getStat(@NotNull String statID) {
        return this.stats.get(statID);
    }

    @Nullable
    public Item getStatParent() {
        if (this.statParent != null) {
            return this.statParent.get().asItem();
        }
        return null;
    }

    @Nullable
    public static List<Stat> getStats(@NotNull String statID) {
        return statsInCategory.get(statID);
    }

    public int getItemStackLimit(@Nullable ItemStack selfStack) {
        return this.maxStackSize;
    }

    public int getMaxDamage() {
        return this.getMaxDamageForStack(null);
    }

    public int getMaxDamageForStack(@Nullable ItemStack selfStack) {
        return this.maxDamage;
    }

    @Deprecated
    public final boolean onUseItemOnBlock(@NotNull ItemStack selfStack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        return this.onUseOnBlock(selfStack, world, player, new TilePos(blockX, blockY, blockZ), side, xPlaced, yPlaced);
    }

    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePos blockPos, @NotNull Side side, double xHit, double yHit) {
        return false;
    }

    @Deprecated
    public final void onUseByActivator(@NotNull ItemStack selfStack, @NotNull TileEntityActivator activator, @NotNull World world, @NotNull Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, @NotNull Direction direction) {
        this.onUseByActivator(selfStack, world, activator, random, new TilePos(blockX, blockY, blockZ), direction, offX, offY, offZ);
    }

    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
    }

    public float getStrVsBlock(@NotNull ItemStack selfStack, @NotNull Block<?> block) {
        return 1.0f;
    }

    @Deprecated
    @Nullable
    public final ItemStack onUseItem(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        return this.onUse(selfStack, world, player);
    }

    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        return selfStack;
    }

    public boolean hitEntity(@NotNull ItemStack selfStack, @NotNull Mob target, @NotNull Mob attacker) {
        return false;
    }

    @Deprecated
    public final boolean beforeDestroyBlock(@NotNull World world, @NotNull ItemStack selfStack, int blockId, int x, int y, int z, @NotNull Side side, @NotNull Player player) {
        Block<?> b = Blocks.getBlock(blockId);
        assert (b != null);
        return this.beforeBlockDestroyed(selfStack, world, player, b, new TilePos(x, y, z), side);
    }

    public boolean beforeBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player, @NotNull Block<?> block, @NotNull TilePos blockPos, @NotNull Side side) {
        return true;
    }

    @Deprecated
    public final boolean onBlockDestroyed(@NotNull World world, @NotNull ItemStack selfStack, int removedBlockId, int x, int y, int z, @NotNull Side side, @NotNull Mob mob) {
        Block<?> b = Blocks.getBlock(removedBlockId);
        assert (b != null);
        return this.onBlockDestroyed(selfStack, world, mob, b, new TilePos(x, y, z), side);
    }

    public boolean onBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Mob mob, @NotNull Block<?> removedBlock, @NotNull TilePos blockPos, @NotNull Side side) {
        return false;
    }

    @Deprecated
    public final int getDamageVsEntity(@NotNull Entity entity, @NotNull ItemStack selfStack) {
        return this.getDamageVsEntity(selfStack, entity);
    }

    public int getDamageVsEntity(@NotNull ItemStack selfStack, @NotNull Entity entity) {
        return 1;
    }

    @Deprecated
    public final boolean canHarvestBlock(@NotNull Mob mob, @NotNull ItemStack selfStack, @NotNull Block<?> block) {
        return this.canHarvestBlock(selfStack, mob, block);
    }

    public boolean canHarvestBlock(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Block<?> block) {
        return false;
    }

    @Deprecated
    public final boolean useItemOnEntity(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Player player) {
        return this.useOnEntity(selfStack, player, mob);
    }

    public boolean useOnEntity(@NotNull ItemStack selfStack, @NotNull Player player, @NotNull Mob mob) {
        return false;
    }

    public void inventoryTick(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Entity entity, int slotId, boolean isHeld) {
    }

    public void onCraftedBy(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
    }

    @Nullable
    public ItemStack onInventoryInteract(@NotNull Player player, @NotNull Slot slot, @Nullable ItemStack stackInSlot, boolean isItemGrabbed) {
        return stackInSlot;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getLanguageKey(@NotNull ItemStack selfStack) {
        return this.key;
    }

    @NotNull
    public String getTranslatedName(@NotNull ItemStack selfStack) {
        return I18n.getInstance().translateKey(selfStack.getItemKey() + ".name");
    }

    @NotNull
    public String getTranslatedDescription(@NotNull ItemStack selfStack) {
        return I18n.getInstance().translateKey(selfStack.getItemKey() + ".desc");
    }

    @NotNull
    public String getStatName() {
        return I18n.getInstance().translateKey(this.getKey() + ".name");
    }

    @Override
    @NotNull
    public Item asItem() {
        return this;
    }

    @Override
    @NotNull
    public ItemStack getDefaultStack() {
        return new ItemStack(this);
    }

    @NotNull
    public CompoundTag getDefaultTag() {
        return new CompoundTag();
    }

    @Nullable
    public static Item getItem(int id) {
        return itemsList[Math.max(id, 0)];
    }

    @NotNull
    private static NamespaceID makeNamespaceID(@NotNull String string) {
        try {
            return (NamespaceID)NamespaceID.fromPool(string).copyUnpooled();
        }
        catch (HardIllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean hasTag(@Nullable ItemStack itemStack, @NotNull Tag<Item> tag) {
        if (itemStack == null) {
            return false;
        }
        return tag.appliesTo(itemsList[itemStack.itemID]);
    }
}

