/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.Pos3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TilePos
implements Pos3i<TilePos> {
    public int x;
    public int y;
    public int z;

    public TilePos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TilePos(@NotNull TilePos tilePos) {
        this(tilePos.x, tilePos.y, tilePos.z);
    }

    public TilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(@NotNull ChunkPos chunkPos, @NotNull ChunkTilePos chunkTilePos) {
        this(chunkPos.x * 16 + chunkTilePos.x, chunkTilePos.y, chunkPos.z * 16 + chunkTilePos.z);
    }

    public TilePos(@NotNull Vec3 vec) {
        this(vec.x, vec.y, vec.z);
    }

    public TilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    @NotNull
    public TilePos add(int x, int y, int z) {
        return new TilePos(this.x + x, this.y + y, this.z + z);
    }

    @NotNull
    public TilePos set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public ChunkPos toChunkPos() {
        return new ChunkPos(this);
    }

    @NotNull
    public ChunkTilePos toChunkTilePos() {
        return new ChunkTilePos(this);
    }

    public boolean inBounds(@NotNull WorldSource source) {
        return this.x >= -32000000 && this.y >= 0 && this.z >= -32000000 && this.x <= 32000000 && this.y < source.getHeightBlocks() && this.z <= 32000000;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TilePos)) {
            return false;
        }
        @NotNull TilePos other = (TilePos)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }

    public String toString() {
        return "TilePos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }
}

