/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotResult;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class TooltipElement
extends Gui {
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<String, Style> styleMap = new HashMap<String, Style>();
    public static final List<String> stylesIdList = new ArrayList<String>();
    protected static final Style defaultStyle = new Style("default", "default", 3, 3, 3, 3);
    Minecraft mc;
    FontRenderer fontRenderer;
    public static final int BASE_PADDING = 3;
    public static final int LINE_SPACING = 3;

    public TooltipElement(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.font;
    }

    public void render(CharSequence string, int x, int y, int offsetX, int offsetY) {
        this.render(string, x, y, offsetX, offsetY, -1, -1, true);
    }

    public void render(CharSequence chars, int x, int y, int offsetX, int offsetY, int maxWidth, int maxHeight, boolean canOffset) {
        maxWidth = maxWidth == -1 ? Integer.MAX_VALUE : maxWidth;
        maxHeight = maxHeight == -1 ? Integer.MAX_VALUE : maxHeight;
        ArrayList<String> lines = new ArrayList<String>();
        this.fontRenderer.splitCharsIntoLines(chars, maxWidth, lines);
        int width = 0;
        for (String line : lines) {
            width = Math.max(width, this.fontRenderer.stringWidth(line) - 1);
        }
        int height = MathHelper.ceil(this.fontRenderer.heightOfLines(lines, maxWidth) - 1.0);
        if (canOffset && x + offsetX + width > this.mc.resolution.getScaledWidthScreenCoords()) {
            offsetX = -offsetX - width;
        }
        if (canOffset) {
            offsetY -= Math.max(0, y + height + offsetY - this.mc.resolution.getScaledHeightScreenCoords());
        }
        int padding = this.getPadding();
        this.drawBackground(x += offsetX, y += offsetY, x + width, y + height);
        this.fontRenderer.renderWidthConstrained((Tessellator)Tessellator.instance, chars, x + padding, y + padding, maxWidth).call();
    }

    public int getPadding() {
        return 0;
    }

    public int[] drawBackground(int x, int y, int offsetX, int offsetY, int width, int height) {
        if (x + offsetX + width > this.mc.resolution.getScaledWidthScreenCoords()) {
            offsetX = -offsetX - width;
        }
        offsetY -= Math.max(0, y + height + offsetY - this.mc.resolution.getScaledHeightScreenCoords());
        return this.drawBackground(x += offsetX, y += offsetY, x + width, y + height);
    }

    private int[] drawBackground(int minX, int minY, int maxX, int maxY) {
        Style style = styleMap.getOrDefault(this.mc.gameSettings.tooltipStyle.value, defaultStyle);
        if (style != null) {
            GL11.glEnable(3042);
            GL11.glBlendFunc(770, 771);
            this.drawGuiIcon(minX - 2, minY - 2, maxX - minX + 4, maxY - minY + 4, style.getInnerIcon());
            this.drawGuiIcon(minX - 2 - style.paddingLeft, minY - 2 - style.paddingTop, maxX - minX + 4 + style.paddingLeft + style.paddingRight, maxY - minY + 4 + style.paddingTop + style.paddingBottom, style.getBorderIcon());
            GL11.glDisable(3042);
        }
        return new int[]{minX, minY};
    }

    public String getTooltipText(ItemStack itemStack, boolean showDescription, Slot slot) {
        I18n trans = I18n.getInstance();
        StringBuilder text = new StringBuilder();
        boolean discovered = true;
        boolean ctrlPressed = false;
        boolean shiftPressed = false;
        boolean debug = (Boolean)this.mc.gameSettings.showItemDebugInfo.value;
        if (slot != null) {
            discovered = slot.getIsDiscovered(this.mc.thePlayer);
            if (slot instanceof SlotResult) {
                ctrlPressed = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                shiftPressed = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
                showDescription = false;
                if (((Boolean)this.mc.gameSettings.swapCraftingButtons.value).booleanValue()) {
                    boolean temp = shiftPressed;
                    shiftPressed = ctrlPressed;
                    ctrlPressed = temp;
                }
            }
        }
        if (discovered) {
            RecipeSymbol input;
            text.append(TextFormatting.get(itemStack.getDisplayColor()));
            text.append(itemStack.getDisplayName());
            if (itemStack.getData().containsKey("tileEntityData")) {
                text.append(" ").append(TextFormatting.MAGENTA).append(TextFormatting.ITALIC).append("+NBT").append(TextFormatting.RESET).append(TextFormatting.get(itemStack.getDisplayColor()));
            }
            if (debug) {
                text.append(" #").append(itemStack.itemID).append(":").append(itemStack.getMetadata());
            }
            if (slot instanceof SlotGuidebook && ((SlotGuidebook)slot).recipe != null && ((SlotGuidebook)slot).recipe instanceof RecipeEntryTrommel && !(input = (RecipeSymbol)((SlotGuidebook)slot).recipe.getInput()).matches(slot.getItemStack())) {
                WeightedRandomBag bag = (WeightedRandomBag)((SlotGuidebook)slot).recipe.getOutput();
                double percent = bag.getAsPercentage(slot.getItemStack());
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(String.format("%.2f", percent)).append("%");
            }
            if (debug) {
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(itemStack.getItem().namespaceID);
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(itemStack.getItemKey());
                CompoundTag data = itemStack.getData();
                if (data != null) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("NBT: ").append(((Map)data.getValue()).size()).append(" Tags");
                }
                if (slot instanceof SlotGuidebook) {
                    if (((SlotGuidebook)slot).recipe != null) {
                        text.append('\n').append(TextFormatting.GRAY).append(((SlotGuidebook)slot).recipe.toString());
                    }
                    if (((SlotGuidebook)slot).symbol != null && ((SlotGuidebook)slot).symbol.getItemGroup() != null) {
                        text.append('\n').append(TextFormatting.GRAY).append("Accepts any: ").append(((SlotGuidebook)slot).symbol.getItemGroup());
                    }
                }
            }
            if (itemStack.isItemStackDamageable() && !showDescription && ((Boolean)this.mc.gameSettings.showItemDebugInfo.value).booleanValue()) {
                int durability = itemStack.getMaxDamage();
                int remainingUses = durability - itemStack.getMetadata();
                text.append('\n').append(TextFormatting.LIGHT_GRAY).append(remainingUses + 1).append(" / ").append(durability + 1);
            }
            if (showDescription) {
                text.append('\n').append(TooltipElement.formatDescription(itemStack.getItemDescription(), 16));
            } else if (!(slot instanceof SlotResult) && this.mc.gameSettings.itemDescriptions.value != DescriptionPromptEnum.NEVER_PROMPT) {
                text.append('\n').append(TooltipElement.formatDescription(trans.translateKeyAndFormat("gui.tooltip.prompt.description", this.mc.gameSettings.keyDescription.getKeyName()), 16));
            }
            if (slot instanceof SlotResult) {
                if (shiftPressed && !ctrlPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft Stack");
                }
                if (ctrlPressed && !shiftPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft Once");
                }
                if (ctrlPressed && shiftPressed) {
                    text.append('\n').append(TextFormatting.LIGHT_GRAY).append("Craft All");
                }
            }
        } else {
            String translatedName = itemStack.getDisplayName();
            for (char c : translatedName.toCharArray()) {
                if (Character.isLetterOrDigit(c)) {
                    text.append("?");
                    continue;
                }
                text.append(c);
            }
            if (showDescription) {
                text.append('\n').append(trans.translateKey("item.unknown.desc"));
            }
        }
        return text.toString();
    }

    public String getTooltipText(ItemStack itemStack, boolean showDescription) {
        return this.getTooltipText(itemStack, showDescription, null);
    }

    private static String formatDescription(String description, int preferredLineLength) {
        StringBuilder string = new StringBuilder();
        string.append(TextFormatting.LIGHT_GRAY);
        int lineLength = 0;
        for (int i = 0; i < description.length(); ++i) {
            char c = description.charAt(i);
            if (c == ' ') {
                if (lineLength > preferredLineLength) {
                    lineLength = 0;
                    string.append("\n").append(TextFormatting.LIGHT_GRAY);
                    continue;
                }
                string.append(c);
                continue;
            }
            ++lineLength;
            string.append(c);
        }
        return string.toString();
    }

    public static void reloadStyles(@NotNull TexturePackList packList) {
        styleMap.clear();
        stylesIdList.clear();
        ArrayList<TexturePack> packs = new ArrayList<TexturePack>();
        packs.add(packList.getDefaultTexturePack());
        packs.addAll(packList.selectedPacks);
        ArrayList<String> styleIds = new ArrayList<String>();
        styleIds.add("default");
        for (int i = packs.size() - 1; i >= 0; --i) {
            TexturePack pack = (TexturePack)packs.get(i);
            try (InputStream stylesStream = pack.getResourceAsStream("/assets/minecraft/textures/gui/sprites/tooltip/styles.json");){
                boolean replace;
                if (stylesStream == null) continue;
                JsonObject stylesListObject = JsonParser.parseReader(new InputStreamReader(stylesStream)).getAsJsonObject();
                boolean bl = replace = stylesListObject.has("replace") ? stylesListObject.get("replace").getAsBoolean() : false;
                if (replace) {
                    styleIds.clear();
                }
                JsonArray styles = stylesListObject.getAsJsonArray("styles");
                for (JsonElement element : styles) {
                    String styleId = element.getAsString();
                    if (styleIds.contains(styleId)) continue;
                    styleIds.add(styleId);
                }
                continue;
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to load styles data!", ioException);
                continue;
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error occurred while parsing 'styles.json'!", runtimeException);
            }
        }
        for (String styleId : styleIds) {
            Style style;
            JsonObject properties = null;
            try (InputStream propertiesStream = packList.getResourceAsStream("/assets/minecraft/textures/gui/sprites/tooltip/" + styleId + "/properties.json");){
                if (propertiesStream != null) {
                    properties = JsonParser.parseReader(new JsonReader(new InputStreamReader(propertiesStream))).getAsJsonObject();
                }
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to load style '{}' properties json!", (Object)styleId, (Object)ioException);
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error("Error occurred while parsing '{}/properties.json'!", (Object)styleId, (Object)runtimeException);
            }
            if (properties == null) {
                style = new Style(styleId, String.format("options.tooltipStyle.%s", styleId), 3, 3, 3, 3);
            } else {
                int top;
                int bottom;
                int left;
                int right;
                String key;
                String string = key = properties.has("key") ? properties.get("key").getAsString() : String.format("options.tooltipStyle.%s", styleId);
                if (properties.has("padding")) {
                    JsonElement padding = properties.get("padding");
                    if (padding.isJsonPrimitive()) {
                        left = right = padding.getAsInt();
                        bottom = right;
                        top = right;
                    } else {
                        JsonObject paddingObject = padding.getAsJsonObject();
                        top = paddingObject.has("top") ? paddingObject.get("top").getAsInt() : 3;
                        bottom = paddingObject.has("bottom") ? paddingObject.get("bottom").getAsInt() : 3;
                        left = paddingObject.has("left") ? paddingObject.get("left").getAsInt() : 3;
                        right = paddingObject.has("right") ? paddingObject.get("right").getAsInt() : 3;
                    }
                } else {
                    right = 3;
                    left = 3;
                    bottom = 3;
                    top = 3;
                }
                style = new Style(styleId, key, top, bottom, left, right);
            }
            styleMap.put(styleId, style);
            stylesIdList.add(styleId);
        }
        if (!styleMap.containsKey("default")) {
            styleMap.put("default", defaultStyle);
            stylesIdList.add("default");
        }
        if (Minecraft.getMinecraft().gameSettings.tooltipStyle.getValueIndex() == -1) {
            Minecraft.getMinecraft().gameSettings.tooltipStyle.set("default");
        }
    }

    public static class Style {
        public final String id;
        public final String translationKey;
        public final int paddingTop;
        public final int paddingBottom;
        public final int paddingLeft;
        public final int paddingRight;
        private final IconCoordinate innerIcon;
        private final IconCoordinate borderIcon;

        public Style(String id, String translationKey, int paddingTop, int paddingBottom, int paddingLeft, int paddingRight) {
            this.id = id;
            this.translationKey = translationKey;
            this.paddingTop = paddingTop;
            this.paddingBottom = paddingBottom;
            this.paddingLeft = paddingLeft;
            this.paddingRight = paddingRight;
            this.innerIcon = TextureRegistry.getTexture("minecraft:gui/tooltip/" + id + "/inner");
            this.borderIcon = TextureRegistry.getTexture("minecraft:gui/tooltip/" + id + "/border");
        }

        public IconCoordinate getInnerIcon() {
            return this.innerIcon;
        }

        public IconCoordinate getBorderIcon() {
            return this.borderIcon;
        }
    }
}

