/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.nbteditor.components;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.nbteditor.components.AbstractTagComponent;
import net.minecraft.client.gui.nbteditor.components.ArrayTagComponent;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;

public class CompoundTagComponent
extends AbstractTagComponent<Map<String, Tag<?>>> {
    @NotNull
    public static final IconCoordinate icon = TextureRegistry.getTexture("minecraft:gui/screen/nbt/compound_tag");
    public boolean expanded = false;
    public final List<AbstractTagComponent<?>> components = new ArrayList();

    public CompoundTagComponent(@NotNull Screen attachedScreen, @NotNull CompoundTag tag) {
        super(attachedScreen, tag);
        for (Tag t : ((Map)tag.getValue()).values()) {
            this.components.add(ArrayTagComponent.componentForTag(attachedScreen, t));
        }
    }

    @Override
    @NotNull
    public IconCoordinate getIcon(int mx, int my, float partialTick) {
        return icon;
    }

    @Override
    public void render(@NotNull Tessellator t, int offX, int offY, int mx, int my, float partialTick) {
        super.render(t, offX, offY, mx, my, partialTick);
        this.drawRect(offX + 12 + 1, offY, offX + super.width(mx, my, partialTick), offY + super.height(mx, my, partialTick), mx >= 0 && mx <= super.width(mx, my, partialTick) && my >= 0 && my <= super.height(mx, my, partialTick) ? -2006949728 : -2002739040);
        this.attachedScreen.fontRenderer.render(t, this.tag.getTagName(), offX + 12 + 1 + 2, offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(t, ": ", this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).setColor(DyeColor.YELLOW.color).call();
        this.attachedScreen.fontRenderer.render(t, ((Map)this.tag.getValue()).size(), this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).call();
        this.attachedScreen.fontRenderer.render(t, " entries", this.attachedScreen.fontRenderer.getLastEndingX(), offY + 2).call();
        if (this.expanded) {
            int y = offY + super.height(mx, my, partialTick) + 1;
            for (AbstractTagComponent<?> component : this.components) {
                this.drawLineHorizontal(offX + 6, offX + 13 - 2, y + 6, -1);
                component.render(t, offX + 13, y, mx - 13, my - y + offY, partialTick);
                y += component.height(mx - 13, my - y + offY, partialTick) + 1;
            }
            this.drawLineVertical(offX + 6, offY + super.height(mx, my, partialTick), y - 6, -1);
        }
    }

    @Override
    public int height(int mx, int my, float partialTick) {
        if (this.expanded) {
            int height = super.height(mx, my, partialTick);
            for (AbstractTagComponent<?> component : this.components) {
                my -= component.height(mx - 13, my, partialTick) + 1;
                height += component.height(mx - 13, my, partialTick) + 1;
            }
            return height;
        }
        return super.height(mx, my, partialTick);
    }

    @Override
    public int width(int mx, int my, float partialTick) {
        if (this.expanded) {
            int width = super.width(mx, my, partialTick);
            for (AbstractTagComponent<?> component : this.components) {
                my -= component.height(mx - 13, my, partialTick) + 1;
                width = Math.max(width, component.width(mx - 13, my, partialTick));
            }
            return width;
        }
        return super.width(mx, my, partialTick);
    }

    @Override
    public void onMouseClick(int mx, int my, int mouseButton, float partialTick) {
        if (mx >= 0 && mx <= super.width(mx, my, partialTick) && my >= 0 && my <= super.height(mx, my, partialTick)) {
            if (mouseButton == 0) {
                this.expanded = !this.expanded;
            }
        } else if (this.expanded) {
            int y = my - super.height(mx, my, partialTick);
            for (AbstractTagComponent<?> component : this.components) {
                component.onMouseClick(mx - 13, y, mouseButton, partialTick);
                y -= component.height(mx - 13, y, partialTick) + 1;
            }
        }
    }

    @Override
    public void onMouseRelease(int mx, int my, int mouseButton, float partialTick) {
        if (this.expanded) {
            int y = my - super.height(mx, my, partialTick);
            for (AbstractTagComponent<?> component : this.components) {
                component.onMouseRelease(mx - 13, y, mouseButton, partialTick);
                y -= component.height(mx - 13, y, partialTick) + 1;
            }
        }
    }
}

