/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseFilter;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.render.FogManager;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.ParticleEngine;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.EntityCameraIsometric;
import net.minecraft.client.render.camera.EntityCameraSleeping;
import net.minecraft.client.render.camera.EntityCameraThirdPersonFront;
import net.minecraft.client.render.camera.EntityCameraThirdPersonRear;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.culling.Frustum;
import net.minecraft.client.render.particle.ParticleSmoke;
import net.minecraft.client.render.particle.ParticleWaterDrop;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tessellator.TessellatorStandard;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.slf4j.Logger;

public class WorldRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final long nsPerSecond = 1000000000L;
    public final LightmapHelper lightmapHelper;
    public Minecraft mc;
    private float farPlaneDistance;
    public ItemRenderer itemRenderer;
    public FogManager fogManager;
    private int rendererUpdateCount;
    private Entity pointedEntity;
    private final MouseFilter mouseFilterXAxis;
    private final MouseFilter mouseFilterYAxis;
    private float fovModifier;
    private float fovModifierLast;
    private long systemTime;
    private final Random random;
    private int rainSoundCounter;
    public boolean zooming = false;
    private float zoomProgress;
    private float b = 1.0f;
    private float a = 1.0f;
    private float currentFovModifier = 1.0f;

    public WorldRenderer(Minecraft minecraft) {
        this.mc = minecraft;
        this.lightmapHelper = new LightmapHelper(minecraft, this);
        this.farPlaneDistance = 0.0f;
        this.pointedEntity = null;
        this.mouseFilterXAxis = new MouseFilter();
        this.mouseFilterYAxis = new MouseFilter();
        this.fovModifier = 0.0f;
        this.fovModifierLast = 0.0f;
        this.systemTime = 0L;
        this.random = new Random();
        this.rainSoundCounter = 0;
        this.itemRenderer = new ItemRenderer(minecraft);
        this.fogManager = new FogManager(this.mc);
    }

    public void updateRenderer() {
        this.updateSpeedFov();
        this.fovModifierLast = this.fovModifier;
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.mc.activeCamera.tick();
        this.fogManager.updateBrightness();
        ++this.rendererUpdateCount;
        this.itemRenderer.updateEquippedItem();
        this.addRainParticles();
        this.lightmapHelper.tick();
    }

    private void updateSpeedFov() {
        PlayerLocal player = this.mc.thePlayer;
        this.currentFovModifier = (Boolean)this.mc.gameSettings.fovModification.value != false ? player.getFovModifier() : 1.0f;
        this.a = this.b;
        this.b += (this.currentFovModifier - this.b) * 0.5f;
    }

    public void getMouseOver(float partialTicks) {
        if (this.mc.activeCamera == null) {
            return;
        }
        if (this.mc.currentWorld == null) {
            return;
        }
        double blockReach = this.mc.playerController.getBlockReachDistance();
        double entityReach = this.mc.playerController.getEntityReachDistance();
        Vec3 pos1 = this.mc.thePlayer.getPosition(partialTicks, true);
        Vec3 look = this.mc.thePlayer.getViewVector(partialTicks);
        Vec3 pos2 = pos1.add(look.x * blockReach, look.y * blockReach, look.z * blockReach);
        this.mc.objectMouseOver = this.mc.thePlayer.rayCast(blockReach, partialTicks, false, false, true);
        double hitBlockDistance = 1000.0;
        if (this.mc.objectMouseOver != null) {
            hitBlockDistance = pos1.distanceTo(this.mc.objectMouseOver.location);
        }
        this.pointedEntity = null;
        float expand = 1.0f;
        AABB entitySearchBox = this.mc.thePlayer.bb.expand(look.x * entityReach, look.y * entityReach, look.z * entityReach).grow(expand, expand, expand);
        List<Entity> entities = this.mc.currentWorld.getEntitiesWithinAABBExcludingEntity(this.mc.thePlayer, entitySearchBox);
        double pointedEntityDistance = 0.0;
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity = entities.get(i);
            if (!entity.isSelectable()) continue;
            float hitRadius = entity == this.mc.thePlayer.vehicle ? 0.0f : entity.getPickRadius();
            AABB hitBox = entity.bb.grow(hitRadius, hitRadius, hitRadius);
            if (hitBox.contains(pos1)) {
                this.pointedEntity = entity;
                pointedEntityDistance = 0.0;
                continue;
            }
            HitResult.Clip hitResult = hitBox.clip(pos1, pos2);
            if (hitResult == null) continue;
            double entityDistance = pos1.distanceTo(hitResult.location);
            if (this.pointedEntity != null && !(entityDistance < pointedEntityDistance)) continue;
            this.pointedEntity = entity;
            pointedEntityDistance = entityDistance;
        }
        if (pointedEntityDistance > hitBlockDistance || pointedEntityDistance > entityReach) {
            this.pointedEntity = null;
        }
        if (this.pointedEntity != null) {
            this.mc.objectMouseOver = new HitResult.Entity(this.pointedEntity);
        }
    }

    private float getFOVModifier(float partialTick, boolean isModifiedByFOV) {
        Mob entityliving = null;
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            entityliving = entityCamera.mob;
        }
        float fov = 70.0f;
        if (isModifiedByFOV) {
            fov = (int)(this.mc.activeCamera.getFov() * 100.0 + 30.0);
            fov *= this.a + (this.b - this.a) * partialTick;
        }
        if (((Boolean)this.mc.gameSettings.fovModification.value).booleanValue() && CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Material.water, partialTick)) {
            fov -= 10.0f;
        }
        if (entityliving != null && entityliving.getHealth() <= 0) {
            float f2 = (float)entityliving.deathTime + partialTick;
            fov /= (1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f;
        }
        return fov + this.fovModifierLast + (this.fovModifier - this.fovModifierLast) * partialTick;
    }

    @Deprecated
    private void hurtCameraEffect(float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (!(iCamera instanceof EntityCamera)) {
            return;
        }
        EntityCamera entityCamera = (EntityCamera)iCamera;
        Mob mob = entityCamera.mob;
        float f1 = (float)mob.hurtTime - partialTick;
        if (mob.getHealth() <= 0) {
            float f2 = (float)mob.deathTime + partialTick;
            GL11.glRotatef(40.0f - 8000.0f / (f2 + 200.0f), 0.0f, 0.0f, 1.0f);
        }
        if (f1 >= 0.0f) {
            f1 /= (float)mob.maxHurtTime;
            f1 = MathHelper.sin(f1 * f1 * f1 * f1 * (float)Math.PI);
            float f3 = mob.attackedAtYaw;
            GL11.glRotatef(-f3, 0.0f, 1.0f, 0.0f);
            GL11.glRotatef(-f1 * 14.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(f3, 0.0f, 1.0f, 0.0f);
        }
    }

    @NotNull
    private Matrix4f hurtCameraEffect(@NotNull Matrix4f matrix, float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (!(iCamera instanceof EntityCamera)) {
            return matrix;
        }
        EntityCamera entityCamera = (EntityCamera)iCamera;
        Mob mob = entityCamera.mob;
        float hurtInterp = (float)mob.hurtTime - partialTick;
        if (mob.getHealth() <= 0) {
            float f2 = (float)mob.deathTime + partialTick;
            matrix.rotate(org.joml.Math.toRadians(40.0f - 8000.0f / (f2 + 200.0f)), 0.0f, 0.0f, 1.0f);
        }
        if (hurtInterp >= 0.0f) {
            hurtInterp /= (float)mob.maxHurtTime;
            hurtInterp = MathHelper.sin(hurtInterp * hurtInterp * hurtInterp * hurtInterp * (float)Math.PI);
            float f3 = mob.attackedAtYaw;
            matrix.rotate(org.joml.Math.toRadians(-f3), 0.0f, 1.0f, 0.0f);
            matrix.rotate(org.joml.Math.toRadians(-hurtInterp * 14.0f), 0.0f, 0.0f, 1.0f);
            matrix.rotate(org.joml.Math.toRadians(f3), 0.0f, 1.0f, 0.0f);
        }
        return matrix;
    }

    @Deprecated
    private void setupViewBobbing(float partialTick, boolean isHand) {
        if (this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).mob instanceof Player) {
            Player player = (Player)((EntityCamera)this.mc.activeCamera).mob;
            float walkDist = -MathHelper.lerp(player.walkDistO, player.walkDist, partialTick);
            float cameraVel = MathHelper.lerp(player.cameraVelocityOld, player.cameraVelocity, partialTick);
            float cameraPitch = MathHelper.lerp(player.prevCameraPitch, player.cameraPitch, partialTick);
            if (isHand && player.vehicle instanceof MobPig) {
                cameraVel /= 4.0f;
                walkDist /= 2.0f;
            }
            if (player.isSkating) {
                walkDist *= 0.25f;
                cameraPitch *= 0.25f;
            }
            GL11.glTranslatef(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 0.5f, -Math.abs(MathHelper.cos(walkDist * (float)Math.PI) * cameraVel), 0.0f);
            GL11.glRotatef(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 3.0f, 0.0f, 0.0f, 1.0f);
            GL11.glRotatef(Math.abs(MathHelper.cos(walkDist * (float)Math.PI - 0.2f) * cameraVel) * 5.0f, 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(cameraPitch, 1.0f, 0.0f, 0.0f);
        }
    }

    @NotNull
    private Matrix4f setupViewBobbing(@NotNull Matrix4f matrix, float partialTick, boolean isHand) {
        Object object = this.mc.activeCamera;
        if (object instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)object;
            object = entityCamera.mob;
            if (object instanceof Player) {
                Player player = (Player)object;
                float walkDist = -MathHelper.lerp(player.walkDistO, player.walkDist, partialTick);
                float cameraVel = MathHelper.lerp(player.cameraVelocityOld, player.cameraVelocity, partialTick);
                float cameraPitch = MathHelper.lerp(player.prevCameraPitch, player.cameraPitch, partialTick);
                if (isHand && player.vehicle instanceof MobPig) {
                    cameraVel /= 4.0f;
                    walkDist /= 2.0f;
                }
                if (player.isSkating) {
                    walkDist *= 0.25f;
                    cameraPitch *= 0.25f;
                }
                matrix.translate(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 0.5f, -Math.abs(MathHelper.cos(walkDist * (float)Math.PI) * cameraVel), 0.0f);
                matrix.rotate(org.joml.Math.toRadians(MathHelper.sin(walkDist * (float)Math.PI) * cameraVel * 3.0f), 0.0f, 0.0f, 1.0f);
                matrix.rotate(org.joml.Math.toRadians(org.joml.Math.abs(MathHelper.cos(walkDist * (float)Math.PI - 0.2f) * cameraVel) * 5.0f), 1.0f, 0.0f, 0.0f);
                matrix.rotate(org.joml.Math.toRadians(cameraPitch), 1.0f, 0.0f, 0.0f);
            }
        }
        return matrix;
    }

    private void setupCamera(float partialTick) {
        ICamera iCamera = this.mc.activeCamera;
        if (iCamera instanceof EntityCamera) {
            EntityCamera entityCamera = (EntityCamera)iCamera;
            Mob mob = entityCamera.mob;
            if (this.mc.currentScreen instanceof ScreenPhotoMode) {
                this.mc.activeCamera = new EntityCameraIsometric(this.mc, mob);
            } else if (mob.isPlayerSleeping()) {
                if (!(this.mc.activeCamera instanceof EntityCameraSleeping)) {
                    this.mc.activeCamera = new EntityCameraSleeping(this.mc, mob, MathHelper.floor(mob.x), MathHelper.floor(mob.y), MathHelper.floor(mob.z), this.mc.activeCamera.getX(partialTick), this.mc.activeCamera.getY(partialTick), this.mc.activeCamera.getZ(partialTick), this.mc.activeCamera.getYRot(partialTick), this.mc.activeCamera.getXRot(partialTick));
                }
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !(this.mc.activeCamera instanceof EntityCameraFirstPerson)) {
                this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, mob);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 1 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonRear)) {
                this.mc.activeCamera = new EntityCameraThirdPersonRear(this.mc, mob);
            } else if ((Integer)this.mc.gameSettings.thirdPersonView.value == 2 && !(this.mc.activeCamera instanceof EntityCameraThirdPersonFront)) {
                this.mc.activeCamera = new EntityCameraThirdPersonFront(this.mc, mob);
            }
        }
    }

    @Deprecated
    private void orientCamera(float partialTick) {
        this.setupCamera(partialTick);
        this.mc.activeCamera.applyGlTransformations();
        if (!(this.mc.currentScreen instanceof ScreenPhotoMode) && !((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
            GL11.glRotatef((float)this.mc.activeCamera.getXRot(partialTick), 1.0f, 0.0f, 0.0f);
            GL11.glRotatef((float)(this.mc.activeCamera.getYRot(partialTick) + 180.0), 0.0f, 1.0f, 0.0f);
        }
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            GL11.glRotatef(((ScreenPhotoMode)this.mc.currentScreen).getTilt(partialTick), 1.0f, 0.0f, 0.0f);
            GL11.glRotatef(45.0f + 45.0f * ((ScreenPhotoMode)this.mc.currentScreen).getRotation(partialTick), 0.0f, 1.0f, 0.0f);
        }
    }

    @NotNull
    public Matrix4f orientCamera(@NotNull Matrix4f matrix, float partialTick) {
        Screen screen;
        this.setupCamera(partialTick);
        if (!(this.mc.currentScreen instanceof ScreenPhotoMode) && !((Boolean)this.mc.gameSettings.lockCamera.value).booleanValue()) {
            matrix.rotate(org.joml.Math.toRadians((float)this.mc.activeCamera.getXRot(partialTick)), 1.0f, 0.0f, 0.0f);
            matrix.rotate(org.joml.Math.toRadians((float)(this.mc.activeCamera.getYRot(partialTick) + 180.0)), 0.0f, 1.0f, 0.0f);
        }
        if ((screen = this.mc.currentScreen) instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            matrix.rotate(org.joml.Math.toRadians(screenPhotoMode.getTilt(partialTick)), 1.0f, 0.0f, 0.0f);
            matrix.rotate(org.joml.Math.toRadians(45.0f + 45.0f * screenPhotoMode.getRotation(partialTick)), 0.0f, 1.0f, 0.0f);
        }
        return matrix;
    }

    @Deprecated
    private void setupCameraTransform(float partialTicks) {
        float portalIntensity;
        this.farPlaneDistance = (Integer)this.mc.gameSettings.renderDistance.value * 16;
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(partialTicks, true);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTicks);
        } else {
            this.zoomProgress = 0.0f;
        }
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            double div = Math.pow(2.0, ((ScreenPhotoMode)this.mc.currentScreen).getZoom(partialTicks));
            GL11.glTranslatef(1.0f, 1.0f, 0.0f);
            GL11.glOrtho(0.0, (double)this.mc.gameWindow.getWidthPixels() / div, 0.0, (double)this.mc.gameWindow.getHeightPixels() / div, this.farPlaneDistance * -2.0f, this.farPlaneDistance * 2.0f);
            GL11.glTranslatef(((ScreenPhotoMode)this.mc.currentScreen).getPanX(partialTicks), -((ScreenPhotoMode)this.mc.currentScreen).getPanY(partialTicks), 0.0f);
        } else {
            GLU.gluPerspective(fov, (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        }
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        this.hurtCameraEffect(partialTicks);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue() && !(this.mc.currentScreen instanceof ScreenPhotoMode)) {
            this.setupViewBobbing(partialTicks, false);
        }
        float f = portalIntensity = (Boolean)this.mc.gameSettings.screenMotionEffects.value != false ? MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTicks) : 0.0f;
        if (portalIntensity > 0.0f) {
            float f3 = 5.0f / (portalIntensity * portalIntensity + 5.0f) - portalIntensity * 0.04f;
            f3 *= f3;
            GL11.glRotatef(((float)this.rendererUpdateCount + partialTicks) * 20.0f, 0.0f, 1.0f, 1.0f);
            GL11.glScalef(1.0f / f3, 1.0f, 1.0f);
            GL11.glRotatef(-((float)this.rendererUpdateCount + partialTicks) * 20.0f, 0.0f, 1.0f, 1.0f);
        }
        this.orientCamera(partialTicks);
    }

    @NotNull
    public Matrix4f getProjectionMatrix(@NotNull Matrix4f matrix, float partialTick) {
        this.farPlaneDistance = (Integer)this.mc.gameSettings.renderDistance.value * 16;
        float fov = this.getFOVModifier(partialTick, true);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        Screen screen = this.mc.currentScreen;
        if (screen instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            double div = Math.pow(2.0, screenPhotoMode.getZoom(partialTick));
            matrix.translate(1.0f, 1.0f, 0.0f);
            matrix.ortho(0.0f, (float)((double)this.mc.gameWindow.getWidthPixels() / div), 0.0f, (float)((double)this.mc.gameWindow.getHeightPixels() / div), this.farPlaneDistance * -2.0f, this.farPlaneDistance * 2.0f);
            matrix.translate(screenPhotoMode.getPanX(partialTick), -((ScreenPhotoMode)this.mc.currentScreen).getPanY(partialTick), 0.0f);
        } else {
            matrix.identity().perspective(org.joml.Math.toRadians(fov), (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        }
        return matrix;
    }

    @NotNull
    public Matrix4f getViewMatrix(@NotNull Matrix4f matrix, float partialTick) {
        float portalIntensity;
        matrix.identity();
        this.hurtCameraEffect(matrix, partialTick);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue() && !(this.mc.currentScreen instanceof ScreenPhotoMode)) {
            this.setupViewBobbing(matrix, partialTick, false);
        }
        float f = portalIntensity = (Boolean)this.mc.gameSettings.screenMotionEffects.value != false ? MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTick) : 0.0f;
        if (portalIntensity > 0.0f) {
            float f3 = 5.0f / (portalIntensity * portalIntensity + 5.0f) - portalIntensity * 0.04f;
            f3 *= f3;
            matrix.rotate(org.joml.Math.toRadians(((float)this.rendererUpdateCount + partialTick) * 20.0f), 0.0f, 1.0f, 1.0f);
            matrix.scale(1.0f / f3, 1.0f, 1.0f);
            matrix.rotate(org.joml.Math.toRadians(-((float)this.rendererUpdateCount + partialTick) * 20.0f), 0.0f, 1.0f, 1.0f);
        }
        this.orientCamera(matrix, partialTick);
        return matrix;
    }

    private void renderHand(float partialTick) {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        float fov = this.getFOVModifier(partialTick, false);
        if (this.zooming) {
            fov = this.getZoomedFOV(fov, partialTick);
        } else {
            this.zoomProgress = 0.0f;
        }
        GL11.glTranslatef(0.0f, 0.0f, -1.0f);
        GL11.glScalef(1.0f, 1.0f, 0.1f);
        GLU.gluPerspective(fov, (float)this.mc.gameWindow.getWidthPixels() / (float)this.mc.gameWindow.getHeightPixels(), 0.05f, this.farPlaneDistance * 2.0f);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glPushMatrix();
        this.hurtCameraEffect(partialTick);
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(partialTick, true);
        }
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && !(this.mc.currentScreen instanceof ScreenPhotoMode) && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping() && this.mc.gameSettings.immersiveMode.drawHand()) {
            this.lightmapHelper.enableLightmapRendering();
            if (!this.zooming) {
                this.itemRenderer.renderItemInFirstPerson(partialTick);
            }
            this.lightmapHelper.disableLightmapRendering();
        }
        GL11.glPopMatrix();
        Debug.change("post");
        this.mc.renderer.endRenderWorld(partialTick);
        if ((Integer)this.mc.gameSettings.thirdPersonView.value == 0 && this.mc.activeCamera instanceof EntityCamera && !((EntityCamera)this.mc.activeCamera).mob.isPlayerSleeping()) {
            this.itemRenderer.renderOverlays(partialTick);
            this.hurtCameraEffect(partialTick);
        }
        if (((Boolean)this.mc.gameSettings.viewBobbing.value).booleanValue()) {
            this.setupViewBobbing(partialTick, false);
        }
    }

    private float getZoomedFOV(float currentFov, float partialTick) {
        currentFov *= 0.45f;
        float prevZoomProgress = this.zoomProgress;
        this.zoomProgress -= (float)Mouse.getDWheel() / 4.0f;
        this.zoomProgress = MathHelper.clamp(this.zoomProgress, -7.5f, 7.5f);
        float maxFOV = 160.0f;
        float minFOV = 5.0f;
        float _zoom = prevZoomProgress + (this.zoomProgress - prevZoomProgress) * partialTick;
        if (this.zoomProgress > 0.0f) {
            return currentFov + 2.0f * (160.0f - currentFov) * (this.logisticFunc(_zoom) - 0.5f);
        }
        return 5.0f + 2.0f * (currentFov - 5.0f) * this.logisticFunc(_zoom);
    }

    private float logisticFunc(float val) {
        float L = 1.0f;
        float k = 1.1f;
        float xo = 0.0f;
        return (float)(1.0 / (1.0 + Math.pow(Math.E, -1.1f * (val - 0.0f))));
    }

    public void updateCameraAndRender(float partialTick) {
        this.lightmapHelper.update(partialTick);
        if (this.mc.inGameHasFocus) {
            if (Mouse.isGrabbed()) {
                float sensitivity = ((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() * 0.6f + 0.2f;
                sensitivity = sensitivity * sensitivity * sensitivity * 8.0f;
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                float deltaX = (float)this.mc.mouseInput.deltaX * sensitivity;
                float deltaY = (float)this.mc.mouseInput.deltaY * sensitivity;
                int l = 1;
                if (((Boolean)this.mc.gameSettings.invertMouse.value).booleanValue()) {
                    l = -1;
                }
                if (((Boolean)this.mc.gameSettings.smoothCamera.value).booleanValue()) {
                    deltaX = this.mouseFilterXAxis.getSmoothedDelta(deltaX, 0.05f * sensitivity);
                    deltaY = this.mouseFilterYAxis.getSmoothedDelta(deltaY, 0.05f * sensitivity);
                } else {
                    this.mouseFilterXAxis.reset();
                    this.mouseFilterYAxis.reset();
                }
                this.mc.thePlayer.interpolateTurn(deltaX, deltaY * (float)l);
            }
            if (this.mc.controllerInput != null) {
                double speed = Time.delta * 2000.0 * (double)(((Float)this.mc.gameSettings.controllerSensitivity.value).floatValue() + 0.5f);
                if (this.zooming) {
                    speed *= 0.25;
                }
                double x = (double)this.mc.controllerInput.joyRight.getX() * speed;
                double y = (double)(-this.mc.controllerInput.joyRight.getY()) * speed;
                this.mc.thePlayer.interpolateTurn((float)x, (float)y);
            }
            if (!((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue()) {
                PlayerInput playerInput = this.mc.thePlayer.input;
                float x = 0.0f;
                float y = 0.0f;
                playerInput.pressedLookUp = this.mc.gameSettings.keyLookUp.isPressed();
                playerInput.pressedLookDown = this.mc.gameSettings.keyLookDown.isPressed();
                playerInput.pressedLookLeft = this.mc.gameSettings.keyLookLeft.isPressed();
                playerInput.pressedLookRight = this.mc.gameSettings.keyLookRight.isPressed();
                if (playerInput.pressedLookUp) {
                    y += 1.0f;
                }
                if (playerInput.pressedLookDown) {
                    y -= 1.0f;
                }
                if (playerInput.pressedLookLeft) {
                    x -= 1.0f;
                }
                if (playerInput.pressedLookRight) {
                    x += 1.0f;
                }
                float sensitivity = (float)(Time.delta * 1000.0 * (double)(((Float)this.mc.gameSettings.mouseSensitivity.value).floatValue() + 0.5f));
                if (this.mc.thePlayer.isSneaking()) {
                    sensitivity *= 0.5f;
                }
                if (this.zooming) {
                    sensitivity *= 0.25f;
                }
                this.mc.thePlayer.interpolateTurn(x *= sensitivity, y *= sensitivity);
            }
        }
        if (this.mc.skipRenderWorld) {
            return;
        }
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int mouseX = Mouse.getX() * width / this.mc.resolution.getWidthScreenCoords();
        int mouseY = height - Mouse.getY() * height / this.mc.resolution.getHeightScreenCoords() - 1;
        int c = 200;
        c = (Boolean)this.mc.gameSettings.enableVsync.value != false ? 999 : (Integer)this.mc.gameSettings.customFpsLimit.value;
        if (c <= 0) {
            c = 1;
        }
        GL11.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
        if (this.mc.currentWorld != null) {
            Debug.change("world");
            if (!((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() && (Integer)this.mc.gameSettings.customFpsLimit.value == 0) {
                this.renderWorld(partialTick, 0L);
            } else {
                this.renderWorld(partialTick, this.systemTime + 1000000000L / (long)c);
            }
            Debug.change("misc");
            if (((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() || (Integer)this.mc.gameSettings.customFpsLimit.value > 0) {
                Debug.change("sleep");
                long timeToSleep = this.systemTime + 1000000000L / (long)c - System.nanoTime();
                long millis = timeToSleep / 1000000L;
                int nanos = (int)(timeToSleep - millis * 1000000L);
                if (millis > 0L && millis < 500L) {
                    try {
                        Thread.sleep(millis, nanos);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
            Debug.change("hud");
            this.mc.hudIngame.renderGameOverlay(partialTick, this.mc.currentScreen != null, mouseX, mouseY);
            Debug.change("misc");
        } else {
            GL11.glMatrixMode(5889);
            GL11.glLoadIdentity();
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            this.setupScaledResolution();
            if (((Boolean)this.mc.gameSettings.enableVsync.value).booleanValue() || (Integer)this.mc.gameSettings.customFpsLimit.value > 0) {
                Debug.change("sleep");
                long l2 = (this.systemTime + 1000000000L / (long)c - System.nanoTime()) / 1000000L;
                if (l2 < 0L) {
                    l2 += 10L;
                }
                if (l2 > 0L && l2 < 500L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
                Debug.change("misc");
            }
            this.systemTime = System.nanoTime();
        }
        this.mc.guiToasts.render(partialTick);
        if (this.mc.currentScreen != null) {
            Debug.change("gui");
            GL11.glClear(256);
            if (this.mc.inputType == InputType.CONTROLLER) {
                mouseX = (int)this.mc.controllerInput.cursorX;
                mouseY = (int)this.mc.controllerInput.cursorY;
            }
            this.mc.currentScreen.setDesiredCursor(CursorShape.ARROW);
            this.mc.currentScreen.render(mouseX, mouseY, partialTick);
            if (this.mc.currentScreen != null) {
                CursorShape newCursor = this.mc.currentScreen.getDesiredCursor();
                if (!((Boolean)this.mc.gameSettings.dynamicCursor.value).booleanValue()) {
                    newCursor = CursorShape.ARROW;
                }
                if (this.mc.gameWindow.getCursorShape() != newCursor) {
                    this.mc.gameWindow.setCursorShape(newCursor);
                }
            }
            if (this.mc.inputType == InputType.CONTROLLER && this.mc.currentScreen != null) {
                this.mc.currentScreen.drawControllerCursor();
            }
            Debug.change("misc");
        }
    }

    public void renderWorld(float partialTicks, long updateRenderersUntil) {
        Debug.push("misc");
        Colorizers.update(false);
        RenderGlobal renderGlobal = this.mc.renderGlobal;
        ParticleEngine particleEngine = this.mc.particleEngine;
        GL11.glEnable(2884);
        GL11.glEnable(2929);
        if (this.mc.activeCamera == null) {
            this.mc.activeCamera = new EntityCameraFirstPerson(this.mc, this.mc.thePlayer);
        }
        this.getMouseOver(partialTicks);
        Mob activeEntity = null;
        if (this.mc.activeCamera instanceof EntityCamera) {
            activeEntity = ((EntityCamera)this.mc.activeCamera).mob;
        }
        if (activeEntity != null) {
            double viewEntityX = activeEntity.xo + (activeEntity.x - activeEntity.xo) * (double)partialTicks;
            double viewEntityZ = activeEntity.zo + (activeEntity.z - activeEntity.zo) * (double)partialTicks;
            IChunkProvider iChunkProvider = this.mc.currentWorld.getChunkProvider();
            int chunkX = MathHelper.floor_float((int)viewEntityX) >> 4;
            int chunkZ = MathHelper.floor_float((int)viewEntityZ) >> 4;
            iChunkProvider.setCurrentChunkOver(chunkX, chunkZ);
        }
        this.fogManager.updateFogColor(partialTicks);
        Debug.change("post");
        this.mc.renderer.beginRenderWorld(partialTicks);
        GL11.glClear(16640);
        GL11.glEnable(2884);
        this.setupCameraTransform(this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).mob.isRemoved() ? 1.0f : partialTicks);
        Frustum.getFrustum();
        Debug.change("sky");
        if ((Integer)this.mc.gameSettings.renderDistance.value > 4 && !(this.mc.currentScreen instanceof ScreenModelViewer)) {
            this.fogManager.setupFog(-1, this.farPlaneDistance, partialTicks);
            GL11.glDisable(2912);
            renderGlobal.renderSky(partialTicks);
        }
        Debug.change("misc");
        GL11.glEnable(2912);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks);
        if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
            GL11.glShadeModel(7425);
        }
        this.mc.renderGlobal.cull(this.mc.activeCamera.getFrustum(), partialTicks);
        Debug.change("aurora");
        if (((Boolean)this.mc.gameSettings.aurora.value).booleanValue() && ((WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.mc.currentWorld.getWorldType())).hasAurora()) {
            renderGlobal.renderAurora(this.mc.activeCamera, partialTicks);
        }
        Debug.change("update");
        int loops = 1;
        if (this.mc.gameSettings.keyLoadChunksQuickly.isPressed()) {
            loops = 40;
        }
        for (int i = 0; i < loops; ++i) {
            long timeRemaining;
            while (!this.mc.renderGlobal.updateDirtyChunks(this.mc.activeCamera) && updateRenderersUntil != 0L && (timeRemaining = updateRenderersUntil - System.nanoTime()) >= 0L && timeRemaining <= 1000000000L) {
            }
        }
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks);
        GL11.glEnable(2912);
        TextureRegistry.blockAtlas.bind();
        Lighting.disable();
        Debug.change("terrain");
        this.lightmapHelper.enableLightmapRendering();
        this.mc.terrainRenderer.renderSolidTerrain(partialTicks);
        Debug.change("entities");
        GL11.glShadeModel(7424);
        GL11.glBlendFunc(770, 771);
        Lighting.enableLight();
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable(2912);
        }
        renderGlobal.renderEntities(this.mc.activeCamera, partialTicks);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable(2912);
        }
        Debug.change("particles");
        GL11.glDisable(3042);
        particleEngine.renderLitParticles(this.mc.activeCamera, partialTicks);
        Lighting.disable();
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks);
        this.mc.renderer.beginRenderParticles(partialTicks);
        particleEngine.renderParticles(this.mc.renderer.getParticleTessellator(), this.mc.activeCamera, partialTicks);
        this.mc.renderer.endRenderParticles(partialTicks);
        this.lightmapHelper.disableLightmapRendering();
        Debug.change("outline");
        if (this.mc.objectMouseOver != null) {
            GL11.glDisable(3008);
            HitResult hitResult = this.mc.objectMouseOver;
            if (hitResult instanceof HitResult.Tile) {
                HitResult.Tile hitTile = (HitResult.Tile)hitResult;
                renderGlobal.drawBlockBreaking(this.mc.activeCamera, hitTile, partialTicks);
            }
            renderGlobal.drawSelectionBox(this.mc.activeCamera, this.mc.objectMouseOver, partialTicks);
            GL11.glEnable(3008);
        }
        Debug.change("debugoverlays");
        if (((Boolean)this.mc.gameSettings.showCollisionBoxes.value).booleanValue()) {
            renderGlobal.drawDebugEntityOutlines(this.mc.activeCamera, partialTicks);
        }
        if (((Boolean)this.mc.gameSettings.showChunkBorders.value).booleanValue()) {
            renderGlobal.drawDebugChunkBorders(this.mc.activeCamera, partialTicks);
        }
        GL11.glBlendFunc(770, 771);
        this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks);
        GL11.glEnable(3042);
        GL11.glDisable(2884);
        TextureRegistry.blockAtlas.bind();
        Debug.change("water");
        this.lightmapHelper.enableLightmapRendering();
        if (((Boolean)this.mc.gameSettings.ambientOcclusion.value).booleanValue()) {
            GL11.glShadeModel(7425);
        }
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glDisable(2912);
        }
        this.mc.terrainRenderer.renderTranslucentTerrain(partialTicks);
        if (!((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
            GL11.glEnable(2912);
        }
        GL11.glShadeModel(7424);
        this.lightmapHelper.disableLightmapRendering();
        Debug.change("weather");
        GL11.glDepthMask(true);
        GL11.glEnable(2884);
        GL11.glDisable(3042);
        this.renderRainSnow(partialTicks);
        GL11.glDisable(2912);
        if (((Boolean)this.mc.gameSettings.clouds.value).booleanValue()) {
            Debug.change("clouds");
            this.fogManager.setupFog(0, this.farPlaneDistance, partialTicks);
            GL11.glEnable(2912);
            renderGlobal.renderClouds(partialTicks);
            GL11.glDisable(2912);
        }
        Debug.change("misc");
        this.fogManager.setupFog(1, this.farPlaneDistance, partialTicks);
        this.renderHand(this.mc.activeCamera instanceof EntityCamera && ((EntityCamera)this.mc.activeCamera).mob.isRemoved() ? 1.0f : partialTicks);
        GL11.glColorMask(true, true, true, true);
        Debug.pop();
    }

    private void addRainParticles() {
        Weather weather = this.mc.currentWorld.getCurrentWeather();
        if (!(weather instanceof IPrecipitation) || !((IPrecipitation)((Object)weather)).spawnRainParticles()) {
            return;
        }
        float f = this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower();
        if ((Integer)this.mc.gameSettings.fancyGraphics.value != 1) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.random.setSeed((long)this.rendererUpdateCount * 312987231L);
        WorldClient world = this.mc.currentWorld;
        int cameraX = MathHelper.floor(this.mc.activeCamera.getX());
        int cameraY = MathHelper.floor(this.mc.activeCamera.getY());
        int cameraZ = MathHelper.floor(this.mc.activeCamera.getZ());
        int byte0 = 10;
        double d = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        int l = 0;
        block0: for (int i1 = 0; i1 < (int)(100.0f * f * f); ++i1) {
            int randX = cameraX + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int randZ = cameraZ + this.random.nextInt(byte0) - this.random.nextInt(byte0);
            int y = world.findTopSolidBlock(randX, randZ);
            int i2 = world.getBlockId(randX, y - 1, randZ);
            Biome biome = world.getBlockBiome(randX, y, randZ);
            for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                if (biome.blockedWeathers[q] == weather) continue block0;
            }
            if (y > cameraY + byte0 || y < cameraY - byte0) continue;
            float f1 = this.random.nextFloat();
            float f2 = this.random.nextFloat();
            if (i2 <= 0) continue;
            if (Blocks.blocksList[i2].getMaterial() == Material.lava) {
                this.mc.particleEngine.add(new ParticleSmoke(world, (float)randX + f1, (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY, (float)randZ + f2, 0.0, 0.0, 0.0, 1.0f, 0));
                continue;
            }
            if (this.random.nextInt(++l) == 0) {
                d = (float)randX + f1;
                d1 = (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY;
                d2 = (float)randZ + f2;
            }
            this.mc.particleEngine.add(new ParticleWaterDrop(world, (float)randX + f1, (double)((float)y + 0.1f) - Blocks.blocksList[i2].getBounds().minY, (float)randZ + f2));
        }
        if (l > 0 && this.random.nextInt(3) < this.rainSoundCounter++) {
            this.rainSoundCounter = 0;
            if (d1 > this.mc.activeCamera.getY() + 1.0 && world.getHeightValue(MathHelper.floor(this.mc.activeCamera.getX()), MathHelper.floor(this.mc.activeCamera.getZ())) > MathHelper.floor(this.mc.activeCamera.getY())) {
                this.mc.currentWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.1f * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower() * 0.5f, 0.5f);
            } else {
                this.mc.currentWorld.playSoundEffect(null, SoundCategory.WEATHER_SOUNDS, d, d1, d2, "ambient.weather.rain", 0.2f * this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherPower() * 0.5f, 1.0f);
            }
        }
    }

    protected void renderRainSnow(float partialTick) {
        Weather weather = this.mc.currentWorld.getCurrentWeather();
        if (!(weather instanceof IPrecipitation)) {
            return;
        }
        @NotNull IPrecipitation precipitation = (IPrecipitation)((Object)weather);
        WorldClient world = this.mc.currentWorld;
        int posX = MathHelper.floor(this.mc.activeCamera.getX());
        int posY = MathHelper.floor(this.mc.activeCamera.getY());
        int posZ = MathHelper.floor(this.mc.activeCamera.getZ());
        TessellatorStandard tessellator = Tessellator.instance;
        GL11.glDisable(2884);
        GL11.glNormal3f(0.0f, 1.0f, 0.0f);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glAlphaFunc(516, 0.01f);
        this.mc.textureManager.loadTexture(precipitation.getPrecipitationTexturePath(world.weatherManager.getWeatherPower(), world.weatherManager.getWeatherIntensity())).bind();
        double nextPosX = this.mc.activeCamera.getX(partialTick);
        double nextPosY = this.mc.activeCamera.getY(partialTick);
        double nextPosZ = this.mc.activeCamera.getZ(partialTick);
        int floorPosY = MathHelper.floor(nextPosY);
        int radiusEffect = 10;
        if (precipitation.getPrecipitationType() == IPrecipitation.Type.SNOW_LIKE) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block1: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int i3;
                    int y = world.findTopSolidBlock(x, z);
                    Biome biomegenbase = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biomegenbase.blockedWeathers.length; ++q) {
                        if (biomegenbase.blockedWeathers[q] == weather) continue block1;
                    }
                    if (y < 0) {
                        y = 0;
                    }
                    if ((i3 = y) < floorPosY) {
                        i3 = floorPosY;
                    }
                    int k3 = posY - radiusEffect;
                    int i4 = posY + radiusEffect;
                    if (k3 < y) {
                        k3 = y;
                    }
                    if (i4 < y) {
                        i4 = y;
                    }
                    float f3 = 1.0f;
                    if (k3 == i4) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f5 = (float)this.rendererUpdateCount + partialTick;
                    float f6 = ((float)(this.rendererUpdateCount & 0x1FF) + partialTick) / 512.0f;
                    float f7 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f8 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d5 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d6 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f11 = MathHelper.sqrt(d5 * d5 + d6 * d6) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f12 = world.getLightBrightness(x, i3, z);
                    if (this.mc.fullbright) {
                        f12 = 1.0f;
                    }
                    GL11.glColor4f(f12, f12, f12, ((1.0f - f11 * f11) * 0.3f + 0.5f) * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower());
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, k3, (double)z + 0.5, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, k3, (double)z + 0.5, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 1, i4, (double)z + 0.5, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV(x + 0, i4, (double)z + 0.5, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 0, 0.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, k3, z + 1, 1.0f * f3 + f7, (float)k3 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 1, 1.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.addVertexWithUV((double)x + 0.5, i4, z + 0, 0.0f * f3 + f7, (float)i4 * f3 / 4.0f + f6 * f3 + f8);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (precipitation.getPrecipitationType() == IPrecipitation.Type.RAIN_LIKE) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block4: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int y = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, y, z);
                    for (int q = 0; q < biome.blockedWeathers.length; ++q) {
                        if (biome.blockedWeathers[q] == weather) continue block4;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < y) {
                        j3 = y;
                    }
                    if (l3 < y) {
                        l3 = y;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float f4 = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f(f10, f10, f10, ((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower());
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f + f4 * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        } else if (precipitation.getPrecipitationType() == IPrecipitation.Type.INVERTED_RAIN_LIKE) {
            for (int x = posX - radiusEffect; x <= posX + radiusEffect; ++x) {
                block7: for (int z = posZ - radiusEffect; z <= posZ + radiusEffect; ++z) {
                    int topSolidY = world.findTopSolidBlock(x, z);
                    Biome biome = world.getBlockBiome(x, topSolidY, z);
                    for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] == weather) continue block7;
                    }
                    int j3 = posY - radiusEffect;
                    int l3 = posY + radiusEffect;
                    if (j3 < topSolidY) {
                        j3 = topSolidY;
                    }
                    if (l3 < topSolidY) {
                        l3 = topSolidY;
                    }
                    float f2 = 1.0f;
                    if (j3 == l3) continue;
                    this.random.setSeed(x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761);
                    float vOffset = ((float)(this.rendererUpdateCount + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F) + partialTick) / 32.0f * (3.0f + this.random.nextFloat());
                    double d3 = (double)((float)x + 0.5f) - this.mc.activeCamera.getX();
                    double d4 = (double)((float)z + 0.5f) - this.mc.activeCamera.getZ();
                    float f9 = MathHelper.sqrt(d3 * d3 + d4 * d4) / (float)radiusEffect;
                    tessellator.startDrawingQuads();
                    float f10 = world.getLightBrightness(x, world.getHeightBlocks(), z) * 0.85f + 0.15f;
                    if (this.mc.fullbright) {
                        f10 = 1.0f;
                    }
                    GL11.glColor4f(f10, f10, f10, ((1.0f - f9 * f9) * 0.5f + 0.5f) * (world.weatherManager.getWeatherIntensity() - 0.1f) * world.weatherManager.getWeatherPower());
                    tessellator.setTranslation(-nextPosX * 1.0, -nextPosY * 1.0, -nextPosZ * 1.0);
                    tessellator.addVertexWithUV(x + 0, j3, (double)z + 0.5, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, j3, (double)z + 0.5, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 1, l3, (double)z + 0.5, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV(x + 0, l3, (double)z + 0.5, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 0, 0.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, j3, z + 1, 1.0f * f2, (float)j3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 1, 1.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.addVertexWithUV((double)x + 0.5, l3, z + 0, 0.0f * f2, (float)l3 * f2 / 4.0f - vOffset * f2);
                    tessellator.setTranslation(0.0, 0.0, 0.0);
                    tessellator.draw();
                }
            }
        }
        GL11.glEnable(2884);
        GL11.glDisable(3042);
        GL11.glAlphaFunc(516, 0.1f);
    }

    public void setupScaledResolution() {
        GL11.glClear(256);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.mc.resolution.getExactScaledWidthScreenCoords(), this.mc.resolution.getExactScaledHeightScreenCoords(), 0.0, 1000.0, 3000.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef(0.0f, 0.0f, -2000.0f);
    }
}

