/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFence;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.useless.dragonfly.DisplayPos;

public class BlockModelFence<T extends BlockLogicFence>
extends BlockModelStandard<T> {
    protected static final DisplayPos FENCE_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos FENCE_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, 90.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public BlockModelFence(Block<T> block) {
        super(block);
        this.setDisplayPos("gui", FENCE_GUI);
        this.setDisplayPos("head", FENCE_HEAD);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        float f7;
        float f = 0.375f;
        float f1 = 0.625f;
        AABB bounds = AABB.fromPool(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        boolean connectedWestEast = false;
        boolean connectedNorthSouth = false;
        BlockLogicFence fence = (BlockLogicFence)this.block.getLogic();
        if (fence.canConnectTo(worldSource, x, y, z, Side.WEST) || fence.canConnectTo(worldSource, x, y, z, Side.EAST)) {
            connectedWestEast = true;
        }
        if (fence.canConnectTo(worldSource, x, y, z, Side.NORTH) || fence.canConnectTo(worldSource, x, y, z, Side.SOUTH)) {
            connectedNorthSouth = true;
        }
        boolean flag3 = fence.canConnectTo(worldSource, x, y, z, Side.WEST);
        boolean flag4 = fence.canConnectTo(worldSource, x, y, z, Side.EAST);
        boolean flag5 = fence.canConnectTo(worldSource, x, y, z, Side.NORTH);
        boolean flag6 = fence.canConnectTo(worldSource, x, y, z, Side.SOUTH);
        if (!connectedWestEast && !connectedNorthSouth) {
            connectedWestEast = true;
        }
        float f8 = 0.4375f;
        float f9 = 0.5625f;
        float f2 = 0.75f;
        float f3 = 0.9375f;
        float f4 = flag3 ? 0.0f : 0.4375f;
        float f5 = flag4 ? 1.0f : 0.5625f;
        float f6 = flag5 ? 0.0f : 0.4375f;
        float f10 = f7 = flag6 ? 1.0f : 0.5625f;
        if (connectedWestEast) {
            bounds.set(f4, 0.75, 0.4375, f5, 0.9375, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (connectedNorthSouth) {
            bounds.set(0.4375, 0.75, f6, 0.5625, 0.9375, f7);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        float f102 = 0.375f;
        float f11 = 0.5625f;
        if (connectedWestEast) {
            bounds.set(f4, 0.375, 0.4375, f5, 0.5625, 0.5625);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        if (connectedNorthSouth) {
            bounds.set(0.4375, 0.375, f6, 0.5625, 0.5625, f7);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, x, y, z);
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelFence.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f(r * brightness, g * brightness, b * brightness, alpha);
        }
        GL11.glTranslatef(-0.5f, -0.5f, -0.5f);
        for (int cube = 0; cube < 4; ++cube) {
            float radius = 0.125f;
            float f5 = 0.0625f;
            AABB bounds = switch (cube) {
                case 0 -> AABB.fromPool(0.375, 0.0, 0.0, 0.625, 1.0, 0.25);
                case 1 -> AABB.fromPool(0.375, 0.0, 0.75, 0.625, 1.0, 1.0);
                case 2 -> AABB.fromPool(0.4375, 0.8125, -0.125, 0.5625, 0.9375, 1.125);
                default -> AABB.fromPool(0.4375, 0.3125, -0.125, 0.5625, 0.4375, 1.125);
            };
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
        }
        GL11.glTranslatef(0.5f, 0.5f, 0.5f);
    }
}

