/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Random;
import org.joml.Vector2d;
import org.joml.primitives.AABBd;
import org.joml.primitives.Rayd;

public class Particle {
    protected static final Random random = new Random();
    public IconCoordinate tex;
    protected float uo;
    protected float vo;
    protected int age;
    protected int lifetime;
    protected float size;
    protected float gravity;
    protected float rCol;
    protected float gCol;
    protected float bCol;
    protected int cachedLightmapCoord;
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double xo = 0.0;
    public double yo = 0.0;
    public double zo = 0.0;
    public double xd = 0.0;
    public double yd = 0.0;
    public double zd = 0.0;
    public boolean noPhysics = false;
    public boolean onGround = false;
    public boolean removed = false;
    @NotNull
    public final World world;
    private final AABBd __singleAABB = new AABBd();
    private final Vector2d __r = new Vector2d();
    private final Rayd __ray = new Rayd();
    private final List<AABB> aabbs = new ObjectArrayList<AABB>();
    private final AABB refAABB = AABB.fromPool(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public Particle(@NotNull World world, double x, double y, double z, double xa, double ya, double za) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.xd = xa + (double)((float)(java.lang.Math.random() * 2.0 - 1.0) * 0.4f);
        this.yd = ya + (double)((float)(java.lang.Math.random() * 2.0 - 1.0) * 0.4f);
        this.zd = za + (double)((float)(java.lang.Math.random() * 2.0 - 1.0) * 0.4f);
        float speed = (float)(java.lang.Math.random() + java.lang.Math.random() + 1.0) * 0.15f;
        float dd = MathHelper.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / (double)dd * (double)speed * 0.4;
        this.yd = this.yd / (double)dd * (double)speed * 0.4 + 0.1;
        this.zd = this.zd / (double)dd * (double)speed * 0.4;
        this.uo = random.nextFloat() * 3.0f;
        this.vo = random.nextFloat() * 3.0f;
        this.size = (random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.lifetime = (int)(4.0f / (random.nextFloat() * 0.9f + 0.1f));
        this.age = 0;
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
    }

    public Particle setPower(float power) {
        this.xd *= (double)power;
        this.yd = (this.yd - 0.1) * (double)power + 0.1;
        this.zd *= (double)power;
        return this;
    }

    public Particle setScale(float scale) {
        this.size *= scale;
        return this;
    }

    public void tick() {
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.98;
        this.yd *= 0.98;
        this.zd *= 0.98;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }

    public void move(double xd, double yd, double zd) {
        if (this.noPhysics) {
            this.onGround = false;
            this.x += xd;
            this.y += yd;
            this.z += zd;
            return;
        }
        HitResult hitResult = this.raycastBlocks(this.x, this.y, this.z, xd, yd, zd);
        if (hitResult instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)hitResult;
            switch (hitTile.side) {
                case EAST: 
                case WEST: {
                    this.x = hitTile.location.x += (double)hitTile.side.getOffsetX() * 0.01 * (double)this.size;
                    this.y += yd;
                    this.z += zd;
                    this.xd = 0.0;
                    break;
                }
                case TOP: {
                    this.onGround = true;
                }
                case BOTTOM: {
                    this.x += xd;
                    this.y = hitTile.location.y += (double)hitTile.side.getOffsetY() * 0.01 * (double)this.size;
                    this.z += zd;
                    this.yd = 0.0;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    this.x += xd;
                    this.y += yd;
                    this.z = hitTile.location.z += (double)hitTile.side.getOffsetZ() * 0.01 * (double)this.size;
                    this.zd = 0.0;
                }
            }
        } else {
            this.x += xd;
            this.y += yd;
            this.z += zd;
        }
    }

    @Nullable
    public HitResult raycastBlocks(double ox, double oy, double oz, double xd, double yd, double zd) {
        this.__ray.oX = ox;
        this.__ray.oY = oy;
        this.__ray.oZ = oz;
        double length = Math.sqrt(xd * xd + yd * yd + zd * zd);
        if (length <= 0.0) {
            return null;
        }
        this.__ray.dX = xd / length;
        this.__ray.dY = yd / length;
        this.__ray.dZ = zd / length;
        Rayd ray = this.__ray;
        double maxT = length;
        double dDistX = ray.dX == 0.0 ? Double.MAX_VALUE : Math.abs(1.0 / ray.dX);
        double dDistY = ray.dY == 0.0 ? Double.MAX_VALUE : Math.abs(1.0 / ray.dY);
        double dDistZ = ray.dZ == 0.0 ? Double.MAX_VALUE : Math.abs(1.0 / ray.dZ);
        int signX = (int)Math.signum(ray.dX);
        int signY = (int)Math.signum(ray.dY);
        int signZ = (int)Math.signum(ray.dZ);
        TilePos tilePos = new TilePos(ray.oX, ray.oY, ray.oZ);
        double sideDistX = -(ray.oX - ((double)tilePos.x + 0.5)) * (1.0 / ray.dX) + 0.5 * dDistX;
        double sideDistY = -(ray.oY - ((double)tilePos.y + 0.5)) * (1.0 / ray.dY) + 0.5 * dDistY;
        double sideDistZ = -(ray.oZ - ((double)tilePos.z + 0.5)) * (1.0 / ray.dZ) + 0.5 * dDistZ;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        Direction direction = Direction.NONE;
        while (dx * dx + dy * dy + dz * dz < length * length + 4.0) {
            Block<?> block = this.world.getBlock(tilePos);
            if (block != null && this.collidesWithBlock(block, this.world.getBlockData(tilePos))) {
                this.aabbs.clear();
                block.getCollisionAABBs(this.world, tilePos, this.refAABB.set(tilePos.x, tilePos.y, tilePos.z, tilePos.x + 1, tilePos.y + 1, tilePos.z + 1), this.aabbs);
                double tMin = Double.MAX_VALUE;
                int aabbsSize = this.aabbs.size();
                for (int i = 0; i < aabbsSize; ++i) {
                    AABB aabb = this.aabbs.get(i);
                    this.__singleAABB.setMin(aabb.minX, aabb.minY, aabb.minZ);
                    this.__singleAABB.setMax(aabb.maxX, aabb.maxY, aabb.maxZ);
                    if (!this.__singleAABB.intersectsRay(ray, this.__r)) continue;
                    tMin = Math.min(this.__r.x, tMin);
                }
                if (tMin < maxT) {
                    return new HitResult.Tile(tilePos, direction.getSide(), Vec3.fromPool(ray.oX + tMin * ray.dX, ray.oY + tMin * ray.dY, ray.oZ + tMin * ray.dZ));
                }
                return null;
            }
            if (Double.isFinite(sideDistX) && sideDistX < sideDistY && sideDistX < sideDistZ) {
                tilePos.x += signX;
                dx = (double)tilePos.x - ray.oX;
                sideDistX += dDistX;
                direction = signX > 0 ? Direction.WEST : Direction.EAST;
                continue;
            }
            if (Double.isFinite(sideDistY) && sideDistY < sideDistZ) {
                tilePos.y += signY;
                dy = (double)tilePos.y - ray.oY;
                sideDistY += dDistY;
                direction = signY > 0 ? Direction.DOWN : Direction.UP;
                continue;
            }
            if (Double.isFinite(sideDistZ)) {
                tilePos.z += signZ;
                dz = (double)tilePos.z - ray.oZ;
                sideDistZ += dDistZ;
                direction = signZ > 0 ? Direction.NORTH : Direction.SOUTH;
                continue;
            }
            return null;
        }
        return null;
    }

    public boolean collidesWithBlock(@NotNull Block<?> block, int data) {
        return true;
    }

    public void render(@NotNull ParticleTessellator t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmap(partialTick));
        } else if (!Global.accessor.isFullbrightEnabled()) {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin(), this.tex.getIconVMin(), this.tex.getIconUSize(), this.tex.getIconVSize());
    }

    public void renderLit(@NotNull Tessellator t, float partialTick, double xOff, double yOff, double zOff) {
    }

    public int getParticleTexture() {
        return 0;
    }

    public float calcBrightness(float partialTick) {
        if (Global.accessor.isFullbrightEnabled()) {
            return 1.0f;
        }
        TilePos pos = new TilePos(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick));
        if (this.world.areBlocksLoaded(pos, pos)) {
            return this.world.getLightBrightness(pos);
        }
        return 0.0f;
    }

    public float getBrightness(float partialTick) {
        return this.calcBrightness(partialTick);
    }

    public int calcLightmap(float partialTick) {
        int skylight;
        int blocklight;
        if (Global.accessor.isFullbrightEnabled()) {
            return 0xF0000F;
        }
        TilePos blockPos = new TilePos(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick));
        if (this.world.getBlockLitInteriorSurface(blockPos)) {
            TilePos tu = (TilePos)blockPos.up();
            TilePos tw = (TilePos)blockPos.west();
            TilePos te = (TilePos)blockPos.east();
            TilePos ts = (TilePos)blockPos.south();
            TilePos tn = (TilePos)blockPos.north();
            int bU = this.world.getSavedLightValue(LightLayer.Block, tu);
            int bW = this.world.getSavedLightValue(LightLayer.Block, tw);
            int bE = this.world.getSavedLightValue(LightLayer.Block, te);
            int bS = this.world.getSavedLightValue(LightLayer.Block, ts);
            int bN = this.world.getSavedLightValue(LightLayer.Block, tn);
            if (bW > bU) {
                bU = bW;
            }
            if (bE > bU) {
                bU = bE;
            }
            if (bS > bU) {
                bU = bS;
            }
            if (bN > bU) {
                bU = bN;
            }
            blocklight = bU;
            int sU = this.world.getSavedLightValue(LightLayer.Sky, tu);
            int sW = this.world.getSavedLightValue(LightLayer.Sky, tw);
            int sE = this.world.getSavedLightValue(LightLayer.Sky, te);
            int sS = this.world.getSavedLightValue(LightLayer.Sky, ts);
            int sN = this.world.getSavedLightValue(LightLayer.Sky, tn);
            if (sW > sU) {
                sU = sW;
            }
            if (sE > sU) {
                sU = sE;
            }
            if (sS > sU) {
                sU = sS;
            }
            if (sN > sU) {
                sU = sN;
            }
            skylight = sU;
        } else {
            skylight = this.world.getSavedLightValue(LightLayer.Sky, blockPos);
            blocklight = this.world.getSavedLightValue(LightLayer.Block, blockPos);
        }
        return this.world.getLightmapCoord(skylight, blocklight);
    }

    public int getLightmap(float partialTick) {
        return this.cachedLightmapCoord;
    }

    public void remove() {
        this.removed = true;
    }
}

