/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.shader.ShaderProvider;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;

public class Shader {
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected int program;
    protected int vertexShader;
    protected int fragmentShader;
    protected boolean enabled = false;
    protected final Object2IntMap<String> uniformLocations = new Object2IntArrayMap<String>();

    @NotNull
    public Shader compile(@NotNull ShaderProvider folder, @NotNull String name) {
        OpenGLHelper.checkError("pre compile shader " + name);
        this.delete();
        String fragmentSource = folder.getShaderSource(name + ".fsh");
        String vertexSource = folder.getShaderSource(name + ".vsh");
        if (fragmentSource == null) {
            return this;
        }
        if (vertexSource == null) {
            return this;
        }
        this.vertexShader = GL20.glCreateShader(35633);
        this.fragmentShader = GL20.glCreateShader(35632);
        GL20.glShaderSource(this.vertexShader, (CharSequence)vertexSource);
        GL20.glShaderSource(this.fragmentShader, (CharSequence)fragmentSource);
        GL20.glCompileShader(this.vertexShader);
        GL20.glCompileShader(this.fragmentShader);
        int fragmentShaderCompileStatus = GL20.glGetShaderi(this.fragmentShader, 35713);
        int vertexShaderCompileStatus = GL20.glGetShaderi(this.vertexShader, 35713);
        if (fragmentShaderCompileStatus != 1 || vertexShaderCompileStatus != 1) {
            LOGGER.error("Shader {} compile error", (Object)name);
            if (vertexShaderCompileStatus != 1) {
                LOGGER.error("Vertex Shader Info Log: {}", (Object)GL20.glGetShaderInfoLog(this.vertexShader, GL20.glGetShaderi(this.vertexShader, 35716)));
            }
            if (fragmentShaderCompileStatus != 1) {
                LOGGER.error("Fragment Shader Info Log: {}", (Object)GL20.glGetShaderInfoLog(this.fragmentShader, GL20.glGetShaderi(this.fragmentShader, 35716)));
            }
            this.delete();
            return this;
        }
        this.program = GL20.glCreateProgram();
        GL20.glAttachShader(this.program, this.fragmentShader);
        GL20.glAttachShader(this.program, this.vertexShader);
        GL20.glLinkProgram(this.program);
        int programLinkStatus = GL20.glGetProgrami(this.program, 35714);
        if (programLinkStatus != 1) {
            LOGGER.error("Program Link Error: ");
            LOGGER.error(GL20.glGetProgramInfoLog(this.program, GL20.glGetProgrami(this.program, 35716)));
            this.delete();
            return this;
        }
        GL20.glDeleteShader(this.vertexShader);
        GL20.glDeleteShader(this.fragmentShader);
        this.vertexShader = 0;
        this.fragmentShader = 0;
        this.enabled = true;
        OpenGLHelper.checkError("compile shader " + name);
        return this;
    }

    public int getUniform(String uniform) {
        int location = this.uniformLocations.getOrDefault((Object)uniform, -1);
        if (location == -1) {
            location = GL20.glGetUniformLocation(this.program, uniform);
            this.uniformLocations.put(uniform, location);
        }
        return location;
    }

    public void delete() {
        this.enabled = false;
        this.uniformLocations.clear();
        OpenGLHelper.checkError("pre delete shader");
        if (this.program != 0) {
            GL20.glDeleteProgram(this.program);
            this.program = 0;
        }
        if (this.fragmentShader != 0) {
            GL20.glDeleteShader(this.fragmentShader);
            this.fragmentShader = 0;
        }
        if (this.vertexShader != 0) {
            GL20.glDeleteShader(this.vertexShader);
            this.vertexShader = 0;
        }
        OpenGLHelper.checkError("delete shader");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void bind() {
        GL20.glUseProgram(this.program);
    }

    public void unbind() {
        GL20.glUseProgram(0);
    }

    public static int getCompileStatus(int shader) {
        return GL20.glGetShaderi(shader, 35713);
    }

    public void uniformFloat(String name, float value) {
        GL20.glUniform1f(this.getUniform(name), value);
    }

    public void uniformFloat(String name, boolean value) {
        this.uniformFloat(name, value ? 1.0f : 0.0f);
    }

    public void uniformInt(String name, int value) {
        GL20.glUniform1i(this.getUniform(name), value);
    }

    public void uniformBool(String name, boolean value) {
        GL20.glUniform1i(this.getUniform(name), value ? 1 : 0);
    }
}

