/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.linalg;

import java.util.Stack;
import net.minecraft.core.util.linalg.Matrix4;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class MatrixStack {
    @NotNull
    public static final MatrixStack MODEL_VIEW = new MatrixStack(5888);
    @NotNull
    public static final MatrixStack PROJECTION = new MatrixStack(5889);
    @NotNull
    public static final MatrixStack TEXTURE = new MatrixStack(5890);
    private final int matrixMode;
    @NotNull
    private final Stack<Matrix4> stack = new Stack();

    private MatrixStack(int matrixMode) {
        this.matrixMode = matrixMode;
        this.stack.push(Matrix4.identity());
    }

    @NotNull
    public Matrix4 peek() {
        return this.stack.peek();
    }

    @NotNull
    public MatrixStack push() {
        this.stack.push((Matrix4)this.peek().copyUnpooled());
        return this;
    }

    @NotNull
    public MatrixStack pop() {
        this.stack.pop();
        if (this.stack.isEmpty()) {
            this.stack.push(Matrix4.identity());
        }
        return this;
    }

    @NotNull
    public MatrixStack loadIdentity() {
        this.pop();
        this.stack.push(Matrix4.identity());
        return this;
    }

    @NotNull
    public MatrixStack load(@NotNull Matrix4 matrix) {
        this.pop();
        this.stack.push((Matrix4)matrix.copyUnpooled());
        return this;
    }

    @NotNull
    public MatrixStack writeToGpu() {
        GL11.glMatrixMode(this.matrixMode);
        GL11.glLoadMatrixd(this.peek().asArray());
        return this;
    }
}

