/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicAlgae
extends BlockLogic
implements IBonemealable {
    protected BlockLogicAlgae(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        this.setBlockBounds(0.0, -0.125, 0.0, 1.0, 0.00625f, 1.0);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        if (entity instanceof EntityBoat) {
            world.playBlockEvent(null, tilePos, 2001, this.block.id());
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        int blockId = world.getBlockId(tilePos);
        return blockId == 0 && Blocks.hasTag(world.getBlockId((TilePos)tilePos.down()), BlockTags.IS_WATER) && world.getBlockData((TilePos)tilePos.down()) == 0;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!Blocks.hasTag(world.getBlockId((TilePos)tilePos.down()), BlockTags.IS_WATER) || world.getBlockData((TilePos)tilePos.down()) != 0) {
            world.setBlockId(tilePos, 0);
        }
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.block);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull Random rand = world.rand;
        if (!world.isClientSide) {
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemStack.stackSize;
            }
            block0: for (int i = 0; i < 128; ++i) {
                @NotNull TilePos localPos = new TilePos(tilePos);
                for (int j = 0; j < i / 16; ++j) {
                    localPos.x += rand.nextInt(3) - 1;
                    localPos.z += rand.nextInt(3) - 1;
                    int bId = world.getBlockId((TilePos)localPos.down());
                    int bMeta = world.getBlockData((TilePos)localPos.down());
                    if (bId != Blocks.FLUID_WATER_FLOWING.id() && bId != Blocks.FLUID_WATER_STILL.id() || bMeta != 0) continue block0;
                }
                if (world.getBlockId(localPos) != 0 || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockIdNotify(localPos, this.block.id());
            }
            return true;
        }
        return true;
    }
}

