/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicAxisAligned
extends BlockLogic {
    public static final int MASK_DIRECTION = 3;

    public BlockLogicAxisAligned(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        @NotNull Axis axis = mob.getPlacementDirection(side, PlacementMode.SIDE).getAxis();
        world.setBlockDataNotify(tilePos, BlockLogicAxisAligned.axisToMeta(axis));
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        @NotNull Axis axis = side.getAxis();
        world.setBlockDataNotify(tilePos, BlockLogicAxisAligned.axisToMeta(axis));
    }

    public static int axisToMeta(@NotNull Axis axis) {
        if (axis == Axis.X) {
            return 2;
        }
        if (axis == Axis.Z) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public static Axis metaToAxis(int meta) {
        if (meta == 2) {
            return Axis.X;
        }
        if (meta == 1) {
            return Axis.Z;
        }
        return Axis.Y;
    }
}

