/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicBoneShale
extends BlockLogicFullyRotatable {
    public BlockLogicBoneShale(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public float getStrength(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, @NotNull Player player) {
        int data = world.getBlockData(tilePos);
        @NotNull Direction direction = BlockLogicFullyRotatable.metaToDirection(data);
        float blockHardness = this.block.getHardness();
        if (side != direction.getSide()) {
            blockHardness *= 66.6f;
        }
        if (!player.canHarvestBlock(this.block)) {
            return 1.0f / blockHardness / 30.0f;
        }
        return player.getCurrentPlayerStrVsBlock(this.block) / blockHardness / 30.0f;
    }
}

