/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicCake
extends BlockLogicEdible {
    public BlockLogicCake(@NotNull Block<?> block) {
        super(block, 6, () -> Items.FOOD_CAKE);
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int data = source.getBlockData(tilePos);
        float gap = 0.0625f;
        float width = (float)(1 + data * 2) / 16.0f;
        float height = 0.5f;
        return AABB.fromPool(width, 0.0, 0.0625, 0.9375, 0.5, 0.9375);
    }

    @Override
    public int getHealAmount(@NotNull World world, @NotNull TilePos tilePos) {
        return 3;
    }
}

