/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicMoss;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.weather.IPrecipitation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFire
extends BlockLogic {
    public static final int FLAME_INSTANT = 60;
    public static final int FLAME_EASY = 30;
    public static final int FLAME_MEDIUM = 15;
    public static final int FLAME_HARD = 5;
    public static final int BURN_INSTANT = 100;
    public static final int BURN_EASY = 60;
    public static final int BURN_MEDIUM = 20;
    public static final int BURN_HARD = 5;
    public static final int BURN_NEVER = 0;
    private static final int @NotNull [] flameChance = new int[Blocks.blocksList.length];
    private static final int @NotNull [] burnChance = new int[Blocks.blocksList.length];

    public BlockLogicFire(@NotNull Block<?> block) {
        super(block, Material.fire);
        block.setTicking(true);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return null;
    }

    @Override
    public void initializeBlock() {
        BlockLogicFire.setFlammable(Blocks.PLANKS_OAK, 5, 20);
        BlockLogicFire.setFlammable(Blocks.PLANKS_OAK_PAINTED, 5, 20);
        BlockLogicFire.setFlammable(Blocks.FENCE_PLANKS_OAK, 5, 20);
        BlockLogicFire.setFlammable(Blocks.FENCE_PLANKS_OAK_PAINTED, 5, 20);
        BlockLogicFire.setFlammable(Blocks.SLAB_PLANKS_OAK, 5, 20);
        BlockLogicFire.setFlammable(Blocks.SLAB_PLANKS_PAINTED, 5, 20);
        BlockLogicFire.setFlammable(Blocks.STAIRS_PLANKS_OAK, 5, 20);
        BlockLogicFire.setFlammable(Blocks.LOG_OAK, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_PINE, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_BIRCH, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_CHERRY, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_OAK_MOSSY, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_EUCALYPTUS, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_THORN, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LOG_PALM, 5, 5);
        BlockLogicFire.setFlammable(Blocks.LEAVES_OAK, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_PINE, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_BIRCH, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_CHERRY, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_CHERRY_FLOWERING, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_OAK_RETRO, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_SHRUB, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_EUCALYPTUS, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_CACAO, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_THORN, 30, 60);
        BlockLogicFire.setFlammable(Blocks.LEAVES_PALM, 30, 60);
        BlockLogicFire.setFlammable(Blocks.BOOKSHELF_PLANKS_OAK, 30, 20);
        BlockLogicFire.setFlammable(Blocks.TNT, 15, 100);
        BlockLogicFire.setFlammable(Blocks.WOOL, 30, 60);
        BlockLogicFire.setFlammable(Blocks.MOSS_STONE, 100, 30);
        BlockLogicFire.setFlammable(Blocks.MOSS_BASALT, 100, 30);
        BlockLogicFire.setFlammable(Blocks.MOSS_LIMESTONE, 100, 30);
        BlockLogicFire.setFlammable(Blocks.MOSS_GRANITE, 100, 30);
    }

    public static void setFlammable(@NotNull Block<?> block, int flameChance, int burnChance) {
        BlockLogicFire.flameChance[block.id()] = flameChance;
        BlockLogicFire.burnChance[block.id()] = burnChance;
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)tilePos.x + Math.random(), (double)tilePos.y + 0.5, (double)tilePos.z + Math.random(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public int tickDelay() {
        return 40;
    }

    public void setBurnResult(@NotNull World world, @NotNull TilePos tilePos) {
        world.setBlockIdNotify(tilePos, this.getBurnResultId(world, tilePos));
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        boolean infiniBurn;
        @Nullable Block<?> blockUnder = world.getBlock((TilePos)tilePos.down());
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN);
        if (!this.isValidFireLocation(world, tilePos)) {
            this.setBurnResult(world, tilePos);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather() instanceof IPrecipitation && (world.isBlockBeingRainedOn(tilePos) || world.isBlockBeingRainedOn((TilePos)tilePos.west()) || world.isBlockBeingRainedOn((TilePos)tilePos.east()) || world.isBlockBeingRainedOn((TilePos)tilePos.north()) || world.isBlockBeingRainedOn((TilePos)tilePos.south()))) {
            this.setBurnResult(world, tilePos);
            return;
        }
        int meta = world.getBlockData(tilePos);
        if (meta < 15) {
            world.setBlockData(tilePos, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
        if (!infiniBurn && !this.canNeighborCatchFire(world, tilePos)) {
            if (!world.isBlockNormalCube((TilePos)tilePos.down()) || meta > 3) {
                this.setBurnResult(world, tilePos);
            }
            return;
        }
        if (!infiniBurn && !BlockLogicFire.canBurn(world, (TilePos)tilePos.down()) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, tilePos);
            return;
        }
        this.checkBurn(world, (TilePos)tilePos.east(), 300, rand, meta);
        this.checkBurn(world, (TilePos)tilePos.west(), 300, rand, meta);
        this.checkBurn(world, (TilePos)tilePos.down(), 250, rand, meta);
        this.checkBurn(world, (TilePos)tilePos.up(), 250, rand, meta);
        this.checkBurn(world, (TilePos)tilePos.north(), 300, rand, meta);
        this.checkBurn(world, (TilePos)tilePos.south(), 300, rand, meta);
        @NotNull TilePos localPos = new TilePos(tilePos);
        localPos.x = tilePos.x - 1;
        while (localPos.x <= tilePos.x + 1) {
            localPos.z = tilePos.z - 1;
            while (localPos.z <= tilePos.z + 1) {
                localPos.y = tilePos.y - 1;
                while (localPos.y <= tilePos.y + 4) {
                    if (!localPos.equals(tilePos)) {
                        int c;
                        int b;
                        int a = 100;
                        if (localPos.y > tilePos.y + 1) {
                            a += (localPos.y - (tilePos.y + 1)) * 100;
                        }
                        if (!((b = this.getFireChance(world, localPos)) <= 0 || (c = (b + 40) / (meta + 30)) <= 0 || rand.nextInt(a) > c || world.getCurrentWeather() != null && world.getCurrentWeather() instanceof IPrecipitation && world.isBlockBeingRainedOn(localPos) || world.isBlockBeingRainedOn((TilePos)localPos.west()) || world.isBlockBeingRainedOn((TilePos)localPos.east()) || world.isBlockBeingRainedOn((TilePos)localPos.north()) || world.isBlockBeingRainedOn((TilePos)localPos.south()) || !world.getGameRuleValue(GameRules.DO_FIRE_SPREAD).booleanValue() || this.getBurnResultId(world, localPos) != 0)) {
                            world.setBlockIdDataNotify(localPos, this.block.id(), Math.min(meta + rand.nextInt(5) / 4, 15));
                        }
                    }
                    ++localPos.y;
                }
                ++localPos.z;
            }
            ++localPos.x;
        }
    }

    private void checkBurn(@NotNull World world, @NotNull TilePos tilePos, int chance, @NotNull Random random, int meta) {
        if (!world.getGameRuleValue(GameRules.DO_FIRE_SPREAD).booleanValue()) {
            return;
        }
        if (random.nextInt(chance) < burnChance[world.getBlockId(tilePos)]) {
            boolean isTNT;
            boolean bl = isTNT = world.getBlockId(tilePos) == Blocks.TNT.id();
            if (random.nextInt(meta + 10) < 5 && !world.isBlockBeingRainedOn(tilePos)) {
                if (this.getBurnResultId(world, tilePos) == 0) {
                    world.setBlockIdDataNotify(tilePos, this.block.id(), Math.min(meta + random.nextInt(5) / 4, 15));
                }
            } else {
                this.setBurnResult(world, tilePos);
            }
            if (isTNT) {
                Blocks.TNT.getLogic().ignite(world, tilePos, true);
            }
        }
    }

    protected boolean canNeighborCatchFire(@NotNull World world, @NotNull TilePos tilePos) {
        if (BlockLogicFire.canBurn(world, (TilePos)tilePos.east())) {
            return true;
        }
        if (BlockLogicFire.canBurn(world, (TilePos)tilePos.west())) {
            return true;
        }
        if (BlockLogicFire.canBurn(world, (TilePos)tilePos.down())) {
            return true;
        }
        if (BlockLogicFire.canBurn(world, (TilePos)tilePos.up())) {
            return true;
        }
        if (BlockLogicFire.canBurn(world, (TilePos)tilePos.north())) {
            return true;
        }
        return BlockLogicFire.canBurn(world, (TilePos)tilePos.south());
    }

    private int getFireChance(@NotNull World world, @NotNull TilePos tilePos) {
        int flammability = 0;
        if (!world.isAirBlock(tilePos)) {
            return 0;
        }
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.east(), flammability);
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.west(), flammability);
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.down(), flammability);
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.up(), flammability);
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.north(), flammability);
        flammability = BlockLogicFire.getFlammability(world, (TilePos)tilePos.south(), flammability);
        return flammability;
    }

    public static boolean canBurn(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return flameChance[source.getBlockId(tilePos)] > 0;
    }

    public static boolean canBurn(int blockId) {
        return flameChance[blockId] > 0;
    }

    public static int getFlammability(@NotNull World world, @NotNull TilePos tilePos, int currentFlameChance) {
        int blockFlameChance = flameChance[world.getBlockId(tilePos)];
        return Math.max(blockFlameChance, currentFlameChance);
    }

    public boolean isValidFireLocation(@NotNull World world, @NotNull TilePos tilePos) {
        return world.isBlockNormalCube((TilePos)tilePos.down()) || this.canNeighborCatchFire(world, tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.isValidFireLocation(world, tilePos);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!world.isBlockNormalCube((TilePos)tilePos.down()) && !this.canNeighborCatchFire(world, tilePos)) {
            world.setBlockIdNotify(tilePos, this.getBurnResultId(world, tilePos));
        }
    }

    protected int getBurnResultId(@NotNull World world, @NotNull TilePos tilePos) {
        int id = world.getBlockId(tilePos);
        @Nullable Block<?> stoneBlock = BlockLogicMoss.getStoneBlock(id);
        if (stoneBlock != null) {
            return stoneBlock.id();
        }
        return 0;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.getBlockId((TilePos)tilePos.down()) == Blocks.OBSIDIAN.id() && Blocks.PORTAL_NETHER.getLogic().tryToCreatePortal(world, tilePos, null)) {
            return;
        }
        if (!world.isBlockNormalCube((TilePos)tilePos.down()) && !this.canNeighborCatchFire(world, tilePos)) {
            world.setBlockIdNotify(tilePos, this.getBurnResultId(world, tilePos));
        } else {
            world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        block12: {
            double z;
            double y;
            double x;
            int i;
            block11: {
                if (rand.nextInt(24) == 0) {
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)tilePos.x + 0.5f, (float)tilePos.y + 0.5f, (float)tilePos.z + 0.5f, "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f);
                }
                if (!world.isBlockNormalCube((TilePos)tilePos.down()) && !BlockLogicFire.canBurn(world, (TilePos)tilePos.down())) break block11;
                for (int l = 0; l < 3; ++l) {
                    double x2 = (float)tilePos.x + rand.nextFloat();
                    double y2 = (float)tilePos.y + rand.nextFloat() * 0.5f + 0.5f;
                    double z2 = (float)tilePos.z + rand.nextFloat();
                    world.spawnParticle("largesmoke", x2, y2, z2, 0.0, 0.0, 0.0, 0);
                }
                break block12;
            }
            if (BlockLogicFire.canBurn(world, (TilePos)tilePos.west())) {
                for (i = 0; i < 2; ++i) {
                    x = (float)tilePos.x + rand.nextFloat() * 0.1f;
                    y = (float)tilePos.y + rand.nextFloat();
                    z = (float)tilePos.z + rand.nextFloat();
                    world.spawnParticle("largesmoke", x, y, z, 0.0, 0.0, 0.0, 0);
                }
            }
            if (BlockLogicFire.canBurn(world, (TilePos)tilePos.east())) {
                for (i = 0; i < 2; ++i) {
                    x = (float)(tilePos.x + 1) - rand.nextFloat() * 0.1f;
                    y = (float)tilePos.y + rand.nextFloat();
                    z = (float)tilePos.z + rand.nextFloat();
                    world.spawnParticle("largesmoke", x, y, z, 0.0, 0.0, 0.0, 0);
                }
            }
            if (BlockLogicFire.canBurn(world, (TilePos)tilePos.north())) {
                for (i = 0; i < 2; ++i) {
                    x = (float)tilePos.x + rand.nextFloat();
                    y = (float)tilePos.y + rand.nextFloat();
                    z = (float)tilePos.z + rand.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", x, y, z, 0.0, 0.0, 0.0, 0);
                }
            }
            if (BlockLogicFire.canBurn(world, (TilePos)tilePos.south())) {
                for (i = 0; i < 2; ++i) {
                    x = (float)tilePos.x + rand.nextFloat();
                    y = (float)tilePos.y + rand.nextFloat();
                    z = (float)(tilePos.z + 1) - rand.nextFloat() * 0.1f;
                    world.spawnParticle("largesmoke", x, y, z, 0.0, 0.0, 0.0, 0);
                }
            }
            if (!BlockLogicFire.canBurn(world, (TilePos)tilePos.up())) break block12;
            for (i = 0; i < 2; ++i) {
                x = (float)tilePos.x + rand.nextFloat();
                y = (float)(tilePos.y + 1) - rand.nextFloat() * 0.1f;
                z = (float)tilePos.z + rand.nextFloat();
                world.spawnParticle("largesmoke", x, y, z, 0.0, 0.0, 0.0, 0);
            }
        }
    }
}

