/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicFlower
extends BlockLogic
implements IBonemealable {
    public static final int MASK_PERMANENT = 128;
    public boolean killedByWeather = false;
    public boolean canBeBonemealed = false;

    public BlockLogicFlower(@NotNull Block<?> block) {
        super(block, Material.plant);
        block.setTicking(true);
        float f = 0.2f;
        this.setBlockBounds(0.3f, 0.0, 0.3f, 0.7f, 0.6f, 0.7f);
    }

    @NotNull
    public final BlockLogicFlower setKilledByWeather() {
        this.killedByWeather = true;
        return this;
    }

    @NotNull
    public final BlockLogicFlower setBonemealable() {
        this.canBeBonemealed = true;
        return this;
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        return 128;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return super.canPlaceAt(world, tilePos) && this.mayPlaceOn(world.getBlockId((TilePos)tilePos.down()));
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    protected boolean mayPlaceOn(int blockId) {
        @Nullable Block<?> block = Blocks.getBlock(blockId);
        return block != null && block.hasTag(BlockTags.GROWS_FLOWERS);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        super.onNeighborChanged(world, tilePos, id);
        this.checkAlive(world, tilePos);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.checkAlive(world, tilePos);
        if (world.getGameRuleValue(GameRules.DO_SEASONAL_GROWTH).booleanValue() && world.getSeasonManager().getCurrentSeason() != null && !BlockLogicFlower.isPermanent(world.getBlockData(tilePos)) && world.getSeasonManager().getCurrentSeason().killFlowers && this.killedByWeather && rand.nextInt(256) == 0) {
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    protected final void checkAlive(@NotNull World world, @NotNull TilePos tilePos) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        return (world.getFullBlockLightValue(tilePos) >= 8 || world.canBlockSeeSky(tilePos)) && this.mayPlaceOn(world.getBlockId((TilePos)tilePos.down()));
    }

    public static boolean isPermanent(int metadata) {
        return (metadata & 0x80) > 0;
    }

    public static int setPermanent(int metadata, boolean permanent) {
        return metadata & 0xFFFFFF7F | (permanent ? 128 : 0);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, @NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        Random rand = world.rand;
        if (!world.isClientSide && this.canBeBonemealed && itemStack.consumeItem(player)) {
            int meta;
            if (Block.hasLogicClass(world.getBlock(tilePos), BlockLogicFlowerStackable.class) && BlockLogicFlowerStackable.getStackCount(meta = world.getBlockData(tilePos)) < 3) {
                world.setBlockDataNotify(tilePos, BlockLogicFlowerStackable.setStackCount(meta, BlockLogicFlowerStackable.getStackCount(meta) + 1));
            }
            block0: for (int i = 0; i < 128; ++i) {
                @NotNull TilePos localPos = new TilePos(tilePos);
                for (int j = 0; j < i / 16; ++j) {
                    localPos.x += rand.nextInt(3) - 1;
                    localPos.y += (rand.nextInt(3) - 1) * rand.nextInt(3) / 2;
                    localPos.z += rand.nextInt(3) - 1;
                    int blockId = world.getBlockId((TilePos)localPos.down());
                    if (!this.mayPlaceOn(blockId)) continue block0;
                }
                @Nullable Block<?> b = world.getBlock(localPos);
                if (Block.hasLogicClass(b, BlockLogicFlowerStackable.class)) {
                    int meta2 = world.getBlockData(localPos);
                    if (BlockLogicFlowerStackable.getStackCount(meta2) >= 3) continue;
                    world.setBlockDataNotify(localPos, BlockLogicFlowerStackable.setStackCount(meta2, BlockLogicFlowerStackable.getStackCount(meta2) + 1));
                    continue;
                }
                if (b != null || !((double)rand.nextFloat() > 0.75)) continue;
                world.setBlockIdNotify(localPos, this.block.id());
            }
            return true;
        }
        return this.canBeBonemealed;
    }
}

