/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLayerAsh
extends BlockLogicLayerBase {
    public BlockLogicLayerAsh(Block<? extends BlockLogicLayerBase> block, Block<?> fullBlock, Material material) {
        super(block, fullBlock, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setTicking(true);
    }

    public void accumulate(@NotNull World world, @NotNull TilePos tilePos) {
        int myMetadata = world.getBlockData(tilePos);
        if (myMetadata == 7) {
            return;
        }
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            TilePos dirPos = (TilePos)tilePos.add(dir);
            if (world.isBlockOpaqueCube(dirPos) || world.getBlockId(dirPos) == this.block.id() && world.getBlockData(dirPos) >= myMetadata) continue;
            return;
        }
        world.setBlockData(tilePos, myMetadata + 1);
        world.markBlockNeedsUpdate(tilePos);
    }

    @Override
    public boolean canPlaceAt(World world, @NotNull TilePos tilePos) {
        TilePos down = (TilePos)tilePos.down();
        Block<?> b = world.getBlock(down);
        if (b == null || !b.isSolidRender()) {
            return false;
        }
        Material material = world.getBlockMaterial(down);
        return material.blocksMotion();
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this, data + 1);
                break;
            }
            case PICK_BLOCK: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }
}

