/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicLayerSnow
extends BlockLogicLayerBase {
    public BlockLogicLayerSnow(@NotNull Block<? extends BlockLogicLayerBase> block, @Nullable Block<?> fullBlock, @NotNull Material material) {
        super(block, fullBlock, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
        block.setTicking(true);
    }

    public void accumulate(@NotNull World world, @NotNull TilePos tilePos) {
        int myMetadata = world.getBlockData(tilePos);
        if (myMetadata == 7) {
            return;
        }
        for (int i = 0; i < Direction.horizontalDirections.length; ++i) {
            Direction dir = Direction.horizontalDirections[i];
            TilePos dirPos = (TilePos)tilePos.add(dir);
            if (world.isBlockOpaqueCube(dirPos) || world.getBlockId(dirPos) == this.block.id() && world.getBlockData(dirPos) >= myMetadata) continue;
            return;
        }
        world.setBlockData(tilePos, myMetadata + 1);
        world.markBlockNeedsUpdate(tilePos);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos down = (TilePos)tilePos.down();
        Block<?> b = world.getBlock(down);
        if (b == null || !b.isSolidRender() && !(b.getLogic() instanceof BlockLogicLeavesBase)) {
            return false;
        }
        Material material = world.getBlockMaterial(down);
        return material == Material.leaves || material.blocksMotion();
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        AABB aabb = this.getBounds();
        aabb.maxY = Math.max(aabb.maxY - 0.125, (double)tilePos.y);
        return aabb;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canPlaceAt(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this, data + 1);
                break;
            }
            case PICK_BLOCK: {
                ItemStack[] itemStackArray3 = new ItemStack[1];
                itemStackArray = itemStackArray3;
                itemStackArray3[0] = new ItemStack(this);
                break;
            }
            case EXPLOSION: 
            case PROPER_TOOL: {
                ItemStack[] itemStackArray4 = new ItemStack[1];
                itemStackArray = itemStackArray4;
                itemStackArray4[0] = new ItemStack(Items.AMMO_SNOWBALL, data + 1);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.getSavedLightValue(LightLayer.Block, tilePos) > 11) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
        if (!world.getBlockBiome(tilePos).hasSurfaceSnow() && world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().letWeatherCleanUpSnow) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }
}

