/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMud
extends BlockLogic {
    private final boolean isHardened;

    public BlockLogicMud(@NotNull Block<?> block, @NotNull Material material, boolean isHardened) {
        super(block, material);
        this.isHardened = isHardened;
    }

    @Override
    public int tickDelay() {
        return 5;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
    }

    private boolean isWaterNearby(@NotNull World world, @NotNull TilePos tilePos, int range) {
        TilePos p = new TilePos(tilePos);
        for (int x = tilePos.x - range; x <= tilePos.x + range; ++x) {
            for (int y = tilePos.y - range; y <= tilePos.y + range; ++y) {
                for (int z = tilePos.z - range; z <= tilePos.z + range; ++z) {
                    if (!Blocks.hasTag(world.getBlockId(p.set(x, y, z)), BlockTags.IS_WATER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isLavaNearby(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos p = new TilePos(tilePos);
        for (int x = tilePos.x - 1; x <= tilePos.x + 1; ++x) {
            for (int y = tilePos.y - 1; y <= tilePos.y + 1; ++y) {
                for (int z = tilePos.z - 1; z <= tilePos.z + 1; ++z) {
                    if (!Blocks.hasTag(world.getBlockId(p.set(x, y, z)), BlockTags.IS_LAVA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canBecomeWet(@NotNull World world, @NotNull TilePos tilePos) {
        if (this.isWaterNearby(world, tilePos, 1)) {
            return true;
        }
        if (this.isWaterNearby(world, tilePos, 3)) {
            TilePos p = new TilePos(tilePos);
            for (int x = tilePos.x - 1; x <= tilePos.x + 1; ++x) {
                for (int y = tilePos.y - 1; y <= tilePos.y + 1; ++y) {
                    for (int z = tilePos.z - 1; z <= tilePos.z + 1; ++z) {
                        int bID = world.getBlockId(p.set(x, y, z));
                        if (bID != Blocks.MUD.id() && (bID != Blocks.FARMLAND_DIRT.id() || !BlockLogicFarmland.isWet(world.getBlockData(p)))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, data)};
    }

    private void tryToFall(@NotNull World world, @NotNull TilePos tilePos) {
        if (world.getBlockId(tilePos) == Blocks.MUD_BAKED.id()) {
            return;
        }
        if (BlockLogicMud.canFallBelow(world, (TilePos)tilePos.down()) && tilePos.y >= 0) {
            int radius = 32;
            if (!world.areBlocksLoaded(tilePos.add(-radius, -radius, -radius), tilePos.add(radius, radius, radius))) {
                world.setBlockIdNotify(tilePos, 0);
                TilePos p = (TilePos)tilePos.down();
                while (BlockLogicMud.canFallBelow(world, p) && p.y >= 0) {
                    --p.y;
                }
                if (p.y > 0) {
                    world.setBlockIdNotify(p, this.block.id());
                }
            } else {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, this.block.id(), 0, null);
                world.entityJoinedWorld(entityFallingBlock);
            }
        }
    }

    public static boolean canFallBelow(@NotNull World world, @NotNull TilePos tilePos) {
        int blockId = world.getBlockId(tilePos);
        return blockId == 0 || blockId == Blocks.FIRE.id() || Blocks.hasTag(blockId, BlockTags.IS_WATER) || Blocks.hasTag(blockId, BlockTags.IS_LAVA);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (this.isHardened && !this.isLavaNearby(world, tilePos) && this.canBecomeWet(world, tilePos)) {
            world.setBlockId(tilePos, Blocks.MUD.id());
            world.notifyBlockChange(tilePos, Blocks.MUD.id());
            return;
        }
        if (!this.isHardened && (this.isLavaNearby(world, tilePos) || world.dimension == Dimension.NETHER)) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)tilePos.x + Math.random(), (double)tilePos.y + Math.random(), (double)tilePos.z + Math.random(), 0.0, 0.0, 0.0, 0);
            }
            world.setBlockId(tilePos, Blocks.MUD_BAKED.id());
            world.notifyBlockChange(tilePos, Blocks.MUD_BAKED.id());
            return;
        }
        this.tryToFall(world, tilePos);
    }
}

