/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.logic.RailDirection;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicRail
extends BlockLogic
implements ISupportable {
    public static final int MASK_DIRECTION = 7;
    public static final int MASK_POWERED = 8;
    public final boolean isPowered;

    public static boolean isRailBlockAt(@NotNull World world, @NotNull TilePos tilePos) {
        return world.getBlockLogic(tilePos, BlockLogicRail.class) != null;
    }

    protected BlockLogicRail(@NotNull Block<?> block, boolean isPowered) {
        super(block, Material.decoration);
        this.isPowered = isPowered;
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @NotNull
    public RailDirection getRailDirection(@NotNull WorldSource world, @NotNull TilePos tilePos) {
        int meta = world.getBlockData(tilePos);
        if (this.isPowered) {
            meta &= 7;
        }
        return RailDirection.getFromMeta(meta);
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        RailDirection direction = this.getRailDirection(source, tilePos);
        if (direction.isSloped()) {
            return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 0.725f, 1.0);
        }
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        this.performRailTurn(world, tilePos, true);
        if (this.block == Blocks.RAIL_POWERED) {
            this.onNeighborChanged(world, tilePos, this.id());
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockData(tilePos);
        boolean isPoweredFlagSet = (meta & 8) != 0;
        RailDirection railDirection = this.getRailDirection(world, tilePos);
        if (!this.isSupported(world, tilePos, Side.BOTTOM)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
            return;
        }
        if (!this.isRailValid(world, tilePos)) {
            switch (railDirection) {
                case SLOPE_W: 
                case SLOPE_E: {
                    railDirection = RailDirection.STRAIGHT_EW;
                    world.setBlockDataNotify(tilePos, railDirection.meta);
                    break;
                }
                case SLOPE_N: 
                case SLOPE_S: {
                    railDirection = RailDirection.STRAIGHT_NS;
                    world.setBlockDataNotify(tilePos, railDirection.meta);
                }
            }
        }
        Block<?> block = Blocks.getBlock(id);
        if (this.block == Blocks.RAIL_POWERED) {
            boolean gettingPower = world.hasNeighborSignal(tilePos) || world.hasNeighborSignal((TilePos)tilePos.up()) || this.isConnectedPoweredRail1(world, tilePos, true, 0) || this.isConnectedPoweredRail1(world, tilePos, false, 0);
            boolean changedMeta = false;
            if (gettingPower && !isPoweredFlagSet) {
                world.setBlockDataNotify(tilePos, railDirection.meta | 8);
                changedMeta = true;
            } else if (!gettingPower && isPoweredFlagSet) {
                world.setBlockDataNotify(tilePos, railDirection.meta);
                changedMeta = true;
            }
            if (changedMeta) {
                world.notifyBlocksOfNeighborChange((TilePos)tilePos.down(), this.id());
                if (railDirection.isSloped()) {
                    world.notifyBlocksOfNeighborChange((TilePos)tilePos.up(), this.id());
                }
            }
        } else if (block != null && block.isSignalSource() && new Rail(world, tilePos).getAdjacentTracks() == 3) {
            this.performRailTurn(world, tilePos, false);
        }
    }

    private boolean isRailValid(@NotNull World world, @NotNull TilePos tilePos) {
        return switch (this.getRailDirection(world, tilePos)) {
            case RailDirection.SLOPE_E -> this.isSupported(world, tilePos.add(1, 1, 0), Side.BOTTOM);
            case RailDirection.SLOPE_W -> this.isSupported(world, tilePos.add(-1, 1, 0), Side.BOTTOM);
            case RailDirection.SLOPE_N -> this.isSupported(world, tilePos.add(0, 1, -1), Side.BOTTOM);
            case RailDirection.SLOPE_S -> this.isSupported(world, tilePos.add(0, 1, 1), Side.BOTTOM);
            default -> true;
        };
    }

    private void performRailTurn(@NotNull World world, @NotNull TilePos tilePos, boolean forceUpdate) {
        if (!world.isClientSide) {
            new Rail(world, tilePos).railTurn(world.hasNeighborSignal(tilePos), forceUpdate);
        }
    }

    private boolean isConnectedPoweredRail1(@NotNull World world, @NotNull TilePos tilePos, boolean forward, int distance) {
        if (distance >= 8) {
            return false;
        }
        RailDirection railDirection = this.getRailDirection(world, tilePos);
        Axis axis = Axis.NONE;
        TilePos next = forward ? railDirection.getNextRail(tilePos) : railDirection.getPrevRail(tilePos);
        switch (railDirection) {
            case SLOPE_N: 
            case SLOPE_S: 
            case STRAIGHT_NS: {
                Axis axis2 = Axis.Z;
                break;
            }
            case SLOPE_W: 
            case SLOPE_E: 
            case STRAIGHT_EW: {
                Axis axis2 = Axis.X;
                break;
            }
            default: {
                Axis axis2 = axis = axis;
            }
        }
        if (this.isConnectedPoweredRail2(world, next, forward, distance, axis)) {
            return true;
        }
        return this.isConnectedPoweredRail2(world, (TilePos)next.down(), forward, distance, axis);
    }

    private boolean isConnectedPoweredRail2(@NotNull World world, @NotNull TilePos tilePos, boolean forward, int distance, @NotNull Axis axis) {
        int blockId = world.getBlockId(tilePos);
        if (blockId == Blocks.RAIL_POWERED.id()) {
            int meta = world.getBlockData(tilePos);
            boolean isPoweredFlagSet = (meta & 8) != 0;
            RailDirection direction = this.getRailDirection(world, tilePos);
            if (axis == Axis.X && (direction == RailDirection.STRAIGHT_NS || direction == RailDirection.SLOPE_N || direction == RailDirection.SLOPE_S)) {
                return false;
            }
            if (axis == Axis.Z && (direction == RailDirection.STRAIGHT_EW || direction == RailDirection.SLOPE_E || direction == RailDirection.SLOPE_W)) {
                return false;
            }
            if (isPoweredFlagSet) {
                if (world.hasNeighborSignal(tilePos) || world.hasNeighborSignal((TilePos)tilePos.up())) {
                    return true;
                }
                return this.isConnectedPoweredRail1(world, tilePos, forward, distance + 1);
            }
        }
        return false;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePos tilePos) {
        return 0;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return side == Side.BOTTOM ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }

    public static class Rail {
        @NotNull
        private final World world;
        @NotNull
        private final TilePos pos;
        private final boolean isPoweredRail;
        @NotNull
        private final List<TilePos> connectedTracks = new ArrayList<TilePos>();

        public Rail(@NotNull World world, @NotNull TilePos pos) {
            this.world = world;
            this.pos = pos;
            BlockLogicRail logicRail = world.getBlockLogic(pos, BlockLogicRail.class);
            this.isPoweredRail = logicRail != null && logicRail.isPowered;
            int meta = world.getBlockData(pos) & (this.isPoweredRail ? 7 : 255);
            this.setConnections(RailDirection.getFromMeta(meta));
        }

        private void setConnections(@NotNull RailDirection direction) {
            this.connectedTracks.clear();
            this.connectedTracks.add(direction.getNextRail(this.pos));
            this.connectedTracks.add(direction.getPrevRail(this.pos));
        }

        private void checkAndRemoveMissingRails() {
            for (int i = 0; i < this.connectedTracks.size(); ++i) {
                Rail rail = this.getMinecartTrackLogic(this.connectedTracks.get(i));
                if (rail == null || !rail.isConnectedTo(this)) {
                    this.connectedTracks.remove(i--);
                    continue;
                }
                this.connectedTracks.set(i, rail.pos);
            }
        }

        private boolean isMinecartTrack(@NotNull TilePos tilePos) {
            if (BlockLogicRail.isRailBlockAt(this.world, tilePos)) {
                return true;
            }
            if (BlockLogicRail.isRailBlockAt(this.world, (TilePos)tilePos.up())) {
                return true;
            }
            return BlockLogicRail.isRailBlockAt(this.world, (TilePos)tilePos.down());
        }

        @Nullable
        private Rail getMinecartTrackLogic(@NotNull TilePos tilePos) {
            if (BlockLogicRail.isRailBlockAt(this.world, tilePos)) {
                return new Rail(this.world, tilePos);
            }
            TilePos up = (TilePos)tilePos.up();
            if (BlockLogicRail.isRailBlockAt(this.world, up)) {
                return new Rail(this.world, up);
            }
            TilePos down = (TilePos)tilePos.down();
            if (BlockLogicRail.isRailBlockAt(this.world, down)) {
                return new Rail(this.world, down);
            }
            return null;
        }

        private boolean isConnectedTo(@NotNull Rail rail) {
            for (TilePos position : this.connectedTracks) {
                if (position.x != rail.pos.x || position.z != rail.pos.z) continue;
                return true;
            }
            return false;
        }

        private boolean isInTrack(@NotNull TilePos tilePos) {
            for (TilePos track : this.connectedTracks) {
                if (track.x != tilePos.x || track.z != tilePos.z) continue;
                return true;
            }
            return false;
        }

        private int getAdjacentTracks() {
            int count = 0;
            if (this.isMinecartTrack((TilePos)this.pos.north())) {
                ++count;
            }
            if (this.isMinecartTrack((TilePos)this.pos.south())) {
                ++count;
            }
            if (this.isMinecartTrack((TilePos)this.pos.west())) {
                ++count;
            }
            if (this.isMinecartTrack((TilePos)this.pos.east())) {
                ++count;
            }
            return count;
        }

        private boolean handleKeyPress(@NotNull Rail rail) {
            if (this.isConnectedTo(rail)) {
                return true;
            }
            return this.connectedTracks.size() != 2;
        }

        private boolean canTrackTurnTo(@NotNull TilePos tilePos) {
            Rail rail = this.getMinecartTrackLogic(tilePos);
            if (rail == null) {
                return false;
            }
            rail.checkAndRemoveMissingRails();
            return rail.handleKeyPress(this);
        }

        public void railTurn(boolean isPowered, boolean forceUpdate) {
            boolean flagNorth = this.canTrackTurnTo((TilePos)this.pos.north());
            boolean flagSouth = this.canTrackTurnTo((TilePos)this.pos.south());
            boolean flagWest = this.canTrackTurnTo((TilePos)this.pos.west());
            boolean flagEast = this.canTrackTurnTo((TilePos)this.pos.east());
            RailDirection railType = RailDirection.NONE;
            if ((flagNorth || flagSouth) && !flagWest && !flagEast) {
                railType = RailDirection.STRAIGHT_NS;
            }
            if ((flagWest || flagEast) && !flagNorth && !flagSouth) {
                railType = RailDirection.STRAIGHT_EW;
            }
            if (!this.isPoweredRail) {
                if (flagSouth && flagEast && !flagNorth && !flagWest) {
                    railType = RailDirection.TURN_ES;
                }
                if (flagSouth && flagWest && !flagNorth && !flagEast) {
                    railType = RailDirection.TURN_WS;
                }
                if (flagNorth && flagWest && !flagSouth && !flagEast) {
                    railType = RailDirection.TURN_WN;
                }
                if (flagNorth && flagEast && !flagSouth && !flagWest) {
                    railType = RailDirection.TURN_EN;
                }
            }
            if (railType == RailDirection.NONE) {
                if (flagNorth || flagSouth) {
                    railType = RailDirection.STRAIGHT_NS;
                }
                if (flagWest || flagEast) {
                    railType = RailDirection.STRAIGHT_EW;
                }
                if (!this.isPoweredRail) {
                    if (isPowered) {
                        if (flagSouth && flagEast) {
                            railType = RailDirection.TURN_ES;
                        }
                        if (flagWest && flagSouth) {
                            railType = RailDirection.TURN_WS;
                        }
                        if (flagEast && flagNorth) {
                            railType = RailDirection.TURN_EN;
                        }
                        if (flagNorth && flagWest) {
                            railType = RailDirection.TURN_WN;
                        }
                    } else {
                        if (flagNorth && flagWest) {
                            railType = RailDirection.TURN_WN;
                        }
                        if (flagEast && flagNorth) {
                            railType = RailDirection.TURN_EN;
                        }
                        if (flagWest && flagSouth) {
                            railType = RailDirection.TURN_WS;
                        }
                        if (flagSouth && flagEast) {
                            railType = RailDirection.TURN_ES;
                        }
                    }
                }
            }
            if (railType == RailDirection.STRAIGHT_NS) {
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(0, 1, -1))) {
                    railType = RailDirection.SLOPE_N;
                }
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(0, 1, 1))) {
                    railType = RailDirection.SLOPE_S;
                }
            }
            if (railType == RailDirection.STRAIGHT_EW) {
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(1, 1, 0))) {
                    railType = RailDirection.SLOPE_E;
                }
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(-1, 1, 0))) {
                    railType = RailDirection.SLOPE_W;
                }
            }
            if (railType == RailDirection.NONE) {
                railType = RailDirection.STRAIGHT_EW;
            }
            this.setConnections(railType);
            int newMeta = railType.meta;
            if (this.isPoweredRail) {
                newMeta |= this.world.getBlockData(this.pos) & 8;
            }
            if (forceUpdate || this.world.getBlockData(this.pos) != newMeta) {
                this.world.setBlockDataNotify(this.pos, newMeta);
                for (TilePos connectedTrack : this.connectedTracks) {
                    Rail rail = this.getMinecartTrackLogic(connectedTrack);
                    if (rail == null) continue;
                    rail.checkAndRemoveMissingRails();
                    if (!rail.handleKeyPress(this)) continue;
                    rail.updateRailState(this);
                }
            }
        }

        private void updateRailState(@NotNull Rail otherLogic) {
            this.connectedTracks.add(otherLogic.pos);
            boolean flagNorth = this.isInTrack((TilePos)this.pos.north());
            boolean flagSouth = this.isInTrack((TilePos)this.pos.south());
            boolean flagWest = this.isInTrack((TilePos)this.pos.west());
            boolean flagEast = this.isInTrack((TilePos)this.pos.east());
            RailDirection railDirection = RailDirection.NONE;
            if (flagNorth || flagSouth) {
                railDirection = RailDirection.STRAIGHT_NS;
            }
            if (flagWest || flagEast) {
                railDirection = RailDirection.STRAIGHT_EW;
            }
            if (!this.isPoweredRail) {
                if (flagSouth && flagEast && !flagNorth && !flagWest) {
                    railDirection = RailDirection.TURN_ES;
                }
                if (flagSouth && flagWest && !flagNorth && !flagEast) {
                    railDirection = RailDirection.TURN_WS;
                }
                if (flagNorth && flagWest && !flagSouth && !flagEast) {
                    railDirection = RailDirection.TURN_WN;
                }
                if (flagNorth && flagEast && !flagSouth && !flagWest) {
                    railDirection = RailDirection.TURN_EN;
                }
            }
            if (railDirection == RailDirection.STRAIGHT_NS) {
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(0, 1, -1))) {
                    railDirection = RailDirection.SLOPE_N;
                }
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(0, 1, 1))) {
                    railDirection = RailDirection.SLOPE_S;
                }
            }
            if (railDirection == RailDirection.STRAIGHT_EW) {
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(1, 1, 0))) {
                    railDirection = RailDirection.SLOPE_E;
                }
                if (BlockLogicRail.isRailBlockAt(this.world, this.pos.add(-1, 1, 0))) {
                    railDirection = RailDirection.SLOPE_W;
                }
            }
            if (railDirection == RailDirection.NONE) {
                railDirection = RailDirection.STRAIGHT_NS;
            }
            int newMeta = railDirection.meta;
            if (this.isPoweredRail) {
                newMeta |= this.world.getBlockData(this.pos) & 8;
            }
            this.world.setBlockDataNotify(this.pos, newMeta);
        }
    }
}

