/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicSugarcane
extends BlockLogic
implements IBonemealable {
    public BlockLogicSugarcane(@NotNull Block<?> block) {
        super(block, Material.plant);
        float f = 0.375f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 1.0, 0.5f + f);
        block.setTicking(true);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        TilePos up = (TilePos)tilePos.up();
        if (world.isAirBlock(up)) {
            int reedHeight = 0;
            TilePos p = new TilePos(tilePos);
            while (world.getBlockId(p) == this.id()) {
                --p.y;
                if (++reedHeight < 3) continue;
                return;
            }
            int data = world.getBlockData(tilePos);
            if (data >= 15) {
                world.setBlockIdNotify(up, this.id());
                world.setBlockDataNotify(tilePos, 0);
            } else {
                world.setBlockDataNotify(tilePos, data + 1);
            }
        }
    }

    public void growReedOnTop(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos p = new TilePos(tilePos);
        while (world.getBlockId(p) == this.id()) {
            ++p.y;
        }
        if (world.isAirBlock(p)) {
            world.setBlockIdNotify(p, this.id());
        }
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        TilePos down = (TilePos)tilePos.down();
        Block<?> blockBelow = world.getBlock(down);
        if (blockBelow == null) {
            return false;
        }
        if (blockBelow.id() == this.id()) {
            return true;
        }
        if (!blockBelow.hasTag(BlockTags.GROWS_SUGAR_CANE)) {
            return false;
        }
        return Blocks.hasTag(world.getBlockId((TilePos)down.add(Direction.WEST)), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)down.add(Direction.EAST)), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)down.add(Direction.NORTH)), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)down.add(Direction.SOUTH)), BlockTags.IS_WATER);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        this.checkCanStay(world, tilePos);
    }

    protected final void checkCanStay(@NotNull World world, @NotNull TilePos tilePos) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.SUGARCANE)};
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        return this.canPlaceAt(world, tilePos);
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean onBonemealUsed(@NotNull ItemStack itemStack, @Nullable Player player, World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.growReedOnTop(world, tilePos);
            if (player == null || player.getGamemode().consumeBlocks()) {
                --itemStack.stackSize;
            }
        }
        return true;
    }
}

