/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class FluidLava
implements Fluid {
    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void animationTick(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        boolean isTop;
        TilePos up = (TilePos)tilePos.up();
        boolean bl = isTop = world.getBlockMaterial(up) == Material.air && !world.isBlockOpaqueCube(up);
        if (isTop && rand.nextInt(100) == 0) {
            double xOff = (double)tilePos.x + (double)rand.nextFloat();
            double yOff = (double)tilePos.y + logicFluid.getBounds().maxY;
            double zOff = (double)tilePos.z + (double)rand.nextFloat();
            world.spawnParticle("lava", xOff, yOff, zOff, 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public void checkForHarden(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Material encountered) {
        if (encountered == Material.water) {
            int data = world.getBlockData(tilePos) & 0xF;
            if (data == 0) {
                if (world.dimension == Dimension.NETHER) {
                    world.setBlockIdNotify(tilePos, Blocks.COBBLE_NETHERRACK_IGNEOUS.id());
                } else {
                    world.setBlockIdNotify(tilePos, Blocks.OBSIDIAN.id());
                }
            } else if (data <= 2) {
                world.setBlockIdNotify(tilePos, Blocks.COBBLE_GRANITE.id());
            } else if (data <= 4) {
                world.setBlockIdNotify(tilePos, Blocks.COBBLE_STONE.id());
            } else {
                world.setBlockIdNotify(tilePos, Blocks.COBBLE_BASALT.id());
            }
            BlockLogicFluid.fizz(world, tilePos);
        }
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public void updateTickStill(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        TilePos p = new TilePos(tilePos);
        int count = rand.nextInt(3);
        for (int i = 0; i < count; ++i) {
            p.x += rand.nextInt(3) - 1;
            ++p.y;
            p.z += rand.nextInt(3) - 1;
            int id = world.getBlockId(p);
            if (id == 0) {
                if (!FluidLava.isFlammable(world, (TilePos)p.west()) && !FluidLava.isFlammable(world, (TilePos)p.east()) && !FluidLava.isFlammable(world, (TilePos)p.north()) && !FluidLava.isFlammable(world, (TilePos)p.south()) && !FluidLava.isFlammable(world, (TilePos)p.down()) && !FluidLava.isFlammable(world, (TilePos)p.up())) continue;
                world.setBlockIdNotify(p, Blocks.FIRE.id());
                return;
            }
            if (!Blocks.blocksList[id].getMaterial().blocksMotion()) continue;
            return;
        }
    }

    private static boolean isFlammable(World world, @NotNull TilePos tilePos) {
        return BlockLogicFire.canBurn(world, tilePos);
    }

    @Override
    public byte getFlowDecayMod(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos) {
        if (world.dimension == Dimension.NETHER) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean canBecomeSource(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        return false;
    }

    @Override
    public void onFlowIntoBlock(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, int meta) {
        BlockLogicFluid.fizz(world, tilePos);
    }

    @Override
    public boolean canSpreadTo(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Material material) {
        return material != Material.lava;
    }
}

