/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBucketEmpty
extends Item {
    public ItemBucketEmpty(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        double reachDistance = player.getGamemode().getBlockReachDistance();
        HitResult hitResult = player.rayCast(reachDistance, 1.0f, true, false, false);
        if (hitResult == null) {
            return selfStack;
        }
        if (hitResult instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)hitResult;
            if (!world.canMineBlock(player, hitTile.tilePos)) {
                return selfStack;
            }
            if (world.getBlockMaterial(hitTile.tilePos) == Material.water && world.getBlockData(hitTile.tilePos) == 0) {
                if (ItemBucketEmpty.useBucket(player, new ItemStack(Items.BUCKET_WATER))) {
                    world.setBlockIdNotify(hitTile.tilePos, 0);
                    player.swingItem();
                }
            } else if (world.getBlockMaterial(hitTile.tilePos) == Material.lava && world.getBlockData(hitTile.tilePos) == 0 && ItemBucketEmpty.useBucket(player, new ItemStack(Items.BUCKET_LAVA))) {
                world.setBlockIdNotify(hitTile.tilePos, 0);
                player.swingItem();
            }
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        if (selfStack.stackSize > 1) {
            return;
        }
        TilePos shiftedPos = (TilePos)blockPos.add(direction);
        if (world.getBlockMaterial(shiftedPos) == Material.water && world.getBlockData(shiftedPos) == 0) {
            world.setBlockIdNotify(shiftedPos, 0);
            selfStack.itemID = Items.BUCKET_WATER.id;
            return;
        }
        if (world.getBlockMaterial(shiftedPos) == Material.lava && world.getBlockData(shiftedPos) == 0) {
            world.setBlockIdNotify(shiftedPos, 0);
            selfStack.itemID = Items.BUCKET_LAVA.id;
            return;
        }
        AABB box = AABB.fromPool(shiftedPos.x, shiftedPos.y, shiftedPos.z, shiftedPos.x + 1, shiftedPos.y + 1, shiftedPos.z + 1);
        List<MobCow> entities = world.getEntitiesWithinAABB(MobCow.class, box);
        if (!entities.isEmpty()) {
            selfStack.itemID = Items.BUCKET_MILK.id;
        }
    }

    public static boolean useBucket(@NotNull Player player, @NotNull ItemStack itemToGive) {
        ItemStack currentItem = player.inventory.getCurrentItem();
        if (currentItem == null || currentItem.stackSize <= 1) {
            player.inventory.setItem(player.inventory.getCurrentItemIndex(), itemToGive);
            return true;
        }
        player.inventory.insertItem(itemToGive, true);
        if (itemToGive.stackSize < 1) {
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

