/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRail;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMinecart
extends Item {
    public final int minecartType;

    public ItemMinecart(@NotNull String name, @NotNull String namespaceId, int id, int type) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
        this.minecartType = type;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePos blockPos, @NotNull Side side, double xHit, double yHit) {
        Block<?> block = world.getBlock(blockPos);
        if (!Block.hasLogicClass(block, BlockLogicRail.class)) {
            return false;
        }
        if (!world.isClientSide) {
            world.entityJoinedWorld(new EntityMinecart(world, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.minecartType));
        }
        if (player == null || player.getGamemode().consumeBlocks()) {
            --selfStack.stackSize;
        }
        return true;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        this.onUseOnBlock(selfStack, world, null, (TilePos)blockPos.add(direction), direction.getSide(), 0.5, 0.5);
    }
}

