/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRope
extends ItemPlaceable {
    public ItemRope(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> blockToPlace) {
        super(name, namespaceId, id, blockToPlace);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePos blockPos, @NotNull Side side, double xHit, double yHit) {
        if (selfStack.stackSize <= 0) {
            return false;
        }
        boolean placeOnSide = true;
        if (world.getBlock(blockPos) == this.blockToPlace && player != null && !player.isSneaking()) {
            placeOnSide = false;
            TilePos tempPos = new TilePos(blockPos);
            int _y = blockPos.y;
            while (_y > 0) {
                if (world.canBlockIdBePlacedAt(this.blockToPlace.id(), tempPos.set(blockPos.x, --_y, blockPos.z), false, side)) {
                    blockPos.y = _y;
                    break;
                }
                if (world.getBlock((TilePos)tempPos.sub(blockPos.x, _y, blockPos.z)) == this.blockToPlace) continue;
                if (side == Side.TOP) break;
                return true;
            }
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = (TilePos)blockPos.add(side.getDirection());
        }
        if (blockPos.y < 0 || blockPos.y >= world.getHeightBlocks()) {
            return false;
        }
        if (world.canBlockIdBePlacedAt(this.blockToPlace.id(), blockPos, false, side) && selfStack.consumeItem(player) && world.setBlockIdDataNotify(blockPos, this.blockToPlace.id(), placeOnSide ? 128 : 0)) {
            if (player == null) {
                this.blockToPlace.onPlacedOnSide(world, blockPos, side, xHit, yHit);
            } else {
                this.blockToPlace.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
            }
            world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.blockToPlace, EnumBlockSoundEffectType.PLACE);
            return true;
        }
        return false;
    }
}

