/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.core.Global;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.slf4j.Logger;

public class OpenGLHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> errors = new HashSet<String>();
    public static boolean enableOcclusionCheck = false;
    public static boolean enableSphericalFog = false;
    public static boolean gl20 = false;
    public static boolean gl31 = false;
    public static boolean gl32 = false;
    public static boolean gl43 = false;

    public static void testCapabilities(Minecraft minecraft) {
        LOGGER.info("");
        LOGGER.info("=== GPU VENDOR INFO ===");
        LOGGER.info(GL11.glGetString(7938));
        LOGGER.info(GL11.glGetString(7936));
        LOGGER.info(GL11.glGetString(7937));
        LOGGER.info("");
        ContextCapabilities capabilities = GLContext.getCapabilities();
        LOGGER.info("GL_ARB_framebuffer_object: {}", (Object)capabilities.GL_ARB_framebuffer_object);
        LOGGER.info("GL_ARB_occlusion_query: {}", (Object)capabilities.GL_ARB_occlusion_query);
        LOGGER.info("GL_NV_fog_distance: {}", (Object)capabilities.GL_NV_fog_distance);
        enableOcclusionCheck = capabilities.GL_ARB_occlusion_query;
        enableSphericalFog = capabilities.GL_NV_fog_distance;
        gl20 = capabilities.OpenGL20;
        gl31 = capabilities.OpenGL31;
        gl32 = capabilities.OpenGL32;
        gl43 = capabilities.OpenGL43;
        LOGGER.info("");
        if (((Boolean)minecraft.gameSettings.disableShaders.value).booleanValue()) {
            Shaders.enableShaders = false;
            LOGGER.warn("Shaders disabled in options file!");
            return;
        }
        Shaders.enableShaders = capabilities.GL_ARB_framebuffer_object && capabilities.OpenGL20;
        LOGGER.info("Shaders enabled: {}", (Object)Shaders.enableShaders);
        LOGGER.info("");
    }

    public static void checkError(String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                throw new RuntimeException("OpenGL Error " + error);
            }
            if (!errors.contains(info)) {
                errors.add(info);
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                LOGGER.error("########## GL ERROR ##########");
                LOGGER.error("OpenGL Error {}", (Object)error);
            }
        }
    }

    public static String getErrorDescription(int error) {
        if (error == 1280) {
            return "Invalid Enum";
        }
        if (error == 1281) {
            return "Invalid Value";
        }
        if (error == 1282) {
            return "Invalid Operation";
        }
        if (error == 1286) {
            return "Invalid Framebuffer Operation";
        }
        if (error == 1285) {
            return "Out of Memory";
        }
        if (error == 1284) {
            return "Stack Underflow";
        }
        if (error == 1283) {
            return "Stack Overflow";
        }
        return "Unknown Error";
    }

    public static void glColor1i(int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        GL11.glColor4f(r, g, b, a);
    }
}

