/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.Global;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ParticleFluidDrip
extends Particle {
    float maxSize;
    boolean fullBright;

    public ParticleFluidDrip(World world, double x, double y, double z, int color, IconCoordinate texture) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.tex = texture;
        this.gravity = 0.125f;
        this.size /= 4.0f;
        this.maxSize = this.size;
        this.size = 0.0f;
        this.lifetime *= 16;
        this.yd = 0.0;
        this.xd = 0.0;
        this.zd = 0.0;
        this.rCol = (float)Color.redFromInt(color) / 255.0f;
        this.gCol = (float)Color.greenFromInt(color) / 255.0f;
        this.bCol = (float)Color.blueFromInt(color) / 255.0f;
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }

    @Override
    public void tick() {
        if (LightmapHelper.isLightmapEnabled()) {
            this.cachedLightmapCoord = this.calcLightmap(1.0f);
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        if (this.age < this.lifetime / 4) {
            float particleProgress = (float)this.age / ((float)this.lifetime / 4.0f);
            this.size = this.maxSize * particleProgress;
            this.gravity = 0.0f;
        } else {
            this.gravity = 0.5f;
            this.yd -= 0.04 * (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.onGround) {
                this.xd *= 0.7;
                this.zd *= 0.7;
            }
        }
    }

    @Override
    public void render(@NotNull ParticleTessellator t, float partialTick) {
        if (this.tex == null) {
            return;
        }
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmap(partialTick));
        } else if (!Global.accessor.isFullbrightEnabled()) {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addParticle(MathHelper.lerp(this.xo, this.x, (double)partialTick), MathHelper.lerp(this.yo, this.y, (double)partialTick), MathHelper.lerp(this.zo, this.z, (double)partialTick), this.size * 0.1f, this.tex.getIconUMin() + this.tex.getIconUSize() * (double)this.uo / 4.0, this.tex.getIconVMin() + this.tex.getIconVSize() * (double)this.uo / 4.0, this.tex.getIconUSize() * 0.25, this.tex.getIconVSize() * 0.25);
    }

    public ParticleFluidDrip setFullBright() {
        this.fullBright = true;
        return this;
    }

    @Override
    public float calcBrightness(float partialTick) {
        if (this.fullBright) {
            return 1.0f;
        }
        return super.calcBrightness(partialTick);
    }

    @Override
    public int calcLightmap(float partialTick) {
        if (this.fullBright) {
            return LightmapHelper.getOverbrightLightmapCoord(this.world.getSavedLightValue(LightLayer.Sky, new TilePos(this.x, this.y, this.z)));
        }
        return super.calcLightmap(partialTick);
    }
}

