/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.nbt.tags.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NextTickListEntry
implements Comparable<NextTickListEntry> {
    private static long counter = 0L;
    public int x;
    public int y;
    public int z;
    public int blockId;
    public long creationTime;
    public long delay;
    public boolean loaded;
    private final long entryId = counter++;

    @NotNull
    public static CompoundTag serialize(@NotNull NextTickListEntry entry) {
        @NotNull CompoundTag tag = new CompoundTag();
        tag.putInt("pos", NextTickListEntry.compressChunkCoord((short)entry.x, (short)entry.y, (short)entry.z));
        tag.putShort("blockId", (short)entry.blockId);
        tag.putLong("creationTime", entry.creationTime);
        if (entry.delay != 0L) {
            tag.putLong("delay", entry.delay);
        }
        return tag;
    }

    @Nullable
    public static NextTickListEntry deserialize(@NotNull CompoundTag tag) {
        if (!tag.containsKey("pos")) {
            return null;
        }
        int pos = tag.getInteger("pos");
        short @NotNull [] xyz = new short[3];
        NextTickListEntry.decompressChunkCoord(pos, xyz);
        if (!tag.containsKey("blockId")) {
            return null;
        }
        short blockId = tag.getShort("blockId");
        if (!tag.containsKey("creationTime")) {
            return null;
        }
        long creationTime = tag.getLong("creationTime");
        @NotNull NextTickListEntry entry = new NextTickListEntry(xyz[0], xyz[1], xyz[2], blockId, creationTime);
        if (tag.containsKey("delay")) {
            entry.setDelay(tag.getLong("delay"));
        }
        return entry;
    }

    public static int compressChunkCoord(short x, short y, short z) {
        return (y & 0xFFFF) << 16 | (z & 0xFF) << 8 | (x & 0xFF) << 0;
    }

    public static void decompressChunkCoord(int compressed, short @NotNull [] xyz) {
        int y = (compressed & 0xFFFF0000) >> 16;
        int z = (compressed & 0xFF00) >> 8;
        int x = (compressed & 0xFF) >> 0;
        xyz[0] = (short)x;
        xyz[1] = (short)y;
        xyz[2] = (short)z;
    }

    public NextTickListEntry(int x, int y, int z, int blockId, long creationTime) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockId = blockId;
        this.creationTime = creationTime;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NextTickListEntry) {
            @NotNull NextTickListEntry entry = (NextTickListEntry)obj;
            return this.x == entry.x && this.y == entry.y && this.z == entry.z && this.blockId == entry.blockId;
        }
        return false;
    }

    public int hashCode() {
        return (this.x * 128 * 1024 + this.z * 128 + this.y) * 256 + this.blockId;
    }

    @NotNull
    public NextTickListEntry setDelay(long delay) {
        this.delay = delay;
        return this;
    }

    public long getEndTime() {
        return this.creationTime + this.delay;
    }

    @Override
    public int compareTo(@NotNull NextTickListEntry other) {
        if (this.getEndTime() < other.getEndTime()) {
            return -1;
        }
        if (this.getEndTime() > other.getEndTime()) {
            return 1;
        }
        if (this.entryId < other.entryId) {
            return -1;
        }
        return this.entryId <= other.entryId ? 0 : 1;
    }

    @NotNull
    public NextTickListEntry clone() {
        @NotNull NextTickListEntry cloned = new NextTickListEntry(this.x, this.y, this.z, this.blockId, this.creationTime);
        cloned.delay = this.delay;
        return cloned;
    }
}

