/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFireStriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicBrazier
extends BlockLogic {
    private final boolean burning;

    public BlockLogicBrazier(@NotNull Block<?> block, boolean burning) {
        super(block, Material.metal);
        this.burning = burning;
    }

    public boolean isBurning() {
        return this.burning;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        if (side == Side.BOTTOM) {
            return FullSupport.INSTANCE;
        }
        return PartialSupport.INSTANCE;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.BRAZIER_INACTIVE, 1)};
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        @Nullable ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemFireStriker && !this.burning) {
            Block<?> b = world.getBlock((TilePos)tilePos.east());
            if (b != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock((TilePos)tilePos.west())) != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock((TilePos)tilePos.south())) != null && b.getLogic() instanceof BlockLogicFluid || (b = world.getBlock((TilePos)tilePos.north())) != null && b.getLogic() instanceof BlockLogicFluid) {
                return false;
            }
            world.setBlockIdDataNotify(tilePos, Blocks.BRAZIER_ACTIVE.id(), 0);
            heldItem.damageItem(1, player);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        if (heldItem == null && this.burning) {
            world.setBlockIdDataNotify(tilePos, Blocks.BRAZIER_INACTIVE.id(), 0);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePos tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        if (this.burning) {
            world.setBlockIdDataNotify(tilePos, Blocks.BRAZIER_INACTIVE.id(), 0);
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if (this.burning) {
            Blocks.FIRE.onRemoved(world, tilePos, data);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.burning) {
            return;
        }
        Block<?> block = Blocks.blocksList[id];
        if (block != null && block.getLogic() instanceof BlockLogicFluid) {
            world.setBlockIdDataNotify(tilePos, Blocks.BRAZIER_INACTIVE.id(), 0);
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        if (this.burning) {
            Blocks.FIRE.animationTick(world, tilePos, rand);
        }
    }
}

