/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicOverlayPebbles
extends BlockLogic {
    public BlockLogicOverlayPebbles(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    public static boolean canSpawnOn(@Nullable Block<?> block) {
        return block == Blocks.GRASS || block == Blocks.SAND || block == Blocks.DIRT || block == Blocks.SANDSTONE || block == Blocks.DIRT_SCORCHED || block == Blocks.DIRT_SCORCHED_RICH || block == Blocks.GRASS_SCORCHED;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        Block<?> block = world.getBlock((TilePos)tilePos.down());
        return block != null && block.getMaterial().isSolid();
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePos tilePos) {
        return this.canPlaceAt(world, tilePos);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.canStay(world, tilePos)) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.PICK_BLOCK) {
            return new ItemStack[]{new ItemStack(Items.AMMO_PEBBLE, 1)};
        }
        return new ItemStack[]{new ItemStack(Items.AMMO_PEBBLE, data + 1)};
    }
}

