/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicPressurePlate<T extends Entity>
extends BlockLogic
implements IPaintable,
ISupportable {
    public static final int MASK_POWERED = 1;
    public static final int MASK_SIDE = 14;
    @NotNull
    private final Class<T> triggerMobClass;

    public BlockLogicPressurePlate(@NotNull Block<?> block, @NotNull Class<T> mobType, @NotNull Material material) {
        super(block, material);
        this.triggerMobClass = mobType;
        block.setTicking(true);
        float pixel = 0.0625f;
        this.setBlockBounds(pixel, 0.0, pixel, 1.0f - pixel, pixel / 2.0f, 1.0f - pixel);
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    @Nullable
    public AABB getCollisionAABB(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePos tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM) || this.isSupported(world, tilePos, Side.TOP) || this.isSupported(world, tilePos, Side.NORTH) || this.isSupported(world, tilePos, Side.SOUTH) || this.isSupported(world, tilePos, Side.WEST) || this.isSupported(world, tilePos, Side.EAST);
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        if (!this.isSupported(world, tilePos, BlockLogicPressurePlate.sideFromMeta(world.getBlockData(tilePos)))) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @NotNull
    private Side getDefaultSide(@NotNull World world, @NotNull TilePos tilePos) {
        for (int i = 0; i < Side.sides.length; ++i) {
            Side side = Side.sides[i];
            if (!this.isSupported(world, tilePos, side)) continue;
            return side;
        }
        return Side.NONE;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        if (BlockLogicPressurePlate.isPressed(world.getBlockData(tilePos))) {
            this.updateState(world, tilePos);
        }
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePos tilePos, @NotNull Entity entity) {
        if (world.isClientSide) {
            return;
        }
        if (!BlockLogicPressurePlate.isPressed(world.getBlockData(tilePos))) {
            this.updateState(world, tilePos);
        }
    }

    private void updateState(@NotNull World world, @NotNull TilePos tilePos) {
        int meta = world.getBlockData(tilePos);
        boolean isPressed = BlockLogicPressurePlate.isPressed(meta);
        Direction dir = BlockLogicPressurePlate.sideFromMeta(meta).getDirection();
        boolean isSteppedOn = false;
        float pixel = 0.125f;
        List<T> list = switch (BlockLogicPressurePlate.sideFromMeta(meta)) {
            case Side.BOTTOM -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(pixel, 0.0, pixel, 1.0f - pixel, isPressed ? pixel / 2.0f : pixel, 1.0f - pixel).move(tilePos));
            case Side.TOP -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(pixel, 1.0f - (isPressed ? pixel / 2.0f : pixel), pixel, 1.0f - pixel, 1.0, 1.0f - pixel).move(tilePos));
            case Side.NORTH -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(pixel, pixel, 0.0, 1.0f - pixel, 1.0f - pixel, isPressed ? pixel / 2.0f : pixel).move(tilePos));
            case Side.SOUTH -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(pixel, pixel, 1.0f - (isPressed ? pixel / 2.0f : pixel), 1.0f - pixel, 1.0f - pixel, 1.0).move(tilePos));
            case Side.WEST -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(0.0, pixel, pixel, isPressed ? pixel / 2.0f : pixel, 1.0f - pixel, 1.0f - pixel).move(tilePos));
            default -> world.getEntitiesWithinAABB(this.triggerMobClass, AABB.fromPool(1.0f - (isPressed ? pixel / 2.0f : pixel), pixel, pixel, 1.0, 1.0f - pixel, 1.0f - pixel).move(tilePos));
        };
        for (Entity t : list) {
            if (!t.canInteract()) continue;
            isSteppedOn = true;
            break;
        }
        if (isSteppedOn && !isPressed) {
            world.setBlockDataNotify(tilePos, meta | 1);
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.add(dir), this.id());
            world.markBlocksDirty(tilePos, tilePos);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.1, (double)tilePos.z + 0.5, "random.click", 0.3f, 0.6f);
        } else if (!isSteppedOn && isPressed) {
            world.setBlockDataNotify(tilePos, meta & 0xFFFFFFFE);
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.add(dir), this.id());
            world.markBlocksDirty(tilePos, tilePos);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.1, (double)tilePos.z + 0.5, "random.click", 0.3f, 0.5f);
        }
        if (isSteppedOn) {
            world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if (BlockLogicPressurePlate.isPressed(data)) {
            Side side = BlockLogicPressurePlate.sideFromMeta(world.getBlockData(tilePos));
            world.notifyBlocksOfNeighborChange(tilePos, this.id());
            world.notifyBlocksOfNeighborChange((TilePos)tilePos.add(side.getDirection()), this.id());
        }
        super.onRemoved(world, tilePos, data);
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int meta = source.getBlockData(tilePos);
        boolean isPressed = BlockLogicPressurePlate.isPressed(meta);
        float pixel = 0.0625f;
        return switch (BlockLogicPressurePlate.sideFromMeta(meta)) {
            case Side.BOTTOM -> AABB.fromPool(0.0625, 0.0, 0.0625, 0.9375, isPressed ? 0.03125f : 0.0625f, 0.9375);
            case Side.TOP -> AABB.fromPool(0.0625, 1.0f - (isPressed ? 0.03125f : 0.0625f), 0.0625, 0.9375, 1.0, 0.9375);
            case Side.NORTH -> AABB.fromPool(0.0625, 0.0625, 0.0, 0.9375, 0.9375, isPressed ? 0.03125f : 0.0625f);
            case Side.SOUTH -> AABB.fromPool(0.0625, 0.0625, 1.0f - (isPressed ? 0.03125f : 0.0625f), 0.9375, 0.9375, 1.0);
            case Side.WEST -> AABB.fromPool(0.0, 0.0625, 0.0625, isPressed ? 0.03125f : 0.0625f, 0.9375, 0.9375);
            default -> AABB.fromPool(1.0f - (isPressed ? 0.03125f : 0.0625f), 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
        };
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePos tilePos, @NotNull Side side) {
        return BlockLogicPressurePlate.isPressed(source.getBlockData(tilePos));
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        if (BlockLogicPressurePlate.isPressed(meta)) {
            return side == BlockLogicPressurePlate.sideFromMeta(meta).getOpposite();
        }
        return false;
    }

    public static boolean isPressed(int meta) {
        return (meta & 1) != 0;
    }

    public static int setSide(int meta, @NotNull Side side) {
        return meta & 0xFFFFFFF1 | side.getId() << 1;
    }

    @NotNull
    public static Side sideFromMeta(int meta) {
        return Side.getSideById((meta & 0xE) >> 1);
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePos tilePos) {
        return 1;
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = world.getBlockData(tilePos);
        if (!this.isSupported(world, tilePos, side = side.getOpposite())) {
            side = this.getDefaultSide(world, tilePos);
        }
        if (side != Side.NONE) {
            world.setBlockData(tilePos, BlockLogicPressurePlate.setSide(meta, side));
        } else {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, meta, null, null);
            world.setBlockIdNotify(tilePos, 0);
        }
    }

    @Override
    public boolean canBePainted() {
        return this.id() == Blocks.PRESSURE_PLATE_PLANKS_OAK.id();
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePos tilePos, @NotNull DyeColor color) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataRaw(tilePos, Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED.id(), meta);
        world.setBlockData(tilePos, meta);
        Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED.getLogic().setColor(world, tilePos, color);
        if (BlockLogicPressurePlate.isPressed(meta)) {
            world.scheduleBlockUpdate(tilePos, Blocks.PRESSURE_PLATE_PLANKS_OAK_PAINTED.id(), this.tickDelay());
        }
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE.center();
    }
}

