/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPumice
extends BlockLogic {
    final boolean isWet;

    public BlockLogicPumice(@NotNull Block<?> block, boolean isWet) {
        super(block, Material.stone);
        this.isWet = isWet;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        super.onPlacedByWorld(world, tilePos);
        int radius = 2;
        if (this.isWet && (this.inWater(world, tilePos) || world.dimension.id == Dimension.DRIFT.id)) {
            world.setBlockIdNotify(tilePos, Blocks.PUMICE_DRY.id());
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.spawnParticle("largesmoke", (double)tilePos.x + Math.random(), (double)tilePos.y + Math.random(), (double)tilePos.z + Math.random(), 0.0, 0.0, 0.0, 0);
            }
        }
        if (!this.isWet && this.inLava(world, tilePos)) {
            TilePos p = new TilePos(tilePos);
            for (int x = tilePos.x - radius; x <= tilePos.x + radius; ++x) {
                for (int y = tilePos.y - radius; y <= tilePos.y + radius; ++y) {
                    for (int z = tilePos.z - radius; z <= tilePos.z + radius; ++z) {
                        p.x = x;
                        p.y = y;
                        p.z = z;
                        if (!Blocks.hasTag(world.getBlockId(p), BlockTags.IS_LAVA)) continue;
                        world.setBlockIdNotify(p, 0);
                    }
                }
            }
            world.setBlockIdNotify(tilePos, Blocks.PUMICE_WET.id());
        }
    }

    public boolean inLava(@NotNull World world, @NotNull TilePos tilePos) {
        return Blocks.hasTag(world.getBlockId((TilePos)tilePos.east()), BlockTags.IS_LAVA) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.west()), BlockTags.IS_LAVA) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.up()), BlockTags.IS_LAVA) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.down()), BlockTags.IS_LAVA) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.south()), BlockTags.IS_LAVA) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.north()), BlockTags.IS_LAVA);
    }

    public boolean inWater(@NotNull World world, @NotNull TilePos tilePos) {
        return Blocks.hasTag(world.getBlockId((TilePos)tilePos.east()), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.west()), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.up()), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.down()), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.south()), BlockTags.IS_WATER) || Blocks.hasTag(world.getBlockId((TilePos)tilePos.north()), BlockTags.IS_WATER);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePos tilePos, int data) {
        if (!this.isWet) {
            int radius = 2;
            TilePos p = new TilePos(tilePos);
            for (int x = tilePos.x - radius; x <= tilePos.x + radius; ++x) {
                for (int y = tilePos.y - radius; y <= tilePos.y + radius; ++y) {
                    int z = tilePos.z - radius;
                    while (z <= tilePos.z + radius) {
                        p.x = x;
                        p.y = y;
                        p.z = z++;
                        world.notifyBlocksOfNeighborChange(p, world.getBlockId(p));
                    }
                }
            }
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand) {
        if (this.isWet) {
            Direction direction = Direction.directions[rand.nextInt(6)];
            if (direction == Direction.UP || world.isBlockOpaqueCube((TilePos)tilePos.add(direction))) {
                return;
            }
            float off1 = rand.nextFloat() * 0.9f + 0.05f;
            float off2 = rand.nextFloat() * 0.9f + 0.05f;
            switch (direction) {
                case DOWN: {
                    world.spawnParticle("dripLava", (float)tilePos.x + off1, tilePos.y, (float)tilePos.z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case NORTH: {
                    world.spawnParticle("dripLava", (float)tilePos.x + off1, (float)tilePos.y + off2, tilePos.z, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case SOUTH: {
                    world.spawnParticle("dripLava", (float)tilePos.x + off1, (float)tilePos.y + off2, tilePos.z + 1, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case WEST: {
                    world.spawnParticle("dripLava", tilePos.x, (float)tilePos.y + off1, (float)tilePos.z + off2, 0.0, 0.0, 0.0, 0);
                    break;
                }
                case EAST: {
                    world.spawnParticle("dripLava", tilePos.x + 1, (float)tilePos.y + off1, (float)tilePos.z + off2, 0.0, 0.0, 0.0, 0);
                }
            }
        }
    }
}

