/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicSand
extends BlockLogic {
    public static boolean fallInstantly = false;

    public BlockLogicSand(@NotNull Block<?> block) {
        super(block, Material.sand);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePos tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePos tilePos, int id) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay());
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.tryToFall(world, tilePos);
    }

    private void tryToFall(@NotNull World world, @NotNull TilePos tilePos) {
        if (BlockLogicSand.canFallBelow(world, (TilePos)tilePos.down()) && tilePos.y >= 0) {
            int radius = 32;
            if (fallInstantly || !world.areBlocksLoaded(tilePos.add(-radius, -radius, -radius), tilePos.add(radius, radius, radius))) {
                world.setBlockIdNotify(tilePos, 0);
                TilePos p = new TilePos(tilePos.x, tilePos.y - 1, tilePos.z);
                while (BlockLogicSand.canFallBelow(world, p) && p.y > 0) {
                    --p.y;
                }
                if (p.y > 0) {
                    world.setBlockIdNotify(p, this.block.id());
                }
            } else {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)tilePos.x + 0.5, (double)tilePos.y + 0.5, (double)tilePos.z + 0.5, this.block.id(), 0, null);
                world.entityJoinedWorld(entityFallingBlock);
            }
        }
    }

    @Override
    public int tickDelay() {
        return 3;
    }

    public static boolean canFallBelow(@NotNull World world, @NotNull TilePos tilePos) {
        Block<?> block = world.getBlock(tilePos);
        return block == null || block.hasTag(BlockTags.PLACE_OVERWRITES);
    }
}

