/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSaplingBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaBushy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaTall;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicSaplingPine
extends BlockLogicSaplingBase {
    public BlockLogicSaplingPine(@NotNull Block<?> block) {
        super(block);
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (world.isClientSide) {
            return;
        }
        super.updateTick(world, tilePos, rand, isRandomTick);
        int growthRate = 30;
        if (world.getBlockLightValue((TilePos)tilePos.up()) >= 9 && rand.nextInt(growthRate) == 0) {
            int l = world.getBlockData(tilePos);
            if ((l & 8) == 0) {
                world.setBlockDataNotify(tilePos, l | 8);
            } else {
                this.growTree(world, tilePos, rand);
            }
        }
    }

    @Override
    public void growTree(@NotNull World world, @NotNull TilePos tilePos, @NotNull Random random) {
        WorldFeatureTreeTaigaTall treeBig = new WorldFeatureTreeTaigaTall(Blocks.LEAVES_PINE.id(), Blocks.LOG_PINE.id());
        WorldFeatureTreeTaigaBushy treeSmall = new WorldFeatureTreeTaigaBushy(Blocks.LEAVES_PINE.id(), Blocks.LOG_PINE.id());
        world.setBlockId(tilePos, 0);
        if (!((WorldFeature)treeSmall).place(world, random, tilePos.x, tilePos.y, tilePos.z) && !((WorldFeature)treeBig).place(world, random, tilePos.x, tilePos.y, tilePos.z)) {
            world.setBlockId(tilePos, this.id());
        }
    }
}

