/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import java.util.ArrayList;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.piston.BlockLogicPistonBase;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.BlockLogicPistonMoving;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class BlockLogicPistonBaseSteel
extends BlockLogicPistonBase {
    public static final double HEAD_THICKNESS_STEEL = 0.375;
    private Entity flungBlock = null;

    public BlockLogicPistonBaseSteel(@NotNull Block<?> container, int maxPushedBlocks) {
        super(container, maxPushedBlocks);
    }

    @Override
    @NotNull
    public AABB getBoundsFromState(@NotNull WorldSource source, @NotNull TilePos tilePos) {
        int data = source.getBlockData(tilePos);
        if (BlockLogicPistonBaseSteel.isPowered(data)) {
            return switch (BlockLogicPistonBaseSteel.getDirection(data)) {
                case Direction.DOWN -> AABB.fromPool(0.0, 0.375, 0.0, 1.0, 1.0, 1.0);
                case Direction.UP -> AABB.fromPool(0.0, 0.0, 0.0, 1.0, 0.625, 1.0);
                case Direction.NORTH -> AABB.fromPool(0.0, 0.0, 0.375, 1.0, 1.0, 1.0);
                case Direction.SOUTH -> AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 0.625);
                case Direction.WEST -> AABB.fromPool(0.375, 0.0, 0.0, 1.0, 1.0, 1.0);
                default -> AABB.fromPool(0.0, 0.0, 0.0, 0.625, 1.0, 1.0);
            };
        }
        return AABB.fromPool(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    protected boolean canPushLine(@NotNull World world, @NotNull TilePos tilePos, @NotNull Direction direction, int maxPushedBlocks) {
        int blocks;
        TilePos posO = (TilePos)tilePos.add(direction);
        boolean didCrush = false;
        for (blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
            if (posO.y < 0 || posO.y >= world.getHeightBlocks()) {
                return false;
            }
            int id = world.getBlockId(posO);
            if (id == 0) break;
            if (!this.isPushable(id, world, posO, true)) {
                if (blocks == 1 && BlockTags.PISTON_CRUSHING.appliesTo(Blocks.getBlock(id)) && this.tryCrush(world, tilePos, direction)) {
                    didCrush = true;
                    break;
                }
                return false;
            }
            if (Blocks.blocksList[id].getPistonPushReaction(world, posO) == 1) break;
            if (blocks == maxPushedBlocks) {
                return false;
            }
            posO.x += direction.getOffsetX();
            posO.y += direction.getOffsetY();
            posO.z += direction.getOffsetZ();
        }
        if (!didCrush && blocks == 1) {
            posO.set(tilePos.x + direction.getOffsetX(), tilePos.y + direction.getOffsetY(), tilePos.z + direction.getOffsetZ());
            Block<?> block = world.getBlock(posO);
            if (block == null) {
                return true;
            }
            int blockMeta = world.getBlockData(posO);
            TileEntity tileEntity = world.getTileEntity(posO);
            world.removeTileEntity(posO);
            world.setBlockIdNotify(posO, 0);
            if (!world.isClientSide) {
                EntityFallingBlock entityFallingBlock = new EntityFallingBlock(world, (double)posO.x + 0.5, (double)posO.y + 0.5, (double)posO.z + 0.5, block.id(), blockMeta, tileEntity);
                entityFallingBlock.hasRemovedBlock = true;
                if (tileEntity instanceof IVehicle) {
                    Entity rider = ((IVehicle)((Object)tileEntity)).getPassenger();
                    ((IVehicle)((Object)tileEntity)).ejectRider();
                    if (rider != null) {
                        rider.startRiding(entityFallingBlock);
                    }
                }
                world.entityJoinedWorld(entityFallingBlock);
                double speed = 2.0;
                entityFallingBlock.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
                this.flungBlock = entityFallingBlock;
            }
        }
        return true;
    }

    @Override
    public boolean tryCrush(@NotNull World world, @NotNull TilePos tilePos, @NotNull Direction direction) {
        TilePos pos2 = (TilePos)tilePos.add(direction);
        Block<?> block = world.getBlock(pos2);
        if (block == null) {
            return true;
        }
        world.playBlockEvent(null, pos2, 2001, world.getBlockId(pos2));
        block.dropWithCause(world, EnumDropCause.PISTON_CRUSH, pos2, world.getBlockData(pos2), null, null);
        world.setBlockIdNotify(pos2, 0);
        return true;
    }

    @Override
    protected boolean tryExtend(@NotNull World world, @NotNull TilePos tilePos, @NotNull Direction direction, int maxPushedBlocks) {
        if (world.isClientSide) {
            int blocks;
            int data = world.getBlockData(tilePos);
            TilePos posO = (TilePos)tilePos.add(direction);
            for (blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
                if (posO.y < 0 || posO.y >= world.getHeightBlocks()) {
                    return false;
                }
                int blockId = world.getBlockId(posO);
                if (blockId == 0) break;
                if (!this.isPushable(blockId, world, posO, true)) {
                    return false;
                }
                if (Blocks.blocksList[blockId].getPistonPushReaction(world, posO) == 1) {
                    Blocks.blocksList[blockId].dropWithCause(world, EnumDropCause.WORLD, posO, world.getBlockData(posO), world.getTileEntity(posO), null);
                    break;
                }
                if (blocks == maxPushedBlocks) {
                    return false;
                }
                posO.x += direction.getOffsetX();
                posO.y += direction.getOffsetY();
                posO.z += direction.getOffsetZ();
            }
            if (blocks == 1) {
                TilePos posP = new TilePos(posO);
                while (!posO.equals(tilePos)) {
                    posP.set(posO.x - direction.getOffsetX(), posO.y - direction.getOffsetY(), posO.z - direction.getOffsetZ());
                    int pushId = world.getBlockId(posP);
                    TileEntity pushEntity = world.getTileEntity(posP);
                    if (pushEntity instanceof TileEntityMovingPistonBlock && posP.equals(tilePos)) break;
                    if (pushId == this.block.id() && posP.equals(tilePos)) {
                        this.createPistonHeadAt(world, posO, data, direction);
                    }
                    if (!posP.equals(tilePos)) {
                        world.setBlockIdDataRaw(posP, 0, 0);
                    }
                    posO.x = posP.x;
                    posO.y = posP.y;
                    posO.z = posP.z;
                }
                return true;
            }
        }
        return super.tryExtend(world, tilePos, direction, maxPushedBlocks);
    }

    @Override
    public void extendEvent(@NotNull World world, @NotNull TilePos tilePos, int data, @NotNull Direction direction) {
        ArrayList<Entity> entityList = new ArrayList<Entity>(world.getEntitiesWithinAABBExcludingEntity(null, AABB.fromPool((double)tilePos.x + (double)direction.getOffsetX(), (double)tilePos.y + (double)direction.getOffsetY(), (double)tilePos.z + (double)direction.getOffsetZ(), (double)tilePos.x + (double)direction.getOffsetX() + 1.0, (double)tilePos.y + (double)direction.getOffsetY() + 1.0, (double)tilePos.z + (double)direction.getOffsetZ() + 1.0)));
        for (Entity entity : entityList) {
            if (entity == null || entity.noPhysics || entity == this.flungBlock || entity.world.isClientSide && entity instanceof Player) continue;
            double speed = 2.0;
            entity.fling((double)direction.getOffsetX() * 2.0, (double)direction.getOffsetY() * 2.0, (double)direction.getOffsetZ() * 2.0, 1.0f);
        }
        this.flungBlock = null;
        super.extendEvent(world, tilePos, data, direction);
    }

    @Override
    public void createPistonHeadAt(@NotNull World world, @NotNull TilePos tilePos, int data, @NotNull Direction direction) {
        world.setBlockIdData(tilePos, Blocks.PISTON_MOVING.id(), BlockLogicPistonHead.setPistonType(2, direction.getId()));
        world.replaceTileEntity(tilePos, BlockLogicPistonMoving.createTileEntity(Blocks.PISTON_HEAD_STEEL.id(), BlockLogicPistonHead.setPistonType(2, direction.getId()), null, direction, true, false));
    }
}

