/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockSlab<T extends BlockLogic>
extends ItemBlock<T> {
    public ItemBlockSlab(@NotNull Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePos blockPos, @NotNull Side side, double xHit, double yHit) {
        int id = world.getBlockId(blockPos);
        int meta = world.getBlockData(blockPos) & 3;
        int otherMeta = world.getBlockData(blockPos) & 0xFFFFFFFC;
        if (Blocks.blocksList[world.getBlockId(blockPos)] != null && Blocks.blocksList[world.getBlockId(blockPos)].hasTag(BlockTags.PLACE_OVERWRITES)) {
            id = 0;
            meta = 0;
        }
        if (selfStack.stackSize <= 0 || blockPos.y == world.getHeightBlocks() - 1 && this.block.getMaterial().isSolid()) {
            return false;
        }
        if (id == this.block.id() && otherMeta == selfStack.getMetadata() && (side == Side.TOP || side == Side.BOTTOM) && (side == Side.TOP && meta == 0 || side == Side.BOTTOM && meta == 2)) {
            AABB bbBox = AABB.fromPool(blockPos.x, blockPos.y, blockPos.z, (float)blockPos.x + 1.0f, (float)blockPos.y + 1.0f, (float)blockPos.z + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            world.setBlockDataNotify(blockPos, 1 | selfStack.getMetadata());
            world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (id != 0) {
            blockPos = (TilePos)blockPos.add(side.getDirection());
            id = world.getBlockId(blockPos);
            meta = world.getBlockData(blockPos) & 3;
            otherMeta = world.getBlockData(blockPos) & 0xFFFFFFFC;
        }
        if (id == this.block.id() && otherMeta == selfStack.getMetadata() && (yHit > 0.5 && meta == 0 || yHit <= 0.5 && meta == 2 || side == Side.BOTTOM && meta == 0 || side == Side.TOP && meta == 2)) {
            AABB bbBox = AABB.fromPool(blockPos.x, blockPos.y, blockPos.z, (float)blockPos.x + 1.0f, (float)blockPos.y + 1.0f, (float)blockPos.z + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            world.setBlockDataNotify(blockPos, 1 | selfStack.getMetadata());
            world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        if (world.canBlockIdBePlacedAt(this.block.id(), blockPos, false, side)) {
            int placeMeta = this.getPlacedData(selfStack, world, player, blockPos, side, xHit, yHit);
            if (world.setBlockIdDataNotify(blockPos, this.block.id(), placeMeta)) {
                if (player == null) {
                    this.block.onPlacedOnSide(world, blockPos, side, xHit, yHit);
                } else {
                    this.block.onPlacedByMob(world, blockPos, side, player, xHit, yHit);
                }
                world.playBlockSoundEffect(player, (float)blockPos.x + 0.5f, (float)blockPos.y + 0.5f, (float)blockPos.z + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                selfStack.consumeItem(player);
                return true;
            }
        }
        return false;
    }
}

