/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemToolShears
extends Item {
    public ItemToolShears(@NotNull String name, @NotNull String namespaceId, int id, @NotNull ToolMaterial material) {
        super(name, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(material.getDurability());
    }

    public void onBlockSheared(@NotNull ItemStack selfStack, @Nullable Mob mob) {
        selfStack.damageItem(1, mob);
    }

    @Override
    public boolean canHarvestBlock(@NotNull ItemStack selfStack, @NotNull Mob mob, @NotNull Block<?> block) {
        return block.hasTag(BlockTags.MINEABLE_BY_SHEARS);
    }

    @Override
    public float getStrVsBlock(@NotNull ItemStack selfStack, @NotNull Block<?> block) {
        if (block == Blocks.COBWEB || Block.hasLogicClass(block, BlockLogicLeavesBase.class)) {
            return 15.0f;
        }
        if (block.hasTag(BlockTags.MINEABLE_BY_SHEARS)) {
            return 10.0f;
        }
        return super.getStrVsBlock(selfStack, block);
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePos blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        blockPos = (TilePos)blockPos.add(direction);
        AABB box = AABB.fromPool(blockPos.x, blockPos.y, blockPos.z, blockPos.x + 1, blockPos.y + 1, blockPos.z + 1);
        List<MobSheep> entities = world.getEntitiesWithinAABB(MobSheep.class, box);
        if (!entities.isEmpty()) {
            entities.get(0).onItemInteract(selfStack);
        }
    }
}

