/*
 * Decompiled with CFR 0.152.
 */
package org.useless.seedviewer.bta.chunk.provider;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderSeedViewer
implements IChunkProvider {
    public static final int CHUNK_RADIUS = 64;
    public static final int CHUNK_MASK = 127;
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private final Chunk blankChunk;
    @Nullable
    public ChunkGenerator chunkGenerator;
    @Nullable
    private final IChunkLoader chunkLoader;
    private final Chunk[] chunks;
    @NotNull
    private final World world;
    @NotNull
    private ChunkPos lastQueriedChunkPos = new ChunkPos(Integer.MIN_VALUE, Integer.MIN_VALUE);
    @Nullable
    private Chunk lastQueriedChunk;
    @NotNull
    private ChunkPos curChunkPos = new ChunkPos(0, 0);

    public ChunkProviderSeedViewer(@NotNull World world, @Nullable IChunkLoader ichunkloader, @Nullable ChunkGenerator chunkGenerator) {
        this.chunks = new Chunk[16384];
        this.blankChunk = new EmptyChunk(world, new ChunkPos(0, 0));
        this.world = world;
        this.chunkLoader = ichunkloader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
        this.curChunkPos = new ChunkPos(chunkPos);
    }

    public boolean canChunkExist(@NotNull ChunkPos chunkPos) {
        int r = 63;
        return chunkPos.x >= this.curChunkPos.x - r && chunkPos.z >= this.curChunkPos.z - r && chunkPos.x <= this.curChunkPos.x + r && chunkPos.z <= this.curChunkPos.z + r;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
        int cx = chunkPos.x & 0x7F;
        int cz = chunkPos.z & 0x7F;
        int index = cx + cz * 64 * 2;
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk newChunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
        newChunk.fixMissingBlocks();
        this.chunks[index] = newChunk;
        if (!this.chunks[index].isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1)) && this.isChunkLoaded(chunkPos.add(0, 1)) && this.isChunkLoaded(chunkPos.add(1, 0))) {
            this.populate(chunkPos);
        }
        if (this.isChunkLoaded(chunkPos.add(-1, 0)) && !this.provideChunk((ChunkPos)chunkPos.add((int)-1, (int)0), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1)) && this.isChunkLoaded(chunkPos.add(0, 1)) && this.isChunkLoaded(chunkPos.add(-1, 0))) {
            this.populate(chunkPos.add(-1, 0));
        }
        if (this.isChunkLoaded(chunkPos.add(0, -1)) && !this.provideChunk((ChunkPos)chunkPos.add((int)0, (int)-1), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1)) && this.isChunkLoaded(chunkPos.add(0, -1)) && this.isChunkLoaded(chunkPos.add(1, 0))) {
            this.populate(chunkPos.add(0, -1));
        }
        if (this.isChunkLoaded(chunkPos.add(-1, -1)) && !this.provideChunk((ChunkPos)chunkPos.add((int)-1, (int)-1), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, -1)) && this.isChunkLoaded(chunkPos.add(0, -1)) && this.isChunkLoaded(chunkPos.add(-1, 0))) {
            this.populate(chunkPos.add(-1, -1));
        }
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        if (!this.canChunkExist(chunkPos)) {
            return false;
        }
        if (chunkPos.equals(this.lastQueriedChunkPos) && this.lastQueriedChunk != null) {
            return true;
        }
        int k = chunkPos.x & 0x7F;
        int l = chunkPos.z & 0x7F;
        int chunkIndex = k + l * 64 * 2;
        return this.chunks[chunkIndex] == this.blankChunk || this.chunks[chunkIndex] != null && this.chunks[chunkIndex].isAtLocation(chunkPos);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        return this.provideChunk(chunkPos, true);
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        if (chunkPos.equals(this.lastQueriedChunkPos) && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.world.findingSpawnPoint && !this.canChunkExist(chunkPos)) {
            return this.blankChunk;
        }
        int cx = chunkPos.x & 0x7F;
        int cz = chunkPos.z & 0x7F;
        int index = cx + cz * 64 * 2;
        if (!this.isChunkLoaded(chunkPos)) {
            Chunk chunk;
            if (this.chunks[index] != null) {
                this.chunks[index].onUnload();
            }
            if ((chunk = this.loadChunk(chunkPos)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.blankChunk;
                }
            }
            this.chunks[index] = chunk;
            chunk.checkForLightGaps();
            chunk.onLoad();
            if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, 1)) && this.isChunkLoaded(chunkPos.add(0, 1)) && this.isChunkLoaded(chunkPos.add(1, 0))) {
                this.populate(chunkPos);
            }
            if (this.isChunkLoaded(chunkPos.add(-1, 0)) && !this.provideChunk((ChunkPos)chunkPos.add((int)-1, (int)0), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, 1)) && this.isChunkLoaded(chunkPos.add(0, 1)) && this.isChunkLoaded(chunkPos.add(-1, 0))) {
                this.populate(chunkPos.add(-1, 0));
            }
            if (this.isChunkLoaded(chunkPos.add(0, -1)) && !this.provideChunk((ChunkPos)chunkPos.add((int)0, (int)-1), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(1, -1)) && this.isChunkLoaded(chunkPos.add(0, -1)) && this.isChunkLoaded(chunkPos.add(1, 0))) {
                this.populate(chunkPos.add(0, -1));
            }
            if (this.isChunkLoaded(chunkPos.add(-1, -1)) && !this.provideChunk((ChunkPos)chunkPos.add((int)-1, (int)-1), (boolean)true).isTerrainPopulated && this.isChunkLoaded(chunkPos.add(-1, -1)) && this.isChunkLoaded(chunkPos.add(0, -1)) && this.isChunkLoaded(chunkPos.add(-1, 0))) {
                this.populate(chunkPos.add(-1, -1));
            }
            if (this.world.getCurrentWeather() != null) {
                this.world.getCurrentWeather().doChunkLoadEffect(this.world, chunk);
            }
        }
        this.lastQueriedChunkPos = chunkPos;
        this.lastQueriedChunk = this.chunks[index];
        return this.chunks[index];
    }

    private Chunk loadChunk(@NotNull ChunkPos chunkPos) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, chunkPos.x, chunkPos.z);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Error loading chunk at X:{}, Z:{}", chunkPos.x, chunkPos.x, exception);
            return this.blankChunk;
        }
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        return false;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunks) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        Arrays.fill(this.chunks, null);
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "ChunkCache: " + this.chunks.length;
    }
}

