/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Objects;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tessellator.TessellatorStandard;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.meta.gui.GuiTextureProperties;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class Gui {
    public float zLevel = 0.0f;

    public void drawLineHorizontal(int minX, int maxX, int minY, int argb) {
        if (maxX < minX) {
            int temp = minX;
            minX = maxX;
            maxX = temp;
        }
        this.drawRect(minX, minY, maxX + 1, minY + 1, argb);
    }

    public void drawLineHorizontalDouble(double minX, double maxX, double minY, int argb) {
        if (maxX < minX) {
            double temp = minX;
            minX = maxX;
            maxX = temp;
        }
        this.drawRectDouble(minX, minY, maxX + 1.0, minY + 1.0, argb);
    }

    public void drawLineVertical(int minX, int minY, int maxY, int argb) {
        if (maxY < minY) {
            int temp = minY;
            minY = maxY;
            maxY = temp;
        }
        this.drawRect(minX, minY + 1, minX + 1, maxY, argb);
    }

    public void drawLineVerticalDouble(double minX, double minY, double maxY, int argb) {
        if (maxY < minY) {
            double temp = minY;
            minY = maxY;
            maxY = temp;
        }
        this.drawRectDouble(minX, minY + 1.0, minX + 1.0, maxY, argb);
    }

    public void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        int temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        TessellatorStandard tessellator = Tessellator.instance;
        GL11.glEnable(3042);
        GL11.glDisable(3553);
        GL11.glBlendFunc(770, 771);
        GL11.glColor4f(r, g, b, a);
        tessellator.startDrawingQuads();
        tessellator.addVertex(minX, maxY, this.zLevel);
        tessellator.addVertex(maxX, maxY, this.zLevel);
        tessellator.addVertex(maxX, minY, this.zLevel);
        tessellator.addVertex(minX, minY, this.zLevel);
        tessellator.draw();
        GL11.glEnable(3553);
        GL11.glDisable(3042);
    }

    public void drawRectDouble(double minX, double minY, double maxX, double maxY, int argb) {
        double temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        TessellatorStandard tessellator = Tessellator.instance;
        GL11.glEnable(3042);
        GL11.glDisable(3553);
        GL11.glBlendFunc(770, 771);
        GL11.glColor4f(r, g, b, a);
        tessellator.startDrawingQuads();
        tessellator.addVertex(minX, maxY, this.zLevel);
        tessellator.addVertex(maxX, maxY, this.zLevel);
        tessellator.addVertex(maxX, minY, this.zLevel);
        tessellator.addVertex(minX, minY, this.zLevel);
        tessellator.draw();
        GL11.glEnable(3553);
        GL11.glDisable(3042);
    }

    public void drawBox(int minX, int minY, int maxX, int maxY, int argb, int lineThickness) {
        this.drawRect(minX, minY, maxX, minY + lineThickness, argb);
        this.drawRect(minX, maxY - lineThickness, maxX, maxY, argb);
        this.drawRect(minX, minY + lineThickness, minX + lineThickness, maxY - lineThickness, argb);
        this.drawRect(maxX - lineThickness, minY + lineThickness, maxX, maxY - lineThickness, argb);
    }

    public void drawRectNoBlend(int minX, int minY, int maxX, int maxY, int argb) {
        int temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        TessellatorStandard tessellator = Tessellator.instance;
        GL11.glDisable(3553);
        GL11.glColor4f(r, g, b, a);
        tessellator.startDrawingQuads();
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.draw();
        GL11.glEnable(3553);
    }

    public void drawRectWidthHeight(int x, int y, int width, int height, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb >> 0 & 0xFF) / 255.0f;
        GL11.glColor4f(r, g, b, a);
        GL11.glDisable(3553);
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x, y + height, 0.0);
        tessellator.addVertex(x + width, y + height, 0.0);
        tessellator.addVertex(x + width, y, 0.0);
        tessellator.draw();
        GL11.glEnable(3553);
    }

    public void drawGradientRect(int minX, int minY, int maxX, int maxY, int argb1, int argb2) {
        float a1 = (float)(argb1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(argb1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(argb1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(argb1 & 0xFF) / 255.0f;
        float a2 = (float)(argb2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(argb2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(argb2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(argb2 & 0xFF) / 255.0f;
        GL11.glDisable(3553);
        GL11.glEnable(3042);
        GL11.glDisable(3008);
        GL11.glBlendFunc(770, 771);
        GL11.glShadeModel(7425);
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(r1, g1, b1, a1);
        tessellator.addVertex(maxX, minY, 0.0);
        tessellator.addVertex(minX, minY, 0.0);
        tessellator.setColorRGBA_F(r2, g2, b2, a2);
        tessellator.addVertex(minX, maxY, 0.0);
        tessellator.addVertex(maxX, maxY, 0.0);
        tessellator.draw();
        GL11.glShadeModel(7424);
        GL11.glDisable(3042);
        GL11.glEnable(3008);
        GL11.glEnable(3553);
    }

    public void drawStringCenteredShadow(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, int argb) {
        fontRenderer.renderCentered((Tessellator)Tessellator.instance, chars, x, y).setZ(this.zLevel).setShadow().setColor(argb).call();
    }

    public void drawStringCenteredNoShadow(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, int argb) {
        fontRenderer.renderCentered((Tessellator)Tessellator.instance, chars, x, y).setZ(this.zLevel).setColor(argb).call();
    }

    public void drawStringShadow(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, int argb) {
        fontRenderer.render((Tessellator)Tessellator.instance, chars, x, y).setZ(this.zLevel).setShadow().setColor(argb).call();
    }

    public void drawStringNoShadow(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, int argb) {
        fontRenderer.render((Tessellator)Tessellator.instance, chars, x, y).setZ(this.zLevel).setColor(argb).call();
    }

    public void drawStringConstrained(@NotNull FontRenderer fontRenderer, @NotNull CharSequence chars, int x, int y, int maxWidth, int argb) {
        fontRenderer.renderWidthConstrained((Tessellator)Tessellator.instance, chars, x, y, maxWidth).setZ(this.zLevel).setColor(argb).call();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + height, this.zLevel, (float)u * 0.00390625f, (float)(v + height) * 0.00390625f);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f);
        tessellator.addVertexWithUV(x + width, y, this.zLevel, (float)(u + width) * 0.00390625f, (float)v * 0.00390625f);
        tessellator.addVertexWithUV(x, y, this.zLevel, (float)u * 0.00390625f, (float)v * 0.00390625f);
        tessellator.draw();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double uScale, double vScale) {
        double off = 0.05;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x - 0.05, (double)(y + height) + 0.05, this.zLevel, (double)u * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV((double)(x + width) + 0.05, (double)(y + height) + 0.05, this.zLevel, (double)(u + width) * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV((double)(x + width) + 0.05, (double)y - 0.05, this.zLevel, (double)(u + width) * uScale, (double)v * vScale);
        tessellator.addVertexWithUV((double)x - 0.05, (double)y - 0.05, this.zLevel, (double)u * uScale, (double)v * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRectDouble(double x, double y, double u, double v, double width, double height, double uScale, double vScale) {
        double off = 0.05;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x - 0.05, y + height + 0.05, this.zLevel, (u + 0.0) * uScale, (v + height) * vScale);
        tessellator.addVertexWithUV(x + width + 0.05, y + height + 0.05, this.zLevel, (u + width) * uScale, (v + height) * vScale);
        tessellator.addVertexWithUV(x + width + 0.05, y - 0.05, this.zLevel, (u + width) * uScale, (v + 0.0) * vScale);
        tessellator.addVertexWithUV(x - 0.05, y - 0.05, this.zLevel, (u + 0.0) * uScale, (v + 0.0) * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, double uScale, double vScale, double off) {
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x - off, (double)(y + height) + off, this.zLevel, (double)u * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV((double)(x + width) + off, (double)(y + height) + off, this.zLevel, (double)(u + width) * uScale, (double)(v + height) * vScale);
        tessellator.addVertexWithUV((double)(x + width) + off, (double)y - off, this.zLevel, (double)(u + width) * uScale, (double)v * vScale);
        tessellator.addVertexWithUV((double)x - off, (double)y - off, this.zLevel, (double)u * uScale, (double)v * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRectDouble(double x, double y, double u, double v, double width, double height, double uScale, double vScale, double off) {
        double foon = 0.0;
        double goon = 0.0;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x - off, y + height + off, this.zLevel, (u + 0.5) * uScale, (v + height) * vScale);
        tessellator.addVertexWithUV(x + width + off, y + height + off, this.zLevel, (u + width - 0.5) * uScale, (v + height) * vScale);
        tessellator.addVertexWithUV(x + width + off, y - off, this.zLevel, (u + width - 0.5) * uScale, v * vScale);
        tessellator.addVertexWithUV(x - off, y - off, this.zLevel, (u + 0.5) * uScale, v * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRectDouble(double x, double y, double u, double v, double width, double height, double uWidth, double vHeight, double uScale, double vScale) {
        double foon = 0.5 * uScale;
        double goon = 0.0625 * (16.0 / uWidth);
        double off = 0.05;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x - 0.05, y + height + 0.05, this.zLevel, (u + foon) * uScale, (v + vHeight - foon) * vScale);
        tessellator.addVertexWithUV(x + width + 0.05, y + height + 0.05, this.zLevel, (u + uWidth - foon) * uScale, (v + vHeight - foon) * vScale);
        tessellator.addVertexWithUV(x + width + 0.05, y - 0.05, this.zLevel, (u + uWidth - foon) * uScale, (v + foon) * vScale);
        tessellator.addVertexWithUV(x - 0.05, y - 0.05, this.zLevel, (u + foon) * uScale, (v + foon) * vScale);
        tessellator.draw();
    }

    public void drawTexturedModalRect(double x, double y, int u, int v, int width, int height, int uvWidth, int uvHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + (double)height, this.zLevel, (float)u * 0.00390625f, (float)(v + uvHeight) * 0.00390625f);
        tessellator.addVertexWithUV(x + (double)width, y + (double)height, this.zLevel, (float)(u + uvWidth) * 0.00390625f, (float)(v + uvHeight) * 0.00390625f);
        tessellator.addVertexWithUV(x + (double)width, y + 0.0, this.zLevel, (float)(u + uvWidth) * 0.00390625f, (float)v * 0.00390625f);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, (float)u * 0.00390625f, (float)v * 0.00390625f);
        tessellator.draw();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int uvWidth, float scale) {
        float uScale = scale;
        float vScale = scale;
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + height, this.zLevel, (float)u * uScale, (float)(v + uvWidth) * vScale);
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, (float)(u + uvWidth) * uScale, (float)(v + uvWidth) * vScale);
        tessellator.addVertexWithUV(x + width, y, this.zLevel, (float)(u + uvWidth) * uScale, (float)v * vScale);
        tessellator.addVertexWithUV(x, y, this.zLevel, (float)u * uScale, (float)v * vScale);
        tessellator.draw();
    }

    public void drawTexturedIcon(int x, int y, int width, int height, IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        TessellatorStandard tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + height, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y + height, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(x + width, y, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(x, y, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.draw();
    }

    public void drawGuiTexture(TextureManager re, int x, int y, int width, int height, String texture) {
        Texture tex = re.loadTexture(texture);
        tex.bind();
        TessellatorStandard t = Tessellator.instance;
        if (tex.hasMeta("gui")) {
            GuiTextureProperties properties = Objects.requireNonNull(tex.getMeta("gui", GuiTextureProperties.class));
            switch (properties.type) {
                case "stretch": {
                    t.startDrawingQuads();
                    t.addVertexWithUV(x, y + height, this.zLevel, 0.0, 1.0);
                    t.addVertexWithUV(x + width, y + height, this.zLevel, 1.0, 1.0);
                    t.addVertexWithUV(x + width, y, this.zLevel, 1.0, 0.0);
                    t.addVertexWithUV(x, y, this.zLevel, 0.0, 0.0);
                    t.draw();
                    break;
                }
                case "tile": {
                    double uScale = 1.0 / (double)properties.width;
                    double vScale = 1.0 / (double)properties.height;
                    t.startDrawingQuads();
                    t.addVertexWithUV(x, y + height, this.zLevel, 0.0, (double)height * vScale);
                    t.addVertexWithUV(x + width, y + height, this.zLevel, (double)width * uScale, (double)height * vScale);
                    t.addVertexWithUV(x + width, y, this.zLevel, (double)width * uScale, 0.0);
                    t.addVertexWithUV(x, y, this.zLevel, 0.0, 0.0);
                    t.draw();
                    break;
                }
                case "nine_slice": {
                    int i;
                    double uScale = 1.0 / (double)properties.width;
                    double vScale = 1.0 / (double)properties.height;
                    int innerWidth = properties.width - (properties.border.left + properties.border.right);
                    int innerHeight = properties.height - (properties.border.top + properties.border.bottom);
                    int innerLeft = properties.border.left;
                    int innerTop = properties.border.top;
                    int innerRight = properties.width - properties.border.right;
                    int innerBottom = properties.height - properties.border.bottom;
                    int leftHeight = height - (properties.border.top + properties.border.bottom);
                    int repeatsY = leftHeight / innerHeight;
                    int remainderY = leftHeight % innerHeight;
                    int topWidth = width - (properties.border.left + properties.border.right);
                    int repeatsX = topWidth / innerWidth;
                    int remainderX = topWidth % innerWidth;
                    if (!properties.stretchInner) {
                        for (int j = 0; j < repeatsY; ++j) {
                            this.drawTexturedModalRectDouble(x + innerLeft + repeatsX * innerWidth, y + innerTop + j * innerHeight, innerLeft + 1, innerTop, remainderX, innerHeight, uScale, vScale, 0.0);
                        }
                        for (i = 0; i < repeatsX; ++i) {
                            this.drawTexturedModalRectDouble(x + innerLeft + i * innerWidth, y + innerTop + repeatsY * innerHeight, innerLeft, innerTop, innerWidth, remainderY, uScale, vScale, 0.0);
                        }
                        this.drawTexturedModalRectDouble(x + innerLeft + repeatsX * innerWidth, y + innerTop + repeatsY * innerHeight, innerLeft, innerTop, remainderX, remainderY, uScale, vScale, 0.0);
                        for (i = 0; i < repeatsX; ++i) {
                            for (int j = 0; j < repeatsY; ++j) {
                                this.drawTexturedModalRectDouble(x + innerLeft + i * innerWidth, y + innerTop + j * innerHeight, innerLeft, innerTop, innerWidth, innerHeight, uScale, vScale, 0.0);
                            }
                        }
                    }
                    for (i = 0; i < repeatsY; ++i) {
                        this.drawTexturedModalRectDouble(x, y + innerTop + i * innerHeight, 0.0, innerTop, innerLeft, innerHeight, uScale, vScale, 0.0);
                        this.drawTexturedModalRectDouble(x + width - properties.border.right, y + innerTop + i * innerHeight, innerRight, innerTop, innerLeft, innerHeight, uScale, vScale, 0.0);
                    }
                    this.drawTexturedModalRectDouble(x, y + innerTop + repeatsY * innerHeight, 0.0, innerTop, innerLeft, remainderY, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x + width - properties.border.right, y + innerTop + repeatsY * innerHeight, innerRight, innerTop, innerLeft, remainderY, uScale, vScale, 0.0);
                    for (i = 0; i < repeatsX; ++i) {
                        this.drawTexturedModalRectDouble(x + innerLeft + i * innerWidth, y, innerLeft, 0.0, innerWidth, properties.border.top, uScale, vScale, 0.0);
                        this.drawTexturedModalRectDouble(x + innerLeft + i * innerWidth, y + height - properties.border.bottom, innerLeft, innerBottom, innerWidth, properties.border.bottom, uScale, vScale, 0.0);
                    }
                    this.drawTexturedModalRectDouble(x + innerLeft + repeatsX * innerWidth, y, innerLeft, 0.0, remainderX, properties.border.top, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x + innerLeft + repeatsX * innerWidth, y + height - properties.border.bottom, innerLeft, innerBottom, remainderX, properties.border.bottom, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x, y, 0.0, 0.0, properties.border.left, properties.border.top, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x + width - properties.border.right, y, innerRight, 0.0, properties.border.right, properties.border.top, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x, y + height - properties.border.bottom, 0.0, innerBottom, properties.border.left, properties.border.bottom, uScale, vScale, 0.0);
                    this.drawTexturedModalRectDouble(x + width - properties.border.right, y + height - properties.border.bottom, innerRight, innerBottom, properties.border.right, properties.border.bottom, uScale, vScale, 0.0);
                    break;
                }
            }
        } else {
            t.startDrawingQuads();
            t.addVertexWithUV(x, y + height, this.zLevel, 0.0, 1.0);
            t.addVertexWithUV(x + width, y + height, this.zLevel, 1.0, 1.0);
            t.addVertexWithUV(x + width, y, this.zLevel, 1.0, 0.0);
            t.addVertexWithUV(x, y, this.zLevel, 0.0, 0.0);
            t.draw();
        }
    }

    public void drawGuiIcon(int x, int y, int width, int height, @NotNull IconCoordinate coordinate) {
        this.drawGuiIconDouble(x, y, width, height, coordinate);
    }

    public void drawGuiIconDouble(double x, double y, double width, double height, @NotNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        TessellatorStandard t = Tessellator.instance;
        if (coordinate.hasMeta("gui")) {
            GuiTextureProperties properties = Objects.requireNonNull(coordinate.getMeta("gui", GuiTextureProperties.class));
            switch (properties.type) {
                case "stretch": {
                    t.startDrawingQuads();
                    t.addVertexWithUV(x, y + height, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMax());
                    t.addVertexWithUV(x + width, y + height, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMax());
                    t.addVertexWithUV(x + width, y, this.zLevel, coordinate.getIconUMax(), coordinate.getIconVMin());
                    t.addVertexWithUV(x, y, this.zLevel, coordinate.getIconUMin(), coordinate.getIconVMin());
                    t.draw();
                    break;
                }
                case "tile": {
                    int i;
                    int repeatsY = MathHelper.floor(height / (double)properties.height);
                    double remainderY = height % (double)properties.height;
                    int repeatsX = MathHelper.floor(width / (double)properties.width);
                    double remainderX = width % (double)properties.width;
                    double uScale = (double)coordinate.width / (double)properties.width;
                    double vScale = (double)coordinate.height / (double)properties.height;
                    for (i = 0; i < repeatsX; ++i) {
                        for (int j = 0; j < repeatsY; ++j) {
                            this.drawIconTextureDouble(x + (double)(properties.width * i), y + (double)(properties.height * j), x + (double)(properties.width * (i + 1)), y + (double)(properties.height * (j + 1)), 0.0, 0.0, (double)properties.width * uScale, (double)properties.height * vScale, coordinate);
                        }
                    }
                    for (int j = 0; j < repeatsY; ++j) {
                        this.drawIconTextureDouble(x + (double)(properties.width * repeatsX), y + (double)(properties.height * j), x + (double)(properties.width * repeatsX) + remainderX, y + (double)(properties.height * (j + 1)), 0.0, 0.0, remainderX * uScale, (double)properties.height * vScale, coordinate);
                    }
                    for (i = 0; i < repeatsX; ++i) {
                        this.drawIconTextureDouble(x + (double)(properties.width * i), y + (double)(properties.height * repeatsY), x + (double)(properties.width * (i + 1)), y + (double)(properties.height * repeatsY) + remainderY, 0.0, 0.0, (double)properties.width * uScale, remainderY * vScale, coordinate);
                    }
                    this.drawIconTextureDouble(x + (double)(properties.width * repeatsX), y + (double)(properties.height * repeatsY), x + (double)(properties.width * repeatsX) + remainderX, y + (double)(properties.height * repeatsY) + remainderY, 0.0, 0.0, remainderX * uScale, remainderY * vScale, coordinate);
                    break;
                }
                case "nine_slice": {
                    int i;
                    int innerWidth = properties.width - (properties.border.left + properties.border.right);
                    int innerHeight = properties.height - (properties.border.top + properties.border.bottom);
                    int innerLeft = properties.border.left;
                    int innerTop = properties.border.top;
                    int innerRight = properties.width - properties.border.right;
                    int innerBottom = properties.height - properties.border.bottom;
                    double uScale = (double)coordinate.width / (double)properties.width;
                    double vScale = (double)coordinate.height / (double)properties.height;
                    double leftHeight = height - (double)(properties.border.top + properties.border.bottom);
                    int repeatsY = MathHelper.floor(leftHeight / (double)innerHeight);
                    double remainderY = leftHeight % (double)innerHeight;
                    double topWidth = width - (double)(properties.border.left + properties.border.right);
                    int repeatsX = MathHelper.floor(topWidth / (double)innerWidth);
                    double remainderX = topWidth % (double)innerWidth;
                    if (properties.stretchInner) {
                        this.drawIconTextureDouble(x + (double)innerLeft, y + (double)innerTop, x + (double)innerLeft + width - (double)properties.border.right - (double)properties.border.left, y + (double)innerTop + height - (double)properties.border.bottom - (double)properties.border.top, (double)innerLeft * uScale, (double)innerTop * vScale, (double)innerRight * uScale, (double)innerBottom * vScale, coordinate);
                    } else {
                        for (int j = 0; j < repeatsY; ++j) {
                            this.drawIconTextureDouble(x + (double)innerLeft + (double)(repeatsX * innerWidth), y + (double)innerTop + (double)(j * innerHeight), x + (double)innerLeft + (double)(repeatsX * innerWidth) + remainderX, y + (double)innerTop + (double)(j * innerHeight) + (double)innerHeight, (double)innerLeft * uScale, (double)innerTop * vScale, ((double)innerLeft + remainderX) * uScale, (double)(innerTop + innerHeight) * vScale, coordinate);
                        }
                        for (i = 0; i < repeatsX; ++i) {
                            this.drawIconTextureDouble(x + (double)innerLeft + (double)(i * innerWidth), y + (double)innerTop + (double)(repeatsY * innerHeight), x + (double)innerLeft + (double)(i * innerWidth) + (double)innerWidth, y + (double)innerTop + (double)(repeatsY * innerHeight) + remainderY, (double)innerLeft * uScale, (double)innerTop * vScale, (double)(innerLeft + innerWidth) * uScale, ((double)innerTop + remainderY) * vScale, coordinate);
                        }
                        this.drawIconTextureDouble(x + (double)innerLeft + (double)(repeatsX * innerWidth), y + (double)innerTop + (double)(repeatsY * innerHeight), x + (double)innerLeft + (double)(repeatsX * innerWidth) + remainderX, y + (double)innerTop + (double)(repeatsY * innerHeight) + remainderY, (double)innerLeft * uScale, (double)innerTop * vScale, ((double)innerLeft + remainderX) * uScale, ((double)innerTop + remainderY) * vScale, coordinate);
                        for (i = 0; i < repeatsX; ++i) {
                            for (int j = 0; j < repeatsY; ++j) {
                                double xMin = x + (double)innerLeft + (double)(i * innerWidth);
                                double yMin = y + (double)innerTop + (double)(j * innerHeight);
                                this.drawIconTextureDouble(xMin, yMin, xMin + (double)innerWidth, yMin + (double)innerHeight, (double)innerLeft * uScale, (double)innerTop * vScale, (double)(innerLeft + innerWidth) * uScale, (double)(innerTop + innerHeight) * vScale, coordinate);
                            }
                        }
                    }
                    for (i = 0; i < repeatsY; ++i) {
                        this.drawIconTextureDouble(x, y + (double)innerTop + (double)(i * innerHeight), x + (double)innerLeft, y + (double)innerTop + (double)(i * innerHeight) + (double)innerHeight, 0.0, (double)innerTop * vScale, (double)innerLeft * uScale, (double)(innerTop + innerHeight) * vScale, coordinate);
                        this.drawIconTextureDouble(x + width - (double)properties.border.right, y + (double)innerTop + (double)(i * innerHeight), x + width, y + (double)innerTop + (double)(i * innerHeight) + (double)innerHeight, (double)innerRight * uScale, (double)innerTop * vScale, (double)(innerRight + properties.border.right) * uScale, (double)(innerTop + innerHeight) * vScale, coordinate);
                    }
                    this.drawIconTextureDouble(x, y + (double)innerTop + (double)(repeatsY * innerHeight), x + (double)innerLeft, y + (double)innerTop + (double)(repeatsY * innerHeight) + remainderY, 0.0, (double)innerTop * vScale, (double)innerLeft * uScale, ((double)innerTop + remainderY) * vScale, coordinate);
                    this.drawIconTextureDouble(x + width - (double)properties.border.right, y + (double)innerTop + (double)(repeatsY * innerHeight), x + width, y + (double)innerTop + (double)(repeatsY * innerHeight) + remainderY, (double)innerRight * uScale, (double)innerTop * vScale, (double)(innerRight + properties.border.right) * uScale, ((double)innerTop + remainderY) * vScale, coordinate);
                    for (i = 0; i < repeatsX; ++i) {
                        this.drawIconTextureDouble(x + (double)innerLeft + (double)(i * innerWidth), y, x + (double)innerLeft + (double)(i * innerWidth) + (double)innerWidth, y + (double)properties.border.top, (double)innerLeft * uScale, 0.0, (double)(innerLeft + innerWidth) * uScale, (double)properties.border.top * vScale, coordinate);
                        this.drawIconTextureDouble(x + (double)innerLeft + (double)(i * innerWidth), y + height - (double)properties.border.bottom, x + (double)innerLeft + (double)(i * innerWidth) + (double)innerWidth, y + height, (double)innerLeft * uScale, (double)innerBottom * vScale, (double)(innerLeft + innerWidth) * uScale, (double)(innerBottom + properties.border.bottom) * vScale, coordinate);
                    }
                    this.drawIconTextureDouble(x + (double)innerLeft + (double)(repeatsX * innerWidth), y, x + (double)innerLeft + (double)(repeatsX * innerWidth) + remainderX, y + (double)properties.border.top, (double)innerLeft * uScale, 0.0, ((double)innerLeft + remainderX) * uScale, (double)properties.border.top * vScale, coordinate);
                    this.drawIconTextureDouble(x + (double)innerLeft + (double)(repeatsX * innerWidth), y + height - (double)properties.border.bottom, x + (double)innerLeft + (double)(repeatsX * innerWidth) + remainderX, y + height, (double)innerLeft * uScale, (double)innerBottom * vScale, ((double)innerLeft + remainderX) * uScale, (double)(innerBottom + properties.border.bottom) * vScale, coordinate);
                    this.drawIconTextureDouble(x, y, x + (double)properties.border.left, y + (double)properties.border.top, 0.0, 0.0, (double)properties.border.left * uScale, (double)properties.border.top * vScale, coordinate);
                    this.drawIconTextureDouble(x, y + height - (double)properties.border.bottom, x + (double)properties.border.left, y + height, 0.0, (double)innerBottom * vScale, (double)properties.border.left * uScale, (double)(innerBottom + properties.border.bottom) * vScale, coordinate);
                    this.drawIconTextureDouble(x + width - (double)properties.border.right, y, x + width, y + (double)properties.border.top, (double)innerRight * uScale, 0.0, (double)(innerRight + properties.border.right) * uScale, (double)properties.border.top * uScale, coordinate);
                    this.drawIconTextureDouble(x + width - (double)properties.border.right, y + height - (double)properties.border.bottom, x + width, y + height, (double)innerRight * uScale, (double)innerBottom * vScale, (double)(innerRight + properties.border.right) * uScale, (double)(innerBottom + properties.border.bottom) * vScale, coordinate);
                    break;
                }
            }
        } else {
            this.drawIconTextureDouble(x, y, x + width, y + height, 0.0, 0.0, coordinate.width, coordinate.height, coordinate);
        }
    }

    public void drawIconTexture(int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        double realU0 = coordinate.getSubIconU((double)u0 / (double)coordinate.width);
        double realU1 = coordinate.getSubIconU((double)u1 / (double)coordinate.width);
        double realV0 = coordinate.getSubIconV((double)v0 / (double)coordinate.height);
        double realV1 = coordinate.getSubIconV((double)v1 / (double)coordinate.height);
        TessellatorStandard t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV(x0, y1, this.zLevel, realU0, realV1);
        t.addVertexWithUV(x1, y1, this.zLevel, realU1, realV1);
        t.addVertexWithUV(x1, y0, this.zLevel, realU1, realV0);
        t.addVertexWithUV(x0, y0, this.zLevel, realU0, realV0);
        t.draw();
    }

    public void drawIconTextureDouble(double x0, double y0, double x1, double y1, double u0, double v0, double u1, double v1, IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        double realU0 = coordinate.getSubIconU(u0 / (double)coordinate.width);
        double realU1 = coordinate.getSubIconU(u1 / (double)coordinate.width);
        double realV0 = coordinate.getSubIconV(v0 / (double)coordinate.height);
        double realV1 = coordinate.getSubIconV(v1 / (double)coordinate.height);
        TessellatorStandard t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV(x0, y1, this.zLevel, realU0, realV1);
        t.addVertexWithUV(x1, y1, this.zLevel, realU1, realV1);
        t.addVertexWithUV(x1, y0, this.zLevel, realU1, realV0);
        t.addVertexWithUV(x0, y0, this.zLevel, realU0, realV0);
        t.draw();
    }
}

