/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Comparator;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.terrain.ChunkRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirtyChunkRendererSorter
implements Comparator<ChunkRenderer> {
    @Nullable
    private ICamera activeCamera;

    public void setActiveCamera(@NotNull ICamera camera) {
        this.activeCamera = camera;
    }

    @Override
    public int compare(@NotNull ChunkRenderer cr1, @NotNull ChunkRenderer cr2) {
        double cr2Distance;
        boolean cr1InFrustum = cr1.visible;
        boolean cr2InFrustum = cr2.visible;
        if (cr1 == cr2) {
            return 0;
        }
        if (cr1InFrustum && !cr2InFrustum) {
            return 1;
        }
        if (cr2InFrustum && !cr1InFrustum) {
            return -1;
        }
        double cr1Distance = cr1.distanceToCameraSquared(this.activeCamera);
        if (cr1Distance < (cr2Distance = (double)cr2.distanceToCameraSquared(this.activeCamera))) {
            return 1;
        }
        if (cr1Distance > cr2Distance) {
            return -1;
        }
        return cr1.id >= cr2.id ? -1 : 1;
    }
}

