/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.particle.ParticleBlockBreaking;
import net.minecraft.client.render.tessellator.ParticleTessellator;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tessellator.TessellatorStandard;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;

public final class ParticleEngine {
    public static final int PARTICLE_TEXTURE = 0;
    public static final int TERRAIN_TEXTURE = 1;
    public static final int ITEM_TEXTURE = 2;
    public static final int ENTITY_PARTICLE_TEXTURE = 3;
    public static final int TEXTURE_COUNT = 4;
    private World world;
    private final List<Particle>[] particles = new ObjectArrayList[4];
    private final Random rand = new Random();

    public ParticleEngine(World world) {
        if (world != null) {
            this.world = world;
        }
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new ObjectArrayList<Particle>();
        }
    }

    public void add(Particle p) {
        int t = p.getParticleTexture();
        if (this.particles[t].size() >= 4000) {
            this.particles[t].remove(0);
        }
        this.particles[t].add(p);
    }

    public void tick() {
        for (int tt = 0; tt < this.particles.length; ++tt) {
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.tick();
                if (!p.removed) continue;
                this.particles[tt].remove(i--);
            }
        }
    }

    public void renderParticles(@NotNull ParticleTessellator tessellator, @NotNull ICamera camera, float partialTick) {
        tessellator.setupParticleValues(camera, partialTick);
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        for (int tt = 0; tt < 3; ++tt) {
            if (this.particles[tt].isEmpty()) continue;
            int texture = switch (tt) {
                case 0 -> TextureRegistry.particleAtlas.id();
                case 1 -> TextureRegistry.blockAtlas.id();
                case 2 -> TextureRegistry.itemAtlas.id();
                default -> 0;
            };
            GL11.glBindTexture(3553, texture);
            tessellator.setTranslation(-xOff, -yOff, -zOff);
            tessellator.startDrawingParticles();
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.render(tessellator, partialTick);
            }
            tessellator.drawParticles();
        }
        tessellator.setTranslation(0.0, 0.0, 0.0);
    }

    public void renderLitParticles(ICamera camera, float partialTick) {
        int tt = 3;
        if (this.particles[tt].isEmpty()) {
            return;
        }
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        TessellatorStandard tessellator = Tessellator.instance;
        for (int i = 0; i < this.particles[tt].size(); ++i) {
            Particle p = this.particles[tt].get(i);
            p.renderLit(tessellator, partialTick, xOff, yOff, zOff);
        }
    }

    public void setWorld(World world) {
        this.world = world;
        for (int i = 0; i < 4; ++i) {
            this.particles[i].clear();
        }
    }

    public void destroy(int x, int y, int z, int id, int data) {
        Block<?> block = Blocks.blocksList[id];
        if (block == null) {
            return;
        }
        int amount = 4;
        if (block == Blocks.FIRE) {
            return;
        }
        for (int xx = 0; xx < amount; ++xx) {
            for (int yy = 0; yy < amount; ++yy) {
                for (int zz = 0; zz < amount; ++zz) {
                    double xp = (double)x + ((double)xx + 0.5) / (double)amount;
                    double yp = (double)y + ((double)yy + 0.5) / (double)amount;
                    double zp = (double)z + ((double)zz + 0.5) / (double)amount;
                    Side side = Side.getSideById(this.rand.nextInt(6));
                    this.add(new ParticleBlockBreaking(this.world, xp, yp, zp, xp - (double)x - 0.5, yp - (double)y - 0.5, zp - (double)z - 0.5, block, side, data).init(new TilePos(x, y, z)));
                }
            }
        }
    }

    public void crack(int x, int y, int z, Side side) {
        int id = this.world.getBlockId(x, y, z);
        if (id == 0) {
            return;
        }
        Block<?> block = Blocks.blocksList[id];
        AABBdc bounds = block.getBounds();
        float r = 0.1f;
        double xp = (double)x + this.rand.nextDouble() * (bounds.maxX() - bounds.minX() - (double)(r * 2.0f)) + (double)r + bounds.minX();
        double yp = (double)y + this.rand.nextDouble() * (bounds.maxY() - bounds.minY() - (double)(r * 2.0f)) + (double)r + bounds.minY();
        double zp = (double)z + this.rand.nextDouble() * (bounds.maxZ() - bounds.minZ() - (double)(r * 2.0f)) + (double)r + bounds.minZ();
        if (side == Side.BOTTOM) {
            yp = (double)y + bounds.minY() - (double)r;
        } else if (side == Side.TOP) {
            yp = (double)y + bounds.maxY() + (double)r;
        } else if (side == Side.NORTH) {
            zp = (double)z + bounds.minZ() - (double)r;
        } else if (side == Side.SOUTH) {
            zp = (double)z + bounds.maxZ() + (double)r;
        } else if (side == Side.WEST) {
            xp = (double)x + bounds.minX() - (double)r;
        } else if (side == Side.EAST) {
            xp = (double)x + bounds.maxX() + (double)r;
        }
        this.add(new ParticleBlockBreaking(this.world, xp, yp, zp, 0.0, 0.0, 0.0, block, side, this.world.getBlockMetadata(x, y, z)).init(new TilePos(x, y, z)).setPower(0.2f).setScale(0.6f));
    }

    public int countParticles() {
        return this.particles[0].size() + this.particles[1].size() + this.particles[2].size() + this.particles[3].size();
    }
}

