/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelJar<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate jarEmpty = TextureRegistry.getTexture("minecraft:block/jar");
    protected IconCoordinate jarFull = TextureRegistry.getTexture("minecraft:block/jar_dirt");

    public BlockModelJar(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(worldSource, tilePos));
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, tilePos);
        }
        float yOffset = 0.0f;
        int meta = worldSource.getBlockData(tilePos);
        float extMinX = (float)tilePos.x() + 0.5f - 0.1875f;
        float extMinY = (float)tilePos.y() + yOffset;
        float extMinZ = (float)tilePos.z() + 0.5f - 0.1875f;
        float extMaxX = (float)tilePos.x() + 0.5f + 0.1875f;
        float extMaxY = (float)tilePos.y() + (0.5f + yOffset);
        float extMaxZ = (float)tilePos.z() + 0.5f + 0.1875f;
        float fillMaxY = (float)tilePos.y() + (0.5f + yOffset) - 0.25f;
        float intMinX = (float)tilePos.x() + 0.5f - 0.1875f;
        float intMinY = (float)tilePos.y() + yOffset;
        float intMinZ = (float)tilePos.z() + 0.5f - 0.1875f;
        float intMaxX = (float)tilePos.x() + 0.5f + 0.1875f;
        float intMaxY = (float)tilePos.y() + (0.5f + yOffset);
        float intMaxZ = (float)tilePos.z() + 0.5f + 0.1875f;
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        double texU = texIndex.getIconUMin();
        double texV = texIndex.getIconVMin();
        double onePix = 0.0625;
        double extSideMinU = texU;
        double extSideMaxU = texIndex.getSubIconU(onePix * 6.0);
        double extSideMinV = texIndex.getSubIconV(onePix * 6.0);
        double extSideMaxV = texIndex.getSubIconV(onePix * 14.0);
        double extBottomMinU = texIndex.getSubIconU(onePix * 6.0);
        double extBottomMaxU = texIndex.getSubIconU(onePix * 12.0);
        double extBottomMinV = texV;
        double extBottomMaxV = texIndex.getSubIconV(onePix * 6.0);
        double extTopMinU = texU;
        double extTopMaxU = texIndex.getSubIconU(onePix * 6.0);
        double extTopMinV = texV;
        double extTopMaxV = texIndex.getSubIconV(onePix * 6.0);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, fillMaxY, extMaxZ, extTopMinU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, fillMaxY, extMaxZ, extTopMaxU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, fillMaxY, extMinZ, extTopMaxU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, fillMaxY, extMinZ, extTopMinU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMinY + 0.01f, extMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY + 0.01f, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY + 0.01f, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMinX, extMinY + 0.01f, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extBottomMinU, extBottomMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int meta) {
        if (meta == 1) {
            return this.jarFull;
        }
        return this.jarEmpty;
    }
}

