/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;
import org.lwjgl.opengl.GL11;

public class BlockModelLayer<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelLayer(Block<T> block) {
        super(block);
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Override
    public void renderStandalone(@NotNull Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        GL11.glTranslatef(0.0f, 0.25f, 0.0f);
        super.renderStandalone(tessellator, metadata, brightness, alpha, lightmapCoordinate);
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePos tilePos, @NotNull Side side, int meta) {
        if (!side.isVertical() && source.getBlockId(tilePos) == this.block.id() && source.getBlockData(tilePos) == meta) {
            return false;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

