/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import java.util.Map;
import java.util.Random;
import net.minecraft.client.render.block.model.BlockModelAxisAligned;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;

public class BlockModelMatcher<T extends BlockLogic>
extends BlockModelAxisAligned<T> {
    public IconCoordinate[] frontVariants;
    public IconCoordinate[] frontOverlayVariants;
    public final Random random = new Random();

    public BlockModelMatcher(Block<T> block, boolean isPowered) {
        super(block);
        this.frontVariants = new IconCoordinate[4];
        this.frontOverlayVariants = new IconCoordinate[this.frontVariants.length];
        for (int i = 0; i < this.frontVariants.length; ++i) {
            this.frontVariants[i] = TextureRegistry.getTexture("minecraft:block/matcher/front" + (isPowered ? "_active" : "") + i);
            this.frontOverlayVariants[i] = TextureRegistry.getTexture("minecraft:block/matcher/front" + (isPowered ? "_active" : "") + "_overlay" + i);
        }
        for (Map.Entry e : this.displayPosMap.entrySet()) {
            DisplayPos p = (DisplayPos)this.displayPosMap.get(e.getKey());
            boolean flip = ((String)e.getKey()).equals("firstperson_righthand") || ((String)e.getKey()).equals("thirdperson_righthand") || ((String)e.getKey()).equals("thirdperson_lefthand");
            this.displayPosMap.put((String)e.getKey(), new DisplayPos(p.tx, p.ty, p.tz, p.rx, p.ry + (float)(flip ? -90 : 90), p.rz, p.sx, p.sy, p.sz));
        }
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        Side rotated = this.getRotatedSide(side, source.getBlockData(tilePos));
        if (rotated.getAxis() == Axis.Y) {
            this.random.setSeed(this.getPositionalSeed(tilePos));
            return this.frontVariants[this.random.nextInt(this.frontVariants.length)];
        }
        return super.getBlockTexture(source, tilePos, side);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockOverbrightTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        Side rotated = this.getRotatedSide(side, source.getBlockData(tilePos));
        if (rotated.getAxis() == Axis.Y) {
            this.random.setSeed(this.getPositionalSeed(tilePos));
            return this.frontOverlayVariants[this.random.nextInt(this.frontVariants.length)];
        }
        return super.getBlockOverbrightTexture(source, tilePos, side);
    }

    public long getPositionalSeed(@NotNull TilePosc tilePos) {
        return (long)tilePos.x() * 374761393L + (long)tilePos.y() * 668265263L + (long)tilePos.z() * 968290493L;
    }
}

